/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezgenerators;

import com.skyblockexp.ezgenerators.command.GeneratorCommand;
import com.skyblockexp.ezgenerators.command.MySQLGeneratorData;
import com.skyblockexp.ezgenerators.command.PlayerGeneratorData;
import com.skyblockexp.ezgenerators.command.PlayerGeneratorDataFile;
import com.skyblockexp.ezgenerators.libs.org.bstats.bukkit.Metrics;
import com.skyblockexp.ezgenerators.listener.CobbleGeneratorListener;
import com.skyblockexp.ezgenerators.upgrade.BasaltGeneratorUpgradeServiceImpl;
import com.skyblockexp.ezgenerators.upgrade.CobbleGeneratorUpgradeServiceImpl;
import com.skyblockexp.ezgenerators.upgrade.ObsidianGeneratorUpgradeServiceImpl;
import com.skyblockexp.island.upgrade.BasaltGeneratorUpgradeService;
import com.skyblockexp.island.upgrade.CobbleGeneratorUpgradeService;
import com.skyblockexp.island.upgrade.ObsidianGeneratorUpgradeService;
import java.io.File;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;

public final class EzGeneratorsPlugin
extends JavaPlugin {
    private CobbleGeneratorUpgradeService cobbleService;
    private BasaltGeneratorUpgradeService basaltService;
    private ObsidianGeneratorUpgradeService obsidianService;
    private PlayerGeneratorData playerGeneratorData;

    public void onEnable() {
        this.saveDefaultConfig();
        this.saveResourceIfMissing("cobblestone.yml");
        this.saveResourceIfMissing("basalt.yml");
        this.saveResourceIfMissing("obsidian.yml");
        this.saveResourceIfMissing("mysql.yml");
        this.saveResourceIfMissing("player-generators.yml");
        this.reloadConfig();
        this.cobbleService = new CobbleGeneratorUpgradeServiceImpl(this);
        this.basaltService = new BasaltGeneratorUpgradeServiceImpl(this);
        this.obsidianService = new ObsidianGeneratorUpgradeServiceImpl(this);
        boolean mysqlEnabled = this.getConfig().getBoolean("mysql.enabled", false);
        if (mysqlEnabled) {
            String host = this.getConfig().getString("mysql.host", "localhost");
            int port = this.getConfig().getInt("mysql.port", 3306);
            String database = this.getConfig().getString("mysql.database", "ezgenerators");
            String user = this.getConfig().getString("mysql.user", "root");
            String password = this.getConfig().getString("mysql.password", "");
            String table = this.getConfig().getString("mysql.table", "player_generators");
            this.playerGeneratorData = new MySQLGeneratorData(host, port, database, user, password, table);
            this.getLogger().info("Using MySQL storage for player generator levels.");
        } else {
            File dataFile = new File(this.getDataFolder(), "player-generators.yml");
            this.playerGeneratorData = new PlayerGeneratorDataFile(dataFile);
            this.getLogger().info("Using file storage for player generator levels.");
        }
        this.getServer().getServicesManager().register(CobbleGeneratorUpgradeService.class, (Object)this.cobbleService, (Plugin)this, ServicePriority.Normal);
        this.getServer().getServicesManager().register(BasaltGeneratorUpgradeService.class, (Object)this.basaltService, (Plugin)this, ServicePriority.Normal);
        this.getServer().getServicesManager().register(ObsidianGeneratorUpgradeService.class, (Object)this.obsidianService, (Plugin)this, ServicePriority.Normal);
        this.getServer().getPluginManager().registerEvents((Listener)new CobbleGeneratorListener(this.cobbleService, this.basaltService, this.obsidianService, this.getConfig()), (Plugin)this);
        if (this.getCommand("generators") != null) {
            this.getCommand("generators").setExecutor((CommandExecutor)new GeneratorCommand(this, this.cobbleService, this.basaltService, this.obsidianService));
        }
        if (this.getCommand("generator") != null) {
            this.getCommand("generator").setExecutor((CommandExecutor)new GeneratorCommand(this, this.cobbleService, this.basaltService, this.obsidianService));
        }
        this.initializeMetrics();
        this.getLogger().info("EzGenerators enabled.");
    }

    public PlayerGeneratorData getPlayerGeneratorData() {
        return this.playerGeneratorData;
    }

    public void onDisable() {
        HandlerList.unregisterAll((Plugin)this);
        this.getServer().getServicesManager().unregisterAll((Plugin)this);
        this.cobbleService = null;
        this.basaltService = null;
        this.obsidianService = null;
        this.getLogger().info("EzGenerators disabled.");
    }

    private void initializeMetrics() {
        try {
            new Metrics(this, 27746);
        }
        catch (Throwable throwable) {
            this.getLogger().warning("Failed to start bStats metrics: " + throwable.getMessage());
        }
    }

    public void reloadAllConfigs() {
        this.reloadConfig();
        this.cobbleService = new CobbleGeneratorUpgradeServiceImpl(this);
        this.basaltService = new BasaltGeneratorUpgradeServiceImpl(this);
        this.obsidianService = new ObsidianGeneratorUpgradeServiceImpl(this);
        PlayerGeneratorData playerGeneratorData = this.playerGeneratorData;
        if (playerGeneratorData instanceof PlayerGeneratorDataFile) {
            PlayerGeneratorDataFile fileData = (PlayerGeneratorDataFile)playerGeneratorData;
            fileData.reload();
        }
        this.getLogger().info("All EzGenerators config files reloaded.");
    }

    private void saveResourceIfMissing(String resource) {
        File outFile = new File(this.getDataFolder(), resource);
        if (!outFile.exists()) {
            if (this.getResource(resource) == null) {
                this.getLogger().severe("Default resource '" + resource + "' not found in plugin JAR! This file will not be created.");
                return;
            }
            this.saveResource(resource, false);
        }
    }
}

