/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.common.util;

import java.util.Locale;
import org.bukkit.Particle;

public final class ParticleCompatibility {
    private static final Particle DEFAULT_FALLBACK = Particle.PORTAL;
    private static final Particle ENCHANTMENT_TABLE = ParticleCompatibility.resolve("ENCHANTMENT_TABLE", "ENCHANTING_TABLE");
    private static final Particle WITCH = ParticleCompatibility.resolve("SPELL_WITCH", "WITCH");
    private static final Particle MAGIC_CRIT = ParticleCompatibility.resolve("CRIT_MAGIC", "ENCHANTED_HIT");
    private static final Particle REDSTONE = ParticleCompatibility.resolve("REDSTONE", "DUST");
    private static final Particle FIREWORK_SPARK = ParticleCompatibility.resolve("FIREWORKS_SPARK", "FIREWORK");
    private static final Particle VILLAGER_HAPPY = ParticleCompatibility.resolve("VILLAGER_HAPPY", "HAPPY_VILLAGER");

    private ParticleCompatibility() {
    }

    public static Particle enchantmentTable() {
        return ENCHANTMENT_TABLE;
    }

    public static Particle witchSpell() {
        return WITCH;
    }

    public static Particle magicCrit() {
        return MAGIC_CRIT;
    }

    public static Particle redstone() {
        return REDSTONE;
    }

    public static Particle fireworkSpark() {
        return FIREWORK_SPARK;
    }

    public static Particle villagerHappy() {
        return VILLAGER_HAPPY;
    }

    private static Particle resolve(String ... candidateNames) {
        if (candidateNames != null) {
            for (String candidate : candidateNames) {
                if (candidate == null || candidate.isBlank()) continue;
                String normalized = candidate.trim().toUpperCase(Locale.ROOT);
                try {
                    return Particle.valueOf((String)normalized);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return DEFAULT_FALLBACK;
    }
}

