/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.common.registry;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class ListenerRegistry {
    private final JavaPlugin plugin;
    private final List<Listener> listeners = new ArrayList<Listener>();

    public ListenerRegistry(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void register(Listener listener) {
        this.plugin.getServer().getPluginManager().registerEvents(listener, (Plugin)this.plugin);
        this.listeners.add(listener);
    }

    public void unregister(Listener listener) {
        if (listener == null) {
            return;
        }
        HandlerList.unregisterAll((Listener)listener);
        this.listeners.remove(listener);
    }

    public void unregisterAll() {
        for (Listener listener : this.listeners) {
            HandlerList.unregisterAll((Listener)listener);
        }
        this.listeners.clear();
    }
}

