/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.common.registry;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.java.JavaPlugin;

public final class CommandRegistry {
    private final JavaPlugin plugin;
    private final List<PluginCommand> registeredCommands = new ArrayList<PluginCommand>();

    public CommandRegistry(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void register(String name, CommandExecutor executor, TabCompleter completer) {
        PluginCommand command = this.plugin.getCommand(name);
        if (command != null) {
            command.setExecutor(executor);
            command.setTabCompleter(completer);
            this.registeredCommands.add(command);
        } else {
            this.plugin.getLogger().severe("Failed to register /" + name + " command: command not defined in plugin.yml");
        }
    }

    public void unregisterAll() {
        for (PluginCommand command : this.registeredCommands) {
            command.setExecutor(null);
            command.setTabCompleter(null);
        }
        this.registeredCommands.clear();
    }
}

