/*
 * Decompiled with CFR 0.152.
 */
package com.ezflytime.voucher;

import com.ezflytime.EzFlyTimePlugin;
import com.ezflytime.storage.VoucherStorage;
import com.ezflytime.util.Hand;
import com.ezflytime.util.InteractionHandResolver;
import com.ezflytime.util.MaterialResolver;
import com.ezflytime.util.OnlinePlayers;
import com.ezflytime.util.PlayerInventoryAccessor;
import com.ezflytime.voucher.FlyVoucher;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class VoucherManager
implements Listener {
    private final EzFlyTimePlugin plugin;
    private final Map<String, FlyVoucher> vouchers = new HashMap<String, FlyVoucher>();
    private boolean dupeDetectionEnabled;
    private static final long RECENT_USE_WINDOW_MS = 150L;
    private final Set<String> consumedVoucherIds = new HashSet<String>();
    private final VoucherStorage storage;
    private final Map<UUID, LastVoucherUse> recentMainHandUses = new HashMap<UUID, LastVoucherUse>();
    private static final String DUPLICATE_ALERT_PERMISSION = "ezflytime.notify";
    private final Queue<String> pendingDuplicateAlerts = new ArrayDeque<String>();

    public VoucherManager(EzFlyTimePlugin plugin, VoucherStorage storage) {
        this.plugin = plugin;
        this.storage = storage;
        this.consumedVoucherIds.addAll(storage.loadConsumedVoucherIds());
        this.reload();
    }

    public void reload() {
        this.vouchers.clear();
        this.dupeDetectionEnabled = this.plugin.getConfig().getBoolean("detect-voucher-dupes", true);
        ConfigurationSection section = this.plugin.getConfig().getConfigurationSection("vouchers");
        if (section == null) {
            this.plugin.getLogger().warning("No vouchers defined in config.yml");
            return;
        }
        for (String id : section.getKeys(false)) {
            ConfigurationSection voucherSection = section.getConfigurationSection(id);
            if (voucherSection == null) continue;
            Material material = MaterialResolver.resolve(voucherSection.getString("material", "PAPER"), Material.PAPER);
            if (material == null) {
                this.plugin.getLogger().warning("Invalid material for voucher " + id + ". Defaulting to PAPER.");
                material = Material.PAPER;
            }
            String name = voucherSection.getString("name", "Fly Voucher");
            int duration = voucherSection.getInt("duration-seconds", 300);
            List lore = voucherSection.getStringList("lore");
            double price = voucherSection.contains("price") ? voucherSection.getDouble("price") : -1.0;
            FlyVoucher voucher = new FlyVoucher((Plugin)this.plugin, id, material, name, lore, duration, price);
            this.vouchers.put(id.toLowerCase(), voucher);
        }
    }

    public FlyVoucher getVoucher(String id) {
        if (id == null) {
            return null;
        }
        return this.vouchers.get(id.toLowerCase());
    }

    public Set<String> getVoucherIds() {
        return Collections.unmodifiableSet(this.vouchers.keySet());
    }

    @EventHandler
    public void onVoucherUse(PlayerInteractEvent event) {
        Action action = event.getAction();
        if (action != Action.RIGHT_CLICK_AIR && action != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null) {
            return;
        }
        FlyVoucher voucher = this.getVoucherFromItem(item);
        if (voucher == null) {
            return;
        }
        Player player = event.getPlayer();
        String uniqueId = voucher.extractUniqueId(item);
        Hand hand = InteractionHandResolver.resolve(event);
        if (this.shouldIgnoreOffHand(player, hand)) {
            event.setCancelled(true);
            return;
        }
        event.setCancelled(true);
        if (this.dupeDetectionEnabled && uniqueId != null && this.consumedVoucherIds.contains(uniqueId)) {
            player.sendMessage(this.plugin.getMessage("messages.voucher-duplicate").replace("{voucher}", voucher.getDisplayName()));
            this.notifyAdminsOfDuplicate(player, voucher);
            return;
        }
        this.plugin.getFlyTimeManager().addTime(player, voucher.getDurationSeconds());
        this.consumeItem(player, hand);
        if (uniqueId != null) {
            this.consumedVoucherIds.add(uniqueId);
            this.storage.saveConsumedVoucherIds(this.consumedVoucherIds);
        }
        this.recordRecentUse(player, hand);
        player.sendMessage(this.plugin.getMessage("messages.voucher-redeemed").replace("{voucher}", voucher.getDisplayName()).replace("{minutes}", String.valueOf(voucher.getDurationSeconds() / 60)).replace("{seconds}", String.valueOf(voucher.getDurationSeconds())));
    }

    private void consumeItem(Player player, Hand hand) {
        ItemStack stack = PlayerInventoryAccessor.getItem(player, hand);
        this.decrementItem(stack, () -> PlayerInventoryAccessor.clearItem(player, hand));
    }

    private void decrementItem(ItemStack stack, Runnable emptyAction) {
        if (stack == null) {
            return;
        }
        int amount = stack.getAmount();
        if (amount <= 1) {
            emptyAction.run();
        } else {
            stack.setAmount(amount - 1);
        }
    }

    private FlyVoucher getVoucherFromItem(ItemStack item) {
        if (item == null || item.getItemMeta() == null) {
            return null;
        }
        for (FlyVoucher voucher : this.vouchers.values()) {
            if (!voucher.matches(item, this.dupeDetectionEnabled)) continue;
            return voucher;
        }
        return null;
    }

    @EventHandler
    public void onAdminJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission(DUPLICATE_ALERT_PERMISSION)) {
            return;
        }
        if (this.pendingDuplicateAlerts.isEmpty()) {
            return;
        }
        while (!this.pendingDuplicateAlerts.isEmpty()) {
            player.sendMessage(this.pendingDuplicateAlerts.poll());
        }
    }

    public void saveData() {
        this.storage.saveConsumedVoucherIds(this.consumedVoucherIds);
    }

    public boolean isVoucherIdConsumed(String uniqueId) {
        return uniqueId != null && this.consumedVoucherIds.contains(uniqueId);
    }

    private void recordRecentUse(Player player, Hand hand) {
        if (hand == Hand.MAIN_HAND) {
            this.recentMainHandUses.put(player.getUniqueId(), new LastVoucherUse(System.currentTimeMillis()));
        } else {
            this.recentMainHandUses.remove(player.getUniqueId());
        }
    }

    private boolean shouldIgnoreOffHand(Player player, Hand hand) {
        if (hand != Hand.OFF_HAND) {
            return false;
        }
        LastVoucherUse lastUse = this.recentMainHandUses.get(player.getUniqueId());
        if (lastUse == null) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (now - lastUse.getTimestamp() > 150L) {
            this.recentMainHandUses.remove(player.getUniqueId());
            return false;
        }
        this.recentMainHandUses.remove(player.getUniqueId());
        return true;
    }

    private void notifyAdminsOfDuplicate(Player player, FlyVoucher voucher) {
        String alertMessage = this.plugin.getMessage("messages.voucher-duplicate-alert").replace("{player}", player.getName()).replace("{voucher}", voucher.getDisplayName());
        boolean delivered = false;
        for (Player onlinePlayer : OnlinePlayers.getOnlinePlayers()) {
            if (!onlinePlayer.hasPermission(DUPLICATE_ALERT_PERMISSION)) continue;
            onlinePlayer.sendMessage(alertMessage);
            delivered = true;
        }
        if (!delivered) {
            this.pendingDuplicateAlerts.add(alertMessage);
        }
    }

    private static class LastVoucherUse {
        private final long timestamp;

        private LastVoucherUse(long timestamp) {
            this.timestamp = timestamp;
        }

        private long getTimestamp() {
            return this.timestamp;
        }
    }
}

