/*
 * Decompiled with CFR 0.152.
 */
package com.ezflytime.voucher;

import com.ezflytime.voucher.VoucherMetadataHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

class PdcVoucherMetadataHandler
implements VoucherMetadataHandler {
    private final Plugin plugin;
    private final Method getPersistentDataContainer;
    private final Method setMethod;
    private final Method getMethod;
    private final Constructor<?> namespacedKeyConstructor;
    private final Object stringType;
    private final Object integerType;

    @Override
    public int readVoucherDuration(ItemMeta meta) {
        Object value = this.read(meta, "voucher-duration", this.integerType);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return -1;
    }

    PdcVoucherMetadataHandler(Plugin plugin) throws Exception {
        this.plugin = plugin;
        Class<?> namespacedKeyClass = Class.forName("org.bukkit.NamespacedKey");
        Class<?> persistentDataContainerClass = Class.forName("org.bukkit.persistence.PersistentDataContainer");
        Class<?> persistentDataTypeClass = Class.forName("org.bukkit.persistence.PersistentDataType");
        this.getPersistentDataContainer = ItemMeta.class.getMethod("getPersistentDataContainer", new Class[0]);
        this.setMethod = persistentDataContainerClass.getMethod("set", namespacedKeyClass, persistentDataTypeClass, Object.class);
        this.getMethod = persistentDataContainerClass.getMethod("get", namespacedKeyClass, persistentDataTypeClass);
        this.namespacedKeyConstructor = namespacedKeyClass.getConstructor(Plugin.class, String.class);
        Field stringField = persistentDataTypeClass.getField("STRING");
        Field integerField = persistentDataTypeClass.getField("INTEGER");
        this.stringType = stringField.get(null);
        this.integerType = integerField.get(null);
    }

    @Override
    public void apply(ItemMeta meta, String voucherId, int durationSeconds, String uniqueId) {
        if (meta == null) {
            return;
        }
        try {
            Object container = this.getPersistentDataContainer.invoke((Object)meta, new Object[0]);
            this.setMethod.invoke(container, this.createKey("voucher-id"), this.stringType, voucherId);
            this.setMethod.invoke(container, this.createKey("voucher-duration"), this.integerType, durationSeconds);
            this.setMethod.invoke(container, this.createKey("voucher-unique-id"), this.stringType, uniqueId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String readVoucherId(ItemMeta meta) {
        Object value = this.read(meta, "voucher-id", this.stringType);
        return value != null ? value.toString() : null;
    }

    @Override
    public String readUniqueId(ItemMeta meta) {
        Object value = this.read(meta, "voucher-unique-id", this.stringType);
        return value != null ? value.toString() : null;
    }

    private Object read(ItemMeta meta, String key, Object type) {
        if (meta == null) {
            return null;
        }
        try {
            Object container = this.getPersistentDataContainer.invoke((Object)meta, new Object[0]);
            return this.getMethod.invoke(container, this.createKey(key), type);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private Object createKey(String value) throws Exception {
        return this.namespacedKeyConstructor.newInstance(this.plugin, value);
    }
}

