/*
 * Decompiled with CFR 0.152.
 */
package com.ezflytime.voucher;

import com.ezflytime.voucher.VoucherMetadataHandler;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.inventory.meta.ItemMeta;

class LegacyVoucherMetadataHandler
implements VoucherMetadataHandler {
    private static final String RAW_PREFIX = "EzFlyTime:";

    LegacyVoucherMetadataHandler() {
    }

    @Override
    public int readVoucherDuration(ItemMeta meta) {
        String[] data = this.readData(meta);
        if (data != null && data.length > 1) {
            try {
                return Integer.parseInt(data[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    @Override
    public void apply(ItemMeta meta, String voucherId, int durationSeconds, String uniqueId) {
        if (meta == null) {
            return;
        }
        ArrayList<CallSite> lore = meta.getLore();
        lore = lore == null ? new ArrayList<CallSite>() : new ArrayList(lore);
        String dataLine = String.valueOf(ChatColor.DARK_GRAY) + RAW_PREFIX + voucherId + ":" + durationSeconds + ":" + uniqueId;
        lore.add((CallSite)((Object)dataLine));
        meta.setLore(lore);
    }

    @Override
    public String readVoucherId(ItemMeta meta) {
        String[] data = this.readData(meta);
        return data != null ? data[0] : null;
    }

    @Override
    public String readUniqueId(ItemMeta meta) {
        String[] data = this.readData(meta);
        return data != null ? data[2] : null;
    }

    private String[] readData(ItemMeta meta) {
        if (meta == null || !meta.hasLore()) {
            return null;
        }
        List lore = meta.getLore();
        if (lore == null) {
            return null;
        }
        for (String line : lore) {
            String payload;
            String[] parts;
            String stripped;
            if (line == null || (stripped = ChatColor.stripColor((String)line)) == null || !stripped.startsWith(RAW_PREFIX) || (parts = (payload = stripped.substring(RAW_PREFIX.length())).split(":", 3)).length != 3) continue;
            return parts;
        }
        return null;
    }
}

