/*
 * Decompiled with CFR 0.152.
 */
package com.ezflytime.voucher;

import com.ezflytime.voucher.VoucherMetadataHandler;
import com.ezflytime.voucher.VoucherMetadataHandlers;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class FlyVoucher {
    private final Plugin plugin;
    private final VoucherMetadataHandler metadataHandler;
    private final String id;
    private final Material material;
    private final String displayName;
    private final List<String> lore;
    private final int durationSeconds;
    private final double price;

    public FlyVoucher(Plugin plugin, String id, Material material, String displayName, List<String> lore, int durationSeconds, double price) {
        this.plugin = plugin;
        this.metadataHandler = VoucherMetadataHandlers.resolve(plugin);
        this.id = id;
        this.material = material;
        String minutes = String.valueOf(durationSeconds / 60);
        String seconds = String.valueOf(durationSeconds);
        this.displayName = ChatColor.translateAlternateColorCodes((char)'&', (String)displayName.replace("{minutes}", minutes).replace("{seconds}", seconds));
        this.lore = new ArrayList<String>();
        lore.forEach(line -> this.lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line.replace("{minutes}", minutes).replace("{seconds}", seconds))));
        this.durationSeconds = durationSeconds;
        this.price = price;
    }

    public double getPrice() {
        return this.price;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getDurationSeconds() {
        return this.durationSeconds;
    }

    public ItemStack createItem() {
        ItemStack item = new ItemStack(this.material, 1);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(this.displayName);
            meta.setLore(this.lore);
            this.applyItemFlags(meta);
            this.metadataHandler.apply(meta, this.id, this.durationSeconds, UUID.randomUUID().toString());
            item.setItemMeta(meta);
        }
        return item;
    }

    public ItemStack[] createItems(int amount) {
        if (amount <= 0) {
            return new ItemStack[0];
        }
        ItemStack[] items = new ItemStack[amount];
        for (int i = 0; i < amount; ++i) {
            items[i] = this.createItem();
        }
        return items;
    }

    public boolean matches(ItemStack item) {
        return this.matches(item, true);
    }

    public boolean matches(ItemStack item, boolean requireIdMatch) {
        if (item == null || item.getType() != this.material) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        if (requireIdMatch) {
            String storedId = this.metadataHandler.readVoucherId(meta);
            return storedId != null && this.id.equalsIgnoreCase(storedId);
        }
        if (!meta.hasDisplayName()) {
            return false;
        }
        return ChatColor.stripColor((String)meta.getDisplayName()).equalsIgnoreCase(ChatColor.stripColor((String)this.displayName));
    }

    public String extractUniqueId(ItemStack item) {
        if (item == null) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return null;
        }
        return this.metadataHandler.readUniqueId(meta);
    }

    private void applyItemFlags(ItemMeta meta) {
        try {
            Class<?> itemFlagClass = Class.forName("org.bukkit.inventory.ItemFlag");
            Object hideEnchants = Enum.valueOf(itemFlagClass, "HIDE_ENCHANTS");
            Method addItemFlags = meta.getClass().getMethod("addItemFlags", Array.newInstance(itemFlagClass, 0).getClass());
            Object flagArray = Array.newInstance(itemFlagClass, 1);
            Array.set(flagArray, 0, hideEnchants);
            addItemFlags.invoke((Object)meta, flagArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

