/*
 * Decompiled with CFR 0.152.
 */
package com.ezflytime.util;

import com.ezflytime.util.Hand;
import java.lang.reflect.Method;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public final class PlayerInventoryAccessor {
    private static final Method GET_MAIN_HAND = PlayerInventoryAccessor.resolveMethod(PlayerInventory.class, "getItemInMainHand", new Class[0]);
    private static final Method SET_MAIN_HAND = PlayerInventoryAccessor.resolveMethod(PlayerInventory.class, "setItemInMainHand", ItemStack.class);
    private static final Method GET_OFF_HAND = PlayerInventoryAccessor.resolveMethod(PlayerInventory.class, "getItemInOffHand", new Class[0]);
    private static final Method SET_OFF_HAND = PlayerInventoryAccessor.resolveMethod(PlayerInventory.class, "setItemInOffHand", ItemStack.class);

    private PlayerInventoryAccessor() {
    }

    public static ItemStack getItem(Player player, Hand hand) {
        ItemStack offHand;
        if (player == null) {
            return null;
        }
        PlayerInventory inventory = player.getInventory();
        if (hand == Hand.OFF_HAND && (offHand = PlayerInventoryAccessor.invokeItemStack(GET_OFF_HAND, inventory)) != null) {
            return offHand;
        }
        ItemStack mainHand = PlayerInventoryAccessor.invokeItemStack(GET_MAIN_HAND, inventory);
        if (mainHand != null) {
            return mainHand;
        }
        return inventory.getItemInHand();
    }

    public static void clearItem(Player player, Hand hand) {
        PlayerInventoryAccessor.setItem(player, hand, null);
    }

    public static void setItem(Player player, Hand hand, ItemStack item) {
        if (player == null) {
            return;
        }
        PlayerInventory inventory = player.getInventory();
        if (hand == Hand.OFF_HAND && SET_OFF_HAND != null) {
            PlayerInventoryAccessor.invokeVoid(SET_OFF_HAND, inventory, item);
            return;
        }
        if (SET_MAIN_HAND != null) {
            PlayerInventoryAccessor.invokeVoid(SET_MAIN_HAND, inventory, item);
            return;
        }
        inventory.setItemInHand(item);
    }

    public static boolean supportsOffHand() {
        return GET_OFF_HAND != null && SET_OFF_HAND != null;
    }

    private static Method resolveMethod(Class<?> type, String name, Class<?> ... parameters) {
        try {
            return type.getMethod(name, parameters);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    private static ItemStack invokeItemStack(Method method, Object target) {
        if (method == null) {
            return null;
        }
        try {
            return (ItemStack)method.invoke(target, new Object[0]);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private static void invokeVoid(Method method, Object target, Object argument) {
        if (method == null) {
            return;
        }
        try {
            method.invoke(target, argument);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

