/*
 * Decompiled with CFR 0.152.
 */
package com.ezflytime.util;

import java.lang.reflect.Method;
import java.util.Locale;
import org.bukkit.Material;

public final class MaterialResolver {
    private static final Method MATCH_MATERIAL = MaterialResolver.resolveMatchMaterial();

    private MaterialResolver() {
    }

    public static Material resolve(String name, Material fallback) {
        if (name == null || name.trim().isEmpty()) {
            return fallback;
        }
        Material resolved = null;
        if (MATCH_MATERIAL != null) {
            try {
                resolved = (Material)MATCH_MATERIAL.invoke(null, name);
            }
            catch (Exception ignored) {
                resolved = null;
            }
        }
        if (resolved == null) {
            resolved = Material.getMaterial((String)name.trim().toUpperCase(Locale.ROOT));
        }
        return resolved != null ? resolved : fallback;
    }

    private static Method resolveMatchMaterial() {
        try {
            return Material.class.getMethod("matchMaterial", String.class);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }
}

