/*
 * Decompiled with CFR 0.152.
 */
package com.ezflytime.util;

import com.ezflytime.util.Hand;
import java.lang.reflect.Method;
import org.bukkit.event.player.PlayerInteractEvent;

public final class InteractionHandResolver {
    private static final Method GET_HAND_METHOD = InteractionHandResolver.resolveGetHandMethod();

    private InteractionHandResolver() {
    }

    public static Hand resolve(PlayerInteractEvent event) {
        if (GET_HAND_METHOD == null || event == null) {
            return Hand.MAIN_HAND;
        }
        try {
            Object hand = GET_HAND_METHOD.invoke((Object)event, new Object[0]);
            if (hand != null && "OFF_HAND".equalsIgnoreCase(hand.toString())) {
                return Hand.OFF_HAND;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Hand.MAIN_HAND;
    }

    private static Method resolveGetHandMethod() {
        try {
            return PlayerInteractEvent.class.getMethod("getHand", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }
}

