/*
 * Decompiled with CFR 0.152.
 */
package com.ezflytime.util;

import java.lang.reflect.Method;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public final class FlightSupport {
    private static final Method IS_GLIDING = FlightSupport.resolveMethod(Player.class, "isGliding", new Class[0]);
    private static final Method SET_GLIDING = FlightSupport.resolveMethod(Player.class, "setGliding", Boolean.TYPE);

    private FlightSupport() {
    }

    public static boolean supportsGliding() {
        return IS_GLIDING != null && SET_GLIDING != null;
    }

    public static boolean isGliding(Player player) {
        if (IS_GLIDING == null || player == null) {
            return false;
        }
        try {
            return (Boolean)IS_GLIDING.invoke((Object)player, new Object[0]);
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public static void setGliding(Player player, boolean gliding) {
        if (SET_GLIDING == null || player == null) {
            return;
        }
        try {
            SET_GLIDING.invoke((Object)player, gliding);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean supportsElytra() {
        return Material.getMaterial((String)"ELYTRA") != null;
    }

    private static Method resolveMethod(Class<?> type, String name, Class<?> ... parameters) {
        try {
            return type.getMethod(name, parameters);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }
}

