/*
 * Decompiled with CFR 0.152.
 */
package com.ezflytime.storage;

import com.ezflytime.EzFlyTimePlugin;
import com.ezflytime.storage.VoucherStorage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.configuration.file.YamlConfiguration;

public class YamlVoucherStorage
implements VoucherStorage {
    private final EzFlyTimePlugin plugin;
    private final File consumedVoucherFile;

    public YamlVoucherStorage(EzFlyTimePlugin plugin) {
        this.plugin = plugin;
        this.consumedVoucherFile = new File(plugin.getDataFolder(), "consumed-vouchers.yml");
        if (!this.consumedVoucherFile.exists()) {
            try {
                this.consumedVoucherFile.getParentFile().mkdirs();
                this.consumedVoucherFile.createNewFile();
            }
            catch (IOException e) {
                plugin.getLogger().log(Level.SEVERE, "Could not create consumed-vouchers.yml", e);
            }
        }
    }

    @Override
    public Set<String> loadConsumedVoucherIds() {
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)this.consumedVoucherFile);
        return new HashSet<String>(configuration.getStringList("consumed"));
    }

    @Override
    public void saveConsumedVoucherIds(Set<String> consumedVoucherIds) {
        YamlConfiguration configuration = new YamlConfiguration();
        configuration.set("consumed", new ArrayList<String>(consumedVoucherIds));
        try {
            configuration.save(this.consumedVoucherFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save consumed-vouchers.yml", e);
        }
    }
}

