/*
 * Decompiled with CFR 0.152.
 */
package com.ezflytime.storage;

import com.ezflytime.EzFlyTimePlugin;
import com.ezflytime.storage.FlyTimeStorage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class YamlFlyTimeStorage
implements FlyTimeStorage {
    private final EzFlyTimePlugin plugin;
    private final File dataFolder;
    private final File legacyDataFile;

    public YamlFlyTimeStorage(EzFlyTimePlugin plugin) {
        this.plugin = plugin;
        this.dataFolder = new File(plugin.getDataFolder(), "flytime-data");
        if (!this.dataFolder.exists() && !this.dataFolder.mkdirs()) {
            plugin.getLogger().severe("Could not create flytime-data directory at " + this.dataFolder.getAbsolutePath());
        }
        this.legacyDataFile = new File(plugin.getDataFolder(), "flytime-data.yml");
        if (this.legacyDataFile.exists() && this.legacyDataFile.isFile()) {
            this.migrateLegacyDataFile();
        }
    }

    @Override
    public Map<UUID, Integer> loadFlyTimes() {
        HashMap<UUID, Integer> remainingSeconds = new HashMap<UUID, Integer>();
        if (!this.dataFolder.exists()) {
            return remainingSeconds;
        }
        File[] playerFiles = this.dataFolder.listFiles((dir, name) -> name.toLowerCase(Locale.ROOT).endsWith(".yml"));
        if (playerFiles == null) {
            return remainingSeconds;
        }
        for (File playerFile : playerFiles) {
            String fileName = playerFile.getName();
            if (fileName.length() <= 4) {
                this.plugin.getLogger().severe("Ignoring invalid flytime data file name: " + fileName);
                continue;
            }
            String uuidPart = fileName.substring(0, fileName.length() - 4);
            try {
                UUID playerId = UUID.fromString(uuidPart);
                YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)playerFile);
                int seconds = configuration.getInt("seconds", 0);
                if (seconds <= 0) continue;
                remainingSeconds.put(playerId, seconds);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().severe("Ignoring invalid flytime data file name: " + fileName);
            }
        }
        return remainingSeconds;
    }

    @Override
    public void saveFlyTimes(Map<UUID, Integer> remainingSeconds) {
        if (!this.dataFolder.exists() && !this.dataFolder.mkdirs()) {
            this.plugin.getLogger().severe("Could not create flytime-data directory at " + this.dataFolder.getAbsolutePath());
            return;
        }
        File[] existingFilesArray = this.dataFolder.listFiles((dir, name) -> name.toLowerCase(Locale.ROOT).endsWith(".yml"));
        HashSet<String> remainingFiles = new HashSet<String>();
        if (existingFilesArray != null) {
            for (File file : existingFilesArray) {
                remainingFiles.add(file.getName());
            }
        }
        for (Map.Entry entry : remainingSeconds.entrySet()) {
            File playerFile = new File(this.dataFolder, String.valueOf(entry.getKey()) + ".yml");
            remainingFiles.remove(playerFile.getName());
            int seconds = (Integer)entry.getValue();
            if (seconds > 0) {
                YamlConfiguration configuration = new YamlConfiguration();
                configuration.set("seconds", (Object)seconds);
                try {
                    configuration.save(playerFile);
                }
                catch (IOException e) {
                    this.plugin.getLogger().severe("Could not save flytime data for " + String.valueOf(entry.getKey()) + ": " + e.getMessage());
                }
                continue;
            }
            if (!playerFile.exists() || playerFile.delete()) continue;
            this.plugin.getLogger().severe("Could not delete flytime data file for " + String.valueOf(entry.getKey()));
        }
        for (String string : remainingFiles) {
            File file = new File(this.dataFolder, string);
            if (file.delete()) continue;
            this.plugin.getLogger().severe("Could not delete obsolete flytime data file " + file.getName());
        }
    }

    private void migrateLegacyDataFile() {
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)this.legacyDataFile);
        if (!configuration.contains("players")) {
            if (!this.legacyDataFile.delete()) {
                this.plugin.getLogger().severe("Could not delete legacy flytime-data.yml file at " + this.legacyDataFile.getAbsolutePath());
            }
            return;
        }
        HashMap<UUID, Integer> legacyData = new HashMap<UUID, Integer>();
        ConfigurationSection playersSection = configuration.getConfigurationSection("players");
        if (playersSection == null) {
            if (!this.legacyDataFile.delete()) {
                this.plugin.getLogger().severe("Could not delete legacy flytime-data.yml file at " + this.legacyDataFile.getAbsolutePath());
            }
            return;
        }
        for (String key : playersSection.getKeys(false)) {
            try {
                UUID playerId = UUID.fromString(key);
                int seconds = configuration.getInt("players." + key + ".seconds", 0);
                if (seconds <= 0) continue;
                legacyData.put(playerId, seconds);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().severe("Skipping invalid UUID in legacy flytime-data.yml: " + key);
            }
        }
        this.saveFlyTimes(legacyData);
        File backupFile = new File(this.plugin.getDataFolder(), "flytime-data.yml.legacy");
        if (!this.legacyDataFile.renameTo(backupFile) && !this.legacyDataFile.delete()) {
            this.plugin.getLogger().severe("Could not remove legacy flytime-data.yml after migration");
        }
    }
}

