/*
 * Decompiled with CFR 0.152.
 */
package com.ezflytime.placeholder;

import com.ezflytime.EzFlyTimePlugin;
import com.ezflytime.flight.FlyTimeManager;
import java.time.Duration;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlyTimePlaceholderExpansion
extends PlaceholderExpansion {
    private final EzFlyTimePlugin plugin;

    public FlyTimePlaceholderExpansion(EzFlyTimePlugin plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public String getIdentifier() {
        return "ezflytime";
    }

    @NotNull
    public String getAuthor() {
        List authors = this.plugin.getDescription().getAuthors();
        if (!authors.isEmpty()) {
            return String.join((CharSequence)", ", authors);
        }
        return this.plugin.getDescription().getName();
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    public String onPlaceholderRequest(Player player, @NotNull String params) {
        return this.handleRequest(player == null ? null : player.getUniqueId(), params);
    }

    public String onRequest(OfflinePlayer player, @NotNull String params) {
        return this.handleRequest(player == null ? null : player.getUniqueId(), params);
    }

    @Nullable
    private String handleRequest(@Nullable UUID uuid, String params) {
        if (uuid == null) {
            return "";
        }
        FlyTimeManager flyTimeManager = this.plugin.getFlyTimeManager();
        if (flyTimeManager == null) {
            return "";
        }
        int remainingSeconds = flyTimeManager.getRemainingSeconds(uuid);
        switch (params.toLowerCase(Locale.ROOT)) {
            case "seconds": 
            case "time_remaining_raw": {
                return String.valueOf(remainingSeconds);
            }
            case "minutes": {
                return String.valueOf(remainingSeconds / 60);
            }
            case "formatted": 
            case "time_remaining": {
                return this.formatSeconds(remainingSeconds);
            }
        }
        return null;
    }

    private String formatSeconds(int totalSeconds) {
        if (totalSeconds <= 0) {
            return "00:00";
        }
        Duration duration = Duration.ofSeconds(totalSeconds);
        long hours = duration.toHours();
        int minutes = duration.toMinutesPart();
        int seconds = duration.toSecondsPart();
        if (hours > 0L) {
            return String.format(Locale.ROOT, "%02d:%02d:%02d", hours, minutes, seconds);
        }
        return String.format(Locale.ROOT, "%02d:%02d", minutes, seconds);
    }
}

