/*
 * Decompiled with CFR 0.152.
 */
package com.ezflytime.flight.autoreward;

import com.ezflytime.EzFlyTimePlugin;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

class McMMOIntegration {
    private final EzFlyTimePlugin plugin;
    private final Map<String, Object> cachedSkills = new ConcurrentHashMap<String, Object>();
    private final Set<String> missingSkills = ConcurrentHashMap.newKeySet();
    private boolean available;
    private Class<? extends Enum<?>> primarySkillEnum;
    private Method getLevelMethod;

    McMMOIntegration(EzFlyTimePlugin plugin) {
        this.plugin = plugin;
        this.refresh();
    }

    void refresh() {
        this.cachedSkills.clear();
        this.missingSkills.clear();
        this.available = false;
        this.primarySkillEnum = null;
        this.getLevelMethod = null;
        Plugin mcMMO = this.plugin.getServer().getPluginManager().getPlugin("mcMMO");
        if (mcMMO == null || !mcMMO.isEnabled()) {
            return;
        }
        try {
            Class<?> apiClass = Class.forName("com.gmail.nossr50.api.ExperienceAPI");
            Class<?> primarySkillEnum = Class.forName("com.gmail.nossr50.datatypes.skills.PrimarySkillType");
            Method getLevelMethod = apiClass.getMethod("getLevel", Player.class, primarySkillEnum);
            this.primarySkillEnum = primarySkillEnum;
            this.getLevelMethod = getLevelMethod;
            this.available = true;
        }
        catch (ClassNotFoundException | NoSuchMethodException ex) {
            this.plugin.getLogger().warning("Unable to initialize mcMMO integration: " + ex.getMessage());
        }
    }

    boolean isAvailable() {
        return this.available;
    }

    int getSkillLevel(Player player, String skillName) {
        if (!this.available) {
            return -1;
        }
        String normalized = this.normalizeSkillName(skillName);
        if (this.missingSkills.contains(normalized)) {
            return -1;
        }
        Object skillConstant = this.cachedSkills.computeIfAbsent(normalized, name -> {
            if (this.primarySkillEnum == null) {
                return null;
            }
            try {
                return Enum.valueOf(this.primarySkillEnum, name);
            }
            catch (IllegalArgumentException ex) {
                this.missingSkills.add((String)name);
                this.plugin.getLogger().warning("Unknown mcMMO skill '" + name + "'.");
                return null;
            }
        });
        if (skillConstant == null) {
            return -1;
        }
        try {
            Object result = this.getLevelMethod.invoke(null, player, skillConstant);
            if (result instanceof Number) {
                Number number = (Number)result;
                return number.intValue();
            }
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            this.plugin.getLogger().warning("Failed to retrieve mcMMO level for skill '" + normalized + "': " + ex.getMessage());
        }
        return -1;
    }

    private String normalizeSkillName(String raw) {
        return raw.trim().toUpperCase(Locale.ROOT).replace('-', '_');
    }
}

