/*
 * Decompiled with CFR 0.152.
 */
package com.ezflytime.flight.autoreward;

import com.ezflytime.EzFlyTimePlugin;
import com.ezflytime.flight.autoreward.McMMOIntegration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

class AutoRewardSettings {
    private final boolean enabled;
    private final int intervalSeconds;
    private final int baseSeconds;
    private final boolean notifyPlayers;
    private final List<RankReward> rankRewards;
    private final List<SkillReward> skillRewards;

    private AutoRewardSettings(boolean enabled, int intervalSeconds, int baseSeconds, boolean notifyPlayers, List<RankReward> rankRewards, List<SkillReward> skillRewards) {
        this.enabled = enabled;
        this.intervalSeconds = intervalSeconds;
        this.baseSeconds = baseSeconds;
        this.notifyPlayers = notifyPlayers;
        this.rankRewards = rankRewards;
        this.skillRewards = skillRewards;
    }

    static AutoRewardSettings fromConfiguration(EzFlyTimePlugin plugin) {
        FileConfiguration config = plugin.getConfig();
        ConfigurationSection section = config.getConfigurationSection("auto-flight-rewards");
        if (section == null) {
            return AutoRewardSettings.disabled();
        }
        boolean enabled = section.getBoolean("enabled", false);
        int intervalSeconds = Math.max(0, section.getInt("interval-seconds", 600));
        int baseSeconds = Math.max(0, section.getInt("base-seconds", 0));
        boolean notifyPlayers = section.getBoolean("notify-players", true);
        Logger logger = plugin.getLogger();
        ArrayList<RankReward> rankRewards = new ArrayList<RankReward>(AutoRewardSettings.parseRanks(section.getConfigurationSection("ranks"), logger));
        rankRewards.addAll(AutoRewardSettings.parsePermissionNodes(section.getConfigurationSection("permission-nodes"), logger));
        List<SkillReward> skillRewards = AutoRewardSettings.parseSkills(section.getConfigurationSection("mcmmo"), logger);
        return new AutoRewardSettings(enabled, intervalSeconds, baseSeconds, notifyPlayers, rankRewards, skillRewards);
    }

    private static AutoRewardSettings disabled() {
        return new AutoRewardSettings(false, 0, 0, true, Collections.emptyList(), Collections.emptyList());
    }

    private static List<RankReward> parseRanks(ConfigurationSection section, Logger logger) {
        if (section == null) {
            return Collections.emptyList();
        }
        ArrayList<RankReward> rewards = new ArrayList<RankReward>();
        for (String key : section.getKeys(false)) {
            ConfigurationSection rankSection = section.getConfigurationSection(key);
            if (rankSection == null) continue;
            String permission = rankSection.getString("permission");
            if (permission == null || permission.trim().isEmpty()) {
                logger.warning("Rank reward '" + key + "' is missing a permission value. Skipping.");
                continue;
            }
            int seconds = Math.max(0, rankSection.getInt("seconds", 0));
            if (seconds <= 0) continue;
            rewards.add(new RankReward(permission.trim(), seconds));
        }
        return rewards;
    }

    private static List<RankReward> parsePermissionNodes(ConfigurationSection section, Logger logger) {
        if (section == null) {
            return Collections.emptyList();
        }
        ArrayList<RankReward> rewards = new ArrayList<RankReward>();
        for (Map.Entry entry : section.getValues(false).entrySet()) {
            int seconds;
            String permission;
            String key;
            block15: {
                key = (String)entry.getKey();
                Object value = entry.getValue();
                permission = key;
                if (value instanceof Number) {
                    Number number = (Number)value;
                    seconds = number.intValue();
                } else {
                    if (value instanceof String) {
                        String stringValue = (String)value;
                        try {
                            seconds = Integer.parseInt(stringValue.trim());
                            break block15;
                        }
                        catch (NumberFormatException ex) {
                            logger.warning("Permission reward '" + key + "' has a non-numeric string value. Skipping.");
                            continue;
                        }
                    }
                    if (value instanceof ConfigurationSection) {
                        ConfigurationSection valueSection = (ConfigurationSection)value;
                        permission = valueSection.getString("permission", permission);
                        Object secondsObject = valueSection.get("seconds");
                        if (secondsObject instanceof Number) {
                            Number number = (Number)secondsObject;
                            seconds = number.intValue();
                        } else {
                            if (secondsObject instanceof String) {
                                String secondsString = (String)secondsObject;
                                try {
                                    seconds = Integer.parseInt(secondsString.trim());
                                    break block15;
                                }
                                catch (NumberFormatException ex) {
                                    logger.warning("Permission reward '" + key + "' has a non-numeric seconds value. Skipping.");
                                    continue;
                                }
                            }
                            seconds = 0;
                        }
                    } else {
                        logger.warning("Permission reward '" + key + "' has an invalid value. Skipping.");
                        continue;
                    }
                }
            }
            if (permission == null || permission.trim().isEmpty()) {
                logger.warning("Permission reward '" + key + "' is missing a permission value. Skipping.");
                continue;
            }
            if ((seconds = Math.max(0, seconds)) <= 0) continue;
            rewards.add(new RankReward(permission.trim(), seconds));
        }
        return rewards;
    }

    private static List<SkillReward> parseSkills(ConfigurationSection section, Logger logger) {
        if (section == null) {
            return Collections.emptyList();
        }
        boolean enabled = section.getBoolean("enabled", true);
        if (!enabled) {
            return Collections.emptyList();
        }
        ConfigurationSection skillsSection = section.getConfigurationSection("skills");
        if (skillsSection == null) {
            return Collections.emptyList();
        }
        ArrayList<SkillReward> rewards = new ArrayList<SkillReward>();
        for (String key : skillsSection.getKeys(false)) {
            ConfigurationSection thresholdsSection;
            ConfigurationSection skillSection = skillsSection.getConfigurationSection(key);
            if (skillSection == null || (thresholdsSection = skillSection.getConfigurationSection("thresholds")) == null) continue;
            TreeMap<Integer, Integer> thresholds = new TreeMap<Integer, Integer>();
            for (Map.Entry entry : thresholdsSection.getValues(false).entrySet()) {
                try {
                    int n;
                    int level = Integer.parseInt((String)entry.getKey());
                    Object v = entry.getValue();
                    if (v instanceof Number) {
                        Number number = (Number)v;
                        n = number.intValue();
                    } else {
                        n = Integer.parseInt(String.valueOf(entry.getValue()));
                    }
                    int seconds = Math.max(0, n);
                    if (level < 0 || seconds <= 0) continue;
                    thresholds.put(level, seconds);
                }
                catch (NumberFormatException ex) {
                    logger.warning("Invalid mcMMO threshold key '" + (String)entry.getKey() + "' for skill '" + key + "'.");
                }
            }
            if (thresholds.isEmpty()) continue;
            rewards.add(new SkillReward(key, thresholds));
        }
        return rewards;
    }

    boolean isEnabled() {
        return this.enabled;
    }

    int getIntervalSeconds() {
        return this.intervalSeconds;
    }

    int getBaseSeconds() {
        return this.baseSeconds;
    }

    boolean shouldNotifyPlayers() {
        return this.notifyPlayers;
    }

    boolean hasSkillRewards() {
        return !this.skillRewards.isEmpty();
    }

    int rankReward(Player player) {
        int total = 0;
        for (RankReward reward : this.rankRewards) {
            if (!reward.appliesTo(player)) continue;
            total += reward.getSeconds();
        }
        return total;
    }

    int skillReward(Player player, McMMOIntegration mcMMOIntegration) {
        if (!mcMMOIntegration.isAvailable()) {
            return 0;
        }
        int total = 0;
        for (SkillReward reward : this.skillRewards) {
            int level = mcMMOIntegration.getSkillLevel(player, reward.skillName());
            if (level < 0) continue;
            total += reward.secondsForLevel(level);
        }
        return total;
    }

    private static final class RankReward {
        private final String permission;
        private final int seconds;

        private RankReward(String permission, int seconds) {
            this.permission = permission;
            this.seconds = seconds;
        }

        private boolean appliesTo(Player player) {
            return player.hasPermission(this.permission);
        }

        private int getSeconds() {
            return this.seconds;
        }
    }

    private static class SkillReward {
        private final String skillName;
        private final NavigableMap<Integer, Integer> thresholds;

        SkillReward(String skillName, NavigableMap<Integer, Integer> thresholds) {
            this.skillName = skillName.trim().toUpperCase(Locale.ROOT).replace('-', '_');
            this.thresholds = thresholds;
        }

        String skillName() {
            return this.skillName;
        }

        int secondsForLevel(int level) {
            Map.Entry<Integer, Integer> entry = this.thresholds.floorEntry(level);
            if (entry == null) {
                return 0;
            }
            return entry.getValue();
        }
    }
}

