/*
 * Decompiled with CFR 0.152.
 */
package com.ezflytime.flight.autoreward;

import com.ezflytime.EzFlyTimePlugin;
import com.ezflytime.flight.FlyTimeManager;
import com.ezflytime.flight.autoreward.AutoRewardSettings;
import com.ezflytime.flight.autoreward.McMMOIntegration;
import com.ezflytime.util.OnlinePlayers;
import com.ezflytime.util.TimeFormatter;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class AutoFlightTimeDistributor {
    private final EzFlyTimePlugin plugin;
    private final FlyTimeManager flyTimeManager;
    private final McMMOIntegration mcMMOIntegration;
    private AutoRewardSettings settings;
    private BukkitTask task;
    private boolean loggedMissingMcMMO;

    public AutoFlightTimeDistributor(EzFlyTimePlugin plugin, FlyTimeManager flyTimeManager) {
        this.plugin = plugin;
        this.flyTimeManager = flyTimeManager;
        this.mcMMOIntegration = new McMMOIntegration(plugin);
        this.settings = AutoRewardSettings.fromConfiguration(plugin);
    }

    public void start() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
        if (!this.settings.isEnabled()) {
            return;
        }
        long intervalTicks = (long)this.settings.getIntervalSeconds() * 20L;
        if (intervalTicks <= 0L) {
            this.plugin.getLogger().warning("Auto flight rewards interval must be greater than zero.");
            return;
        }
        this.mcMMOIntegration.refresh();
        this.loggedMissingMcMMO = false;
        this.task = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, this::runDistribution, intervalTicks, intervalTicks);
    }

    public void stop() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
    }

    public void reload() {
        this.stop();
        this.mcMMOIntegration.refresh();
        this.settings = AutoRewardSettings.fromConfiguration(this.plugin);
        this.start();
    }

    private void runDistribution() {
        if (this.settings.hasSkillRewards() && !this.mcMMOIntegration.isAvailable() && !this.loggedMissingMcMMO) {
            this.plugin.getLogger().warning("mcMMO skill rewards are configured but mcMMO is not available.");
            this.loggedMissingMcMMO = true;
        }
        for (Player player : OnlinePlayers.getOnlinePlayers()) {
            int totalSeconds = this.settings.getBaseSeconds();
            totalSeconds += this.settings.rankReward(player);
            if ((totalSeconds += this.settings.skillReward(player, this.mcMMOIntegration)) <= 0) continue;
            this.flyTimeManager.addTime(player, totalSeconds, false);
            if (!this.settings.shouldNotifyPlayers()) continue;
            player.sendMessage(this.plugin.getMessage("messages.auto-flight-reward").replace("{seconds}", String.valueOf(totalSeconds)).replace("{minutes}", String.valueOf(totalSeconds / 60)).replace("{time}", TimeFormatter.formatCompact(totalSeconds)));
        }
    }
}

