/*
 * Decompiled with CFR 0.152.
 */
package com.ezflytime.flight;

import com.ezflytime.EzFlyTimePlugin;
import com.ezflytime.util.TimeFormatter;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

class FlightBossBarHandler {
    private final EzFlyTimePlugin plugin;
    private final Map<UUID, Object> bossBars = new HashMap<UUID, Object>();
    private final Map<UUID, Integer> initialFlightSeconds = new HashMap<UUID, Integer>();
    private final boolean enabled;
    private final String title;
    private final BossBarAdapter bossBarAdapter;

    FlightBossBarHandler(EzFlyTimePlugin plugin) {
        this.plugin = plugin;
        ConfigurationSection bossBarSection = plugin.getConfig().getConfigurationSection("bossbar");
        this.enabled = bossBarSection == null || bossBarSection.getBoolean("enabled", true);
        String defaultTitle = plugin.isFuelModeEnabled() ? "&aFlight fuel: {fuel}%" : "&aFlight time remaining: {time}";
        this.title = this.formatColors(bossBarSection != null ? bossBarSection.getString("title", defaultTitle) : defaultTitle);
        String color = bossBarSection != null ? bossBarSection.getString("color", "GREEN") : "GREEN";
        String style = bossBarSection != null ? bossBarSection.getString("style", "SOLID") : "SOLID";
        this.bossBarAdapter = BossBarAdapter.create(plugin, color, style);
        if (this.enabled && this.bossBarAdapter == null) {
            plugin.getLogger().warning("BossBar is enabled in config, but this server does not support it.");
        }
    }

    static boolean isBossBarSupported() {
        return BossBarAdapter.isSupported();
    }

    void setInitialFlight(UUID uuid, int seconds) {
        if (!this.isAvailable()) {
            return;
        }
        this.initialFlightSeconds.put(uuid, seconds);
    }

    void markActive(Player player, int remainingSeconds, boolean bypass, boolean unlimitedFlight) {
        if (!this.isAvailable()) {
            return;
        }
        UUID uuid = player.getUniqueId();
        if (bypass || unlimitedFlight) {
            this.hide(uuid);
            return;
        }
        this.initialFlightSeconds.put(uuid, Math.max(remainingSeconds, this.initialFlightSeconds.getOrDefault(uuid, 0)));
        this.show(player);
        this.update(player, remainingSeconds);
    }

    void markInactive(Player player) {
        if (!this.isAvailable()) {
            return;
        }
        this.hide(player.getUniqueId());
    }

    void reset(UUID uuid) {
        if (!this.isAvailable()) {
            return;
        }
        this.hide(uuid);
        this.initialFlightSeconds.remove(uuid);
    }

    void update(Player player, int remainingSeconds) {
        if (!this.isAvailable()) {
            return;
        }
        UUID uuid = player.getUniqueId();
        Object bossBar = this.bossBars.get(uuid);
        if (bossBar == null) {
            return;
        }
        int initial = this.initialFlightSeconds.getOrDefault(uuid, remainingSeconds);
        if (initial <= 0) {
            this.bossBarAdapter.setProgress(bossBar, 1.0);
            this.bossBarAdapter.setTitle(bossBar, this.formatTitle(remainingSeconds, 100));
            return;
        }
        double progress = Math.max(0.0, Math.min(1.0, (double)remainingSeconds / (double)initial));
        int percent = (int)Math.round(progress * 100.0);
        this.bossBarAdapter.setProgress(bossBar, progress);
        this.bossBarAdapter.setTitle(bossBar, this.formatTitle(remainingSeconds, percent));
    }

    private void show(Player player) {
        List<?> players;
        if (this.bossBarAdapter == null) {
            return;
        }
        UUID uuid = player.getUniqueId();
        Object bossBar = this.bossBars.get(uuid);
        if (bossBar == null) {
            bossBar = this.bossBarAdapter.createBossBar("");
            if (bossBar == null) {
                return;
            }
            this.bossBars.put(uuid, bossBar);
        }
        if ((players = this.bossBarAdapter.getPlayers(bossBar)) != null && players.contains(player)) {
            return;
        }
        this.bossBarAdapter.addPlayer(bossBar, player);
    }

    private void hide(UUID uuid) {
        Object bossBar = this.bossBars.remove(uuid);
        if (bossBar != null) {
            this.bossBarAdapter.removeAll(bossBar);
        }
    }

    private boolean isAvailable() {
        return this.enabled && this.bossBarAdapter != null;
    }

    private String formatTitle(int remainingSeconds, int percent) {
        return this.title.replace("{time}", TimeFormatter.formatCompact(remainingSeconds)).replace("{seconds}", String.valueOf(remainingSeconds)).replace("{fuel}", String.valueOf(percent));
    }

    private String formatColors(String input) {
        if (input == null) {
            return "";
        }
        return input.replace("&", "\u00a7");
    }

    private static final class BossBarAdapter {
        private final Method createBossBar;
        private final Method addPlayer;
        private final Method removeAll;
        private final Method setProgress;
        private final Method setTitle;
        private final Method getPlayers;
        private final Object barColor;
        private final Object barStyle;
        private final Object barFlagArray;

        private BossBarAdapter(Method createBossBar, Method addPlayer, Method removeAll, Method setProgress, Method setTitle, Method getPlayers, Object barColor, Object barStyle, Object barFlagArray) {
            this.createBossBar = createBossBar;
            this.addPlayer = addPlayer;
            this.removeAll = removeAll;
            this.setProgress = setProgress;
            this.setTitle = setTitle;
            this.getPlayers = getPlayers;
            this.barColor = barColor;
            this.barStyle = barStyle;
            this.barFlagArray = barFlagArray;
        }

        static boolean isSupported() {
            try {
                Class.forName("org.bukkit.boss.BossBar");
                return true;
            }
            catch (ClassNotFoundException ex) {
                return false;
            }
        }

        static BossBarAdapter create(EzFlyTimePlugin plugin, String colorName, String styleName) {
            try {
                Class<?> bossBarClass = Class.forName("org.bukkit.boss.BossBar");
                Class<?> barColorClass = Class.forName("org.bukkit.boss.BarColor");
                Class<?> barStyleClass = Class.forName("org.bukkit.boss.BarStyle");
                Object color = BossBarAdapter.parseEnum(barColorClass, colorName, "GREEN");
                Object style = BossBarAdapter.parseEnum(barStyleClass, styleName, "SOLID");
                Method createBossBar = BossBarAdapter.resolveCreateBossBarMethod(barColorClass, barStyleClass);
                Method addPlayer = bossBarClass.getMethod("addPlayer", Player.class);
                Method removeAll = bossBarClass.getMethod("removeAll", new Class[0]);
                Method setProgress = bossBarClass.getMethod("setProgress", Double.TYPE);
                Method setTitle = bossBarClass.getMethod("setTitle", String.class);
                Method getPlayers = bossBarClass.getMethod("getPlayers", new Class[0]);
                Object barFlagArray = createBossBar.getParameterCount() == 4 ? Array.newInstance(Class.forName("org.bukkit.boss.BarFlag"), 0) : null;
                return new BossBarAdapter(createBossBar, addPlayer, removeAll, setProgress, setTitle, getPlayers, color, style, barFlagArray);
            }
            catch (Exception ex) {
                if (plugin != null) {
                    plugin.getLogger().warning("Unable to initialize BossBar support: " + ex.getMessage());
                }
                return null;
            }
        }

        private static Method resolveCreateBossBarMethod(Class<?> barColorClass, Class<?> barStyleClass) throws ClassNotFoundException, NoSuchMethodException {
            try {
                Class<?> barFlagClass = Class.forName("org.bukkit.boss.BarFlag");
                Class<?> barFlagArrayClass = Array.newInstance(barFlagClass, 0).getClass();
                return Bukkit.class.getMethod("createBossBar", String.class, barColorClass, barStyleClass, barFlagArrayClass);
            }
            catch (ClassNotFoundException | NoSuchMethodException ex) {
                return Bukkit.class.getMethod("createBossBar", String.class, barColorClass, barStyleClass);
            }
        }

        Object createBossBar(String title) {
            try {
                if (this.createBossBar.getParameterCount() == 4) {
                    return this.createBossBar.invoke(null, title, this.barColor, this.barStyle, this.barFlagArray);
                }
                return this.createBossBar.invoke(null, title, this.barColor, this.barStyle);
            }
            catch (Exception ignored) {
                return null;
            }
        }

        void addPlayer(Object bossBar, Player player) {
            try {
                this.addPlayer.invoke(bossBar, player);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void removeAll(Object bossBar) {
            try {
                this.removeAll.invoke(bossBar, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void setProgress(Object bossBar, double progress) {
            try {
                this.setProgress.invoke(bossBar, progress);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void setTitle(Object bossBar, String title) {
            try {
                this.setTitle.invoke(bossBar, title);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        List<?> getPlayers(Object bossBar) {
            try {
                return (List)this.getPlayers.invoke(bossBar, new Object[0]);
            }
            catch (Exception ignored) {
                return null;
            }
        }

        private static Object parseEnum(Class<?> enumClass, String value, String fallback) {
            String normalized = value == null ? fallback : value.trim().toUpperCase(Locale.ROOT);
            try {
                return Enum.valueOf(enumClass, normalized);
            }
            catch (IllegalArgumentException ex) {
                return Enum.valueOf(enumClass, fallback);
            }
        }
    }
}

