/*
 * Decompiled with CFR 0.152.
 */
package com.ezflytime.command;

import com.ezflytime.EzFlyTimePlugin;
import com.ezflytime.util.OnlinePlayers;
import com.ezflytime.voucher.FlyVoucher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class FlyVoucherCommand
implements CommandExecutor,
TabCompleter {
    private final EzFlyTimePlugin plugin;

    public FlyVoucherCommand(EzFlyTimePlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        ItemStack[] items;
        if (args.length >= 1 && args[0].equalsIgnoreCase("buy")) {
            ItemStack[] items2;
            Economy econ;
            if (!(sender instanceof Player)) {
                sender.sendMessage(this.plugin.getMessage("messages.buy-player-only"));
                return true;
            }
            Player player = (Player)sender;
            if (!player.hasPermission("ezflytime.buy")) {
                player.sendMessage(this.plugin.getMessage("messages.buy-no-permission"));
                return true;
            }
            if (args.length < 2) {
                player.sendMessage(this.plugin.getMessage("messages.buy-usage"));
                return true;
            }
            FlyVoucher voucher = this.plugin.getVoucherManager().getVoucher(args[1]);
            if (voucher == null || voucher.getPrice() < 0.0) {
                player.sendMessage(this.plugin.getMessage("messages.buy-invalid-voucher"));
                return true;
            }
            int amount = 1;
            if (args.length >= 3) {
                try {
                    amount = Math.max(1, Integer.parseInt(args[2]));
                }
                catch (NumberFormatException ex) {
                    player.sendMessage(this.plugin.getMessage("messages.buy-invalid-amount"));
                    return true;
                }
            }
            if ((econ = this.plugin.getEconomy()) == null) {
                player.sendMessage("\u00a7cEconomy not available. Contact an admin.");
                return true;
            }
            double totalPrice = voucher.getPrice() * (double)amount;
            if (econ.getBalance((OfflinePlayer)player) < totalPrice) {
                player.sendMessage(this.plugin.getMessage("messages.buy-insufficient-funds").replace("{amount}", String.valueOf(amount)).replace("{voucher}", voucher.getDisplayName()).replace("{price}", String.valueOf(totalPrice)).replace("{currency}", econ.currencyNamePlural()));
                return true;
            }
            econ.withdrawPlayer((OfflinePlayer)player, totalPrice);
            ArrayList leftovers = new ArrayList();
            for (ItemStack voucherItem : items2 = voucher.createItems(amount)) {
                HashMap result = player.getInventory().addItem(new ItemStack[]{voucherItem});
                leftovers.addAll(result.values());
            }
            if (!leftovers.isEmpty()) {
                leftovers.forEach(item -> player.getWorld().dropItemNaturally(player.getLocation(), item));
                int leftoverAmount = leftovers.stream().mapToInt(ItemStack::getAmount).sum();
                player.sendMessage(this.plugin.getMessage("messages.buy-inventory-full").replace("{amount}", String.valueOf(leftoverAmount)).replace("{voucher}", voucher.getDisplayName()));
            }
            player.sendMessage(this.plugin.getMessage("messages.buy-success").replace("{amount}", String.valueOf(amount)).replace("{voucher}", voucher.getDisplayName()).replace("{price}", String.valueOf(totalPrice)).replace("{currency}", econ.currencyNamePlural()));
            return true;
        }
        if (args.length < 3 || !args[0].equalsIgnoreCase("give")) {
            sender.sendMessage(this.plugin.getMessage("messages.usage"));
            return true;
        }
        if (!sender.hasPermission("ezflytime.give")) {
            sender.sendMessage(this.plugin.getMessage("messages.no-permission"));
            return true;
        }
        Player target = null;
        for (Player onlinePlayer : OnlinePlayers.getOnlinePlayers()) {
            if (!onlinePlayer.getName().equalsIgnoreCase(args[1])) continue;
            target = onlinePlayer;
            break;
        }
        if (target == null) {
            sender.sendMessage(this.plugin.getMessage("messages.player-not-found"));
            return true;
        }
        FlyVoucher voucher = this.plugin.getVoucherManager().getVoucher(args[2]);
        if (voucher == null) {
            sender.sendMessage(this.plugin.getMessage("messages.invalid-voucher"));
            return true;
        }
        int amount = 1;
        if (args.length >= 4) {
            try {
                amount = Math.max(1, Integer.parseInt(args[3]));
            }
            catch (NumberFormatException ex) {
                sender.sendMessage(this.plugin.getMessage("messages.invalid-amount"));
                return true;
            }
        }
        Player finalTarget = target;
        ArrayList leftovers = new ArrayList();
        for (ItemStack voucherItem : items = voucher.createItems(amount)) {
            HashMap result = finalTarget.getInventory().addItem(new ItemStack[]{voucherItem});
            leftovers.addAll(result.values());
        }
        if (!leftovers.isEmpty()) {
            leftovers.forEach(item -> finalTarget.getWorld().dropItemNaturally(finalTarget.getLocation(), item));
            int leftoverAmount = leftovers.stream().mapToInt(ItemStack::getAmount).sum();
            sender.sendMessage(this.plugin.getMessage("messages.inventory-full-sender").replace("{player}", target.getName()).replace("{amount}", String.valueOf(leftoverAmount)).replace("{voucher}", voucher.getDisplayName()));
            target.sendMessage(this.plugin.getMessage("messages.inventory-full-target").replace("{amount}", String.valueOf(leftoverAmount)).replace("{voucher}", voucher.getDisplayName()));
        }
        sender.sendMessage(this.plugin.getMessage("messages.gave-voucher").replace("{player}", target.getName()).replace("{amount}", String.valueOf(amount)).replace("{voucher}", voucher.getDisplayName()));
        target.sendMessage(this.plugin.getMessage("messages.received-voucher").replace("{amount}", String.valueOf(amount)).replace("{voucher}", voucher.getDisplayName()));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> sub = new ArrayList<String>();
            sub.add("give");
            sub.add("buy");
            return sub.stream().filter(s -> s.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("give")) {
                return OnlinePlayers.getOnlinePlayers().stream().map(OfflinePlayer::getName).filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
            }
            if (args[0].equalsIgnoreCase("buy")) {
                return this.plugin.getVoucherManager().getVoucherIds().stream().filter(id -> id.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
            }
        }
        if (args.length == 3) {
            if (args[0].equalsIgnoreCase("give")) {
                return this.plugin.getVoucherManager().getVoucherIds().stream().filter(id -> id.toLowerCase().startsWith(args[2].toLowerCase())).collect(Collectors.toList());
            }
            if (args[0].equalsIgnoreCase("buy")) {
                ArrayList<String> suggestions = new ArrayList<String>();
                suggestions.add("1");
                suggestions.add("2");
                suggestions.add("5");
                suggestions.add("10");
                return suggestions.stream().filter(s -> s.startsWith(args[2])).collect(Collectors.toList());
            }
        }
        return new ArrayList<String>();
    }
}

