/*
 * Decompiled with CFR 0.152.
 */
package com.ezflytime.command;

import com.ezflytime.EzFlyTimePlugin;
import com.ezflytime.flight.FlyTimeManager;
import com.ezflytime.util.TimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.bukkit.GameMode;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class FlyCommand
implements CommandExecutor,
TabCompleter {
    private final EzFlyTimePlugin plugin;

    public FlyCommand(EzFlyTimePlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        boolean isFlyTimeCommand = command.getName().equalsIgnoreCase("flytime");
        if (isFlyTimeCommand && args.length > 0 && args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("ezflytime.reload")) {
                sender.sendMessage(this.plugin.getMessage("messages.no-permission"));
                return true;
            }
            this.plugin.reloadPluginConfiguration();
            sender.sendMessage(this.plugin.getMessage("messages.config-reloaded"));
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getMessage("messages.player-only"));
            return true;
        }
        Player player = (Player)sender;
        FlyTimeManager flyTimeManager = this.plugin.getFlyTimeManager();
        if (flyTimeManager == null) {
            this.plugin.getLogger().warning("Fly time manager was unavailable when handling the fly command.");
            return true;
        }
        if (isFlyTimeCommand || args.length > 0 && args[0].equalsIgnoreCase("time")) {
            if (!player.hasPermission("ezflytime.flytime") && !player.hasPermission("ezflytime.fly")) {
                player.sendMessage(this.plugin.getMessage("messages.no-permission"));
                return true;
            }
            this.sendRemainingTime(player, flyTimeManager);
            return true;
        }
        if (!player.hasPermission("ezflytime.fly")) {
            player.sendMessage(this.plugin.getMessage("messages.no-permission"));
            return true;
        }
        this.toggleFlight(player, flyTimeManager);
        return true;
    }

    private void toggleFlight(Player player, FlyTimeManager flyTimeManager) {
        if (player.getAllowFlight()) {
            player.setFlying(false);
            player.setAllowFlight(false);
            flyTimeManager.pauseCountdown(player);
            player.sendMessage(this.plugin.getMessage("messages.flight-disabled"));
            return;
        }
        if (!this.plugin.hasBypassUnlimitedFlight(player) && !this.hasUnlimitedFlight(player)) {
            int seconds = flyTimeManager.getRemainingSeconds(player);
            if (seconds <= 0) {
                player.sendMessage(this.plugin.getMessage("messages.flight-no-time"));
                return;
            }
            this.enableFlight(player);
            flyTimeManager.resumeCountdown(player);
            player.sendMessage(this.plugin.getMessage("messages.flight-enabled").replace("{time}", TimeFormatter.formatCompact(seconds)));
            return;
        }
        this.enableFlight(player);
        flyTimeManager.resumeCountdown(player);
        player.sendMessage(this.plugin.getMessage("messages.flight-enabled-unlimited"));
    }

    private void enableFlight(Player player) {
        player.setAllowFlight(true);
        if (!player.isFlying()) {
            player.setFlying(true);
        }
    }

    private void sendRemainingTime(Player player, FlyTimeManager flyTimeManager) {
        if (this.plugin.hasBypassUnlimitedFlight(player) || this.hasUnlimitedFlight(player)) {
            player.sendMessage(this.plugin.getMessage("messages.flight-time-unlimited"));
            return;
        }
        int seconds = flyTimeManager.getRemainingSeconds(player);
        if (seconds <= 0) {
            player.sendMessage(this.plugin.getMessage("messages.flight-no-time"));
            return;
        }
        player.sendMessage(this.plugin.getMessage("messages.flight-time-remaining").replace("{time}", TimeFormatter.formatCompact(seconds)));
    }

    private boolean hasUnlimitedFlight(Player player) {
        GameMode mode = player.getGameMode();
        String modeName = mode.name();
        return "CREATIVE".equals(modeName) || "SPECTATOR".equals(modeName);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (command.getName().equalsIgnoreCase("fly") && args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            this.addPartialMatches(args[0], Collections.singletonList("time"), completions);
            return completions;
        }
        if (command.getName().equalsIgnoreCase("flytime") && args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            if (sender.hasPermission("ezflytime.reload")) {
                this.addPartialMatches(args[0], Collections.singletonList("reload"), completions);
            }
            return completions;
        }
        return Collections.emptyList();
    }

    private void addPartialMatches(String token, List<String> candidates, List<String> completions) {
        if (token == null) {
            completions.addAll(candidates);
            return;
        }
        String lowerToken = token.toLowerCase(Locale.ROOT);
        for (String candidate : candidates) {
            if (!candidate.toLowerCase(Locale.ROOT).startsWith(lowerToken)) continue;
            completions.add(candidate);
        }
    }
}

