/*
 * Decompiled with CFR 0.152.
 */
package com.ezflytime.bootstrap;

import com.ezflytime.EzFlyTimePlugin;
import com.ezflytime.command.FlyCommand;
import com.ezflytime.command.FlyVoucherCommand;
import com.ezflytime.voucher.VoucherManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class CommandRegistrar {
    private static final Map<String, CommandMetadata> COMMAND_METADATA = new HashMap<String, CommandMetadata>();
    private final EzFlyTimePlugin plugin;

    public CommandRegistrar(EzFlyTimePlugin plugin) {
        this.plugin = plugin;
    }

    public void register(VoucherManager voucherManager) {
        FlyCommand flyCommand = new FlyCommand(this.plugin);
        this.registerCommand("fly", flyCommand, flyCommand);
        this.registerCommand("flytime", flyCommand, flyCommand);
        FlyVoucherCommand flyVoucherCommand = new FlyVoucherCommand(this.plugin);
        this.registerCommand("flyvoucher", flyVoucherCommand, flyVoucherCommand);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)voucherManager, (Plugin)this.plugin);
    }

    private void registerCommand(String commandName, CommandExecutor executor, TabCompleter tabCompleter) {
        PluginCommand pluginCommand = null;
        try {
            pluginCommand = this.plugin.getCommand(commandName);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (pluginCommand != null) {
            pluginCommand.setExecutor(executor);
            pluginCommand.setTabCompleter(tabCompleter);
            return;
        }
        this.registerDynamically(commandName, executor, tabCompleter);
    }

    private void registerDynamically(String commandName, CommandExecutor executor, TabCompleter tabCompleter) {
        CommandMap commandMap;
        CommandMetadata metadata = COMMAND_METADATA.get(commandName.toLowerCase(Locale.ROOT));
        if (metadata == null) {
            this.plugin.getLogger().warning("Unable to register command '" + commandName + "': missing metadata definition.");
            return;
        }
        DelegatingPluginCommand command = new DelegatingPluginCommand(commandName, (Plugin)this.plugin, executor, tabCompleter);
        command.setDescription(metadata.getDescription());
        command.setUsage(metadata.getUsage());
        if (metadata.getPermission() != null && !metadata.getPermission().trim().isEmpty()) {
            command.setPermission(metadata.getPermission());
            command.setPermissionMessage(this.plugin.getMessage("messages.no-permission"));
        }
        if ((commandMap = this.resolveCommandMap()) == null) {
            this.plugin.getLogger().severe("Unable to register command '" + commandName + "': command map unavailable.");
            return;
        }
        String fallbackPrefix = this.plugin.getName().toLowerCase(Locale.ROOT);
        if (!commandMap.register(fallbackPrefix, (Command)command)) {
            this.plugin.getLogger().warning("Command '" + commandName + "' could not be registered. It may already exist.");
        }
    }

    private CommandMap resolveCommandMap() {
        try {
            Method method = this.plugin.getServer().getClass().getMethod("getCommandMap", new Class[0]);
            return (CommandMap)method.invoke((Object)this.plugin.getServer(), new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException exception) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to access server command map for dynamic command registration", exception);
            return null;
        }
    }

    static {
        COMMAND_METADATA.put("fly", new CommandMetadata("Toggle flight or show remaining fly time", "/<command> [time]", "ezflytime.fly"));
        COMMAND_METADATA.put("flytime", new CommandMetadata("Show remaining fly time or reload the plugin configuration", "/<command> [reload]", "ezflytime.flytime"));
        COMMAND_METADATA.put("flyvoucher", new CommandMetadata("Give configurable fly vouchers to players", "/<command> give <player> <voucherId> [amount]", "ezflytime.give"));
    }

    private static final class CommandMetadata {
        private final String description;
        private final String usage;
        private final String permission;

        private CommandMetadata(String description, String usage, String permission) {
            this.description = description;
            this.usage = usage;
            this.permission = permission;
        }

        private String getDescription() {
            return this.description;
        }

        private String getUsage() {
            return this.usage;
        }

        private String getPermission() {
            return this.permission;
        }
    }

    private static final class DelegatingPluginCommand
    extends Command
    implements PluginIdentifiableCommand {
        private final Plugin plugin;
        private final CommandExecutor executor;
        private final TabCompleter tabCompleter;

        private DelegatingPluginCommand(String name, Plugin plugin, CommandExecutor executor, TabCompleter tabCompleter) {
            super(name);
            this.plugin = plugin;
            this.executor = executor;
            this.tabCompleter = tabCompleter;
        }

        public boolean execute(CommandSender sender, String commandLabel, String[] args) {
            if (!this.testPermission(sender)) {
                return true;
            }
            return this.executor.onCommand(sender, (Command)this, commandLabel, args);
        }

        public List<String> tabComplete(CommandSender sender, String alias, String[] args) {
            if (this.tabCompleter == null) {
                return super.tabComplete(sender, alias, args);
            }
            List completions = this.tabCompleter.onTabComplete(sender, (Command)this, alias, args);
            return completions != null ? completions : super.tabComplete(sender, alias, args);
        }

        public Plugin getPlugin() {
            return this.plugin;
        }
    }
}

