/*
 * Decompiled with CFR 0.152.
 */
package com.ezflytime;

import com.ezflytime.bootstrap.CommandRegistrar;
import com.ezflytime.bootstrap.StorageInitializer;
import com.ezflytime.flight.FlyTimeManager;
import com.ezflytime.flight.autoreward.AutoFlightTimeDistributor;
import com.ezflytime.metrics.bukkit.Metrics;
import com.ezflytime.metrics.charts.SimplePie;
import com.ezflytime.placeholder.PlaceholderIntegration;
import com.ezflytime.storage.FlyTimeStorage;
import com.ezflytime.storage.VoucherStorage;
import com.ezflytime.update.SpigotUpdateChecker;
import com.ezflytime.update.UpdateCheckResult;
import com.ezflytime.update.UpdateNotifier;
import com.ezflytime.util.BossBarSupport;
import com.ezflytime.voucher.VoucherManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class EzFlyTimePlugin
extends JavaPlugin {
    private Economy economy;
    private static final int BSTATS_PLUGIN_ID = 27727;
    private FlyTimeManager flyTimeManager;
    private VoucherManager voucherManager;
    private FlyTimeStorage flyTimeStorage;
    private VoucherStorage voucherStorage;
    private PlaceholderIntegration placeholderIntegration;
    private AutoFlightTimeDistributor autoFlightTimeDistributor;
    private Metrics metrics;
    private SpigotUpdateChecker updateChecker;
    private UpdateCheckResult updateCheckResult;
    private FileConfiguration messageConfig;
    private FileConfiguration englishMessageConfig;
    private boolean debugEnabled;

    public Economy getEconomy() {
        return this.economy;
    }

    private void setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            this.getLogger().warning("Vault not found. Voucher buying will be disabled.");
            return;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            this.getLogger().warning("No Vault economy provider found. Voucher buying will be disabled.");
            return;
        }
        this.economy = (Economy)rsp.getProvider();
    }

    public boolean isFuelModeEnabled() {
        String mode = this.getConfig().getString("display.flytime-mode", "time");
        return "fuel".equalsIgnoreCase(mode);
    }

    public void onEnable() {
        this.saveDefaultConfig();
        this.saveDefaultMessages();
        this.reloadConfig();
        this.refreshDebugState();
        this.loadMessageConfiguration();
        this.setupEconomy();
        StorageInitializer.StoragePair storagePair = new StorageInitializer(this).initialize();
        this.flyTimeStorage = storagePair.getFlyTimeStorage();
        this.voucherStorage = storagePair.getVoucherStorage();
        this.voucherManager = new VoucherManager(this, this.voucherStorage);
        this.flyTimeManager = new FlyTimeManager(this, this.flyTimeStorage);
        this.autoFlightTimeDistributor = new AutoFlightTimeDistributor(this, this.flyTimeManager);
        new CommandRegistrar(this).register(this.voucherManager);
        this.flyTimeManager.start();
        this.autoFlightTimeDistributor.start();
        this.placeholderIntegration = new PlaceholderIntegration(this);
        this.placeholderIntegration.registerIfAvailable();
        this.initializeMetrics();
        this.logStartupSummary();
        this.initializeUpdateChecker();
    }

    public void onDisable() {
        if (this.flyTimeManager != null) {
            this.flyTimeManager.stop();
            this.flyTimeManager.saveData();
        }
        if (this.autoFlightTimeDistributor != null) {
            this.autoFlightTimeDistributor.stop();
        }
        if (this.voucherManager != null) {
            this.voucherManager.saveData();
        }
        if (this.flyTimeStorage != null) {
            this.flyTimeStorage.close();
        }
        if (this.voucherStorage != null) {
            this.voucherStorage.close();
        }
        if (this.placeholderIntegration != null) {
            this.placeholderIntegration.unregister();
        }
        this.metrics = null;
        this.updateChecker = null;
        this.updateCheckResult = null;
    }

    public FlyTimeManager getFlyTimeManager() {
        return this.flyTimeManager;
    }

    public VoucherManager getVoucherManager() {
        return this.voucherManager;
    }

    public UpdateCheckResult getUpdateCheckResult() {
        return this.updateCheckResult;
    }

    public String getMessage(String path) {
        String prefix = this.getMessageValue("messages.prefix");
        String message = this.getMessageValue(path);
        if ("messages.prefix".equals(path)) {
            return this.translateColorCodes(prefix);
        }
        if (prefix == null) {
            prefix = "";
        }
        if (message == null) {
            message = path;
        }
        return this.translateColorCodes(prefix + message);
    }

    public void reloadPluginConfiguration() {
        this.reloadConfig();
        this.refreshDebugState();
        this.saveDefaultMessages();
        this.loadMessageConfiguration();
        if (this.flyTimeManager != null) {
            Map<UUID, Integer> remaining = this.flyTimeManager.snapshotRemainingSeconds();
            Map<UUID, Boolean> activeStates = this.flyTimeManager.snapshotActiveStates();
            this.flyTimeManager.saveData();
            this.flyTimeManager.stop();
            HandlerList.unregisterAll((Listener)this.flyTimeManager);
            this.flyTimeManager = new FlyTimeManager(this, this.flyTimeStorage);
            this.flyTimeManager.restoreState(remaining, activeStates);
            this.flyTimeManager.start();
            if (this.autoFlightTimeDistributor != null) {
                this.autoFlightTimeDistributor.stop();
            }
            this.autoFlightTimeDistributor = new AutoFlightTimeDistributor(this, this.flyTimeManager);
            this.autoFlightTimeDistributor.start();
            for (UUID uuid : remaining.keySet()) {
                Player player = this.getServer().getPlayer(uuid);
                if (player == null) continue;
                if (activeStates.getOrDefault(uuid, false).booleanValue()) {
                    this.flyTimeManager.resumeCountdown(player);
                    continue;
                }
                this.flyTimeManager.pauseCountdown(player);
            }
        }
        if (this.voucherManager != null) {
            this.voucherManager.reload();
        }
        if (this.placeholderIntegration != null) {
            this.placeholderIntegration.unregister();
            this.placeholderIntegration.registerIfAvailable();
        }
        if (this.flyTimeManager == null && this.autoFlightTimeDistributor != null) {
            this.autoFlightTimeDistributor.reload();
        }
        if (this.metrics == null) {
            this.initializeMetrics();
        }
    }

    private void initializeMetrics() {
        if (this.metrics != null) {
            return;
        }
        try {
            this.metrics = new Metrics((Plugin)this, 27727);
            this.metrics.addCustomChart(new SimplePie("storage_backend", this::resolveStorageBackend));
            this.metrics.addCustomChart(new SimplePie("auto_flight_rewards", this::resolveAutoFlightRewardsStatus));
            this.metrics.addCustomChart(new SimplePie("flight_activation_mode", this::resolveActivationMode));
        }
        catch (Throwable throwable) {
            this.getLogger().warning("Unable to initialise bStats metrics: " + throwable.getMessage());
        }
    }

    private void initializeUpdateChecker() {
        if (!this.getConfig().getBoolean("updates.enabled", true)) {
            this.getLogger().info("Update checks are disabled.");
            return;
        }
        int resourceId = this.getConfig().getInt("updates.resource-id", 129745);
        this.updateChecker = new SpigotUpdateChecker(this, resourceId);
        if (this.getConfig().getBoolean("updates.notify-on-join", true)) {
            this.getServer().getPluginManager().registerEvents((Listener)new UpdateNotifier(this), (Plugin)this);
        }
        this.updateChecker.checkAsync(result -> {
            this.updateCheckResult = result;
            this.logUpdateResult(result);
        });
    }

    private void logUpdateResult(UpdateCheckResult result) {
        if (result == null) {
            return;
        }
        switch (result.getStatus()) {
            case UPDATE_AVAILABLE: {
                this.getLogger().warning("Update available: " + result.getCurrentVersion() + " -> " + result.getLatestVersion());
                this.getLogger().warning("Download: " + result.getDownloadUrl());
                break;
            }
            case FAILED: {
                this.getLogger().warning(this.getMessage("messages.update-check-failed").replace("{reason}", result.getErrorMessage() != null ? result.getErrorMessage() : "Unknown error"));
                break;
            }
            default: {
                this.getLogger().info("EzFlyTime is up to date (version " + result.getCurrentVersion() + ").");
            }
        }
    }

    private void logStartupSummary() {
        Object bossBarStatus;
        String version = this.getDescription().getVersion();
        this.getLogger().info("Starting EzFlyTime v" + version + ".");
        this.getLogger().info("Server: " + this.getServer().getName() + " " + this.getServer().getVersion());
        this.getLogger().info("Storage backend: " + this.resolveStorageBackend());
        this.getLogger().info("Auto-flight rewards: " + this.resolveAutoFlightRewardsStatus());
        boolean bossBarEnabled = this.isBossBarEnabled();
        Object object = bossBarStatus = bossBarEnabled ? "enabled" : "disabled";
        if (bossBarEnabled && !BossBarSupport.isSupported()) {
            bossBarStatus = (String)bossBarStatus + " (unsupported on this server)";
        }
        this.getLogger().info("BossBar display: " + (String)bossBarStatus);
        this.getLogger().info("Update checks: " + (this.getConfig().getBoolean("updates.enabled", true) ? "enabled" : "disabled"));
    }

    private String resolveStorageBackend() {
        String configured = this.getConfig().getString("storage.type", "yaml");
        if (configured == null || configured.trim().isEmpty()) {
            return "unknown";
        }
        return configured.toLowerCase(Locale.ROOT);
    }

    private String resolveAutoFlightRewardsStatus() {
        boolean enabled = this.getConfig().getBoolean("auto-flight-rewards.enabled", false);
        return enabled ? "enabled" : "disabled";
    }

    private boolean isBossBarEnabled() {
        ConfigurationSection bossBarSection = this.getConfig().getConfigurationSection("bossbar");
        return bossBarSection == null || bossBarSection.getBoolean("enabled", true);
    }

    private String resolveActivationMode() {
        String configured = this.getConfig().getString("flight.activation-mode", "normal");
        if (configured == null || configured.trim().isEmpty()) {
            return "unknown";
        }
        return configured.toLowerCase(Locale.ROOT);
    }

    public boolean isBypassUnlimitedFlightEnabled() {
        return this.getConfig().getBoolean("flight.bypass-grants-unlimited", true);
    }

    public boolean hasBypassUnlimitedFlight(Player player) {
        return this.isBypassUnlimitedFlightEnabled() && player.hasPermission("ezflytime.bypass");
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public void debug(String message) {
        if (!this.debugEnabled) {
            return;
        }
        this.getLogger().info("[Debug] " + message);
    }

    private void refreshDebugState() {
        boolean previous = this.debugEnabled;
        this.debugEnabled = this.getConfig().getBoolean("debug", false);
        if (this.debugEnabled && !previous) {
            this.getLogger().info("Debug logging enabled.");
        }
    }

    private void saveDefaultMessages() {
        if (!this.getDataFolder().exists() && !this.getDataFolder().mkdirs()) {
            this.getLogger().warning("Unable to create plugin data folder for messages.");
        }
        this.saveResourceIfAbsent("messages_en.yml");
        this.saveResourceIfAbsent("messages_nl.yml");
        this.saveResourceIfAbsent("messages_es.yml");
    }

    private void saveResourceIfAbsent(String resourcePath) {
        File file = new File(this.getDataFolder(), resourcePath);
        if (!file.exists()) {
            this.saveResource(resourcePath, false);
        }
    }

    private void loadMessageConfiguration() {
        this.englishMessageConfig = this.loadLanguageFile("en");
        String configuredLanguage = this.getConfig().getString("language", "en");
        String languageCode = this.normalizeLanguageCode(configuredLanguage);
        this.messageConfig = "en".equals(languageCode) ? this.englishMessageConfig : this.loadLanguageFile(languageCode);
    }

    private FileConfiguration loadLanguageFile(String languageCode) {
        YamlConfiguration configuration;
        block13: {
            String fileName = "messages_" + languageCode + ".yml";
            this.saveResourceIfAbsent(fileName);
            File file = new File(this.getDataFolder(), fileName);
            configuration = YamlConfiguration.loadConfiguration((File)file);
            try (InputStream resource = this.getResource(fileName);){
                if (resource == null) break block13;
                try (InputStreamReader reader = new InputStreamReader(resource, StandardCharsets.UTF_8);){
                    YamlConfiguration defaults = YamlConfiguration.loadConfiguration((Reader)reader);
                    configuration.setDefaults((Configuration)defaults);
                }
            }
            catch (IOException e) {
                this.getLogger().warning("Unable to load default messages for " + languageCode + ": " + e.getMessage());
            }
        }
        return configuration;
    }

    private String normalizeLanguageCode(String languageSetting) {
        if (languageSetting == null) {
            return "en";
        }
        String normalized = languageSetting.toLowerCase(Locale.ROOT);
        if (normalized.startsWith("nl") || normalized.contains("dutch")) {
            return "nl";
        }
        if (normalized.startsWith("es") || normalized.contains("spanish")) {
            return "es";
        }
        return "en";
    }

    private String getMessageValue(String path) {
        String fallback;
        String value;
        if (this.messageConfig != null && (value = this.messageConfig.getString(path)) != null) {
            return value;
        }
        if (this.englishMessageConfig != null && this.messageConfig != this.englishMessageConfig && (fallback = this.englishMessageConfig.getString(path)) != null) {
            return fallback;
        }
        return null;
    }

    private String translateColorCodes(String input) {
        return input == null ? "" : input.replace("&", "\u00a7");
    }
}

