/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezclean.command;

import com.skyblockexp.ezclean.CleanupCancelSettings;
import com.skyblockexp.ezclean.CleanupSettings;
import com.skyblockexp.ezclean.EntityCleanupScheduler;
import com.skyblockexp.ezclean.EzCleanPlugin;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.scheduler.BukkitWorker;
import org.jetbrains.annotations.Nullable;

public final class EzCleanCommand
implements CommandExecutor,
TabCompleter {
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private static final String RUN_SUBCOMMAND = "run";
    private static final String RELOAD_SUBCOMMAND = "reload";
    private static final String TIME_SUBCOMMAND = "time";
    private static final String USAGE_SUBCOMMAND = "usage";
    private static final String CANCEL_SUBCOMMAND = "cancel";
    private static final int ASYNC_GRAPH_WIDTH = 20;
    private static final long LIVE_MONITOR_PERIOD_TICKS = 10L;
    private static final int LIVE_CHAT_INTERVAL_CYCLES = 8;
    private final EzCleanPlugin plugin;
    private final EntityCleanupScheduler cleanupScheduler;
    private final Map<UUID, LiveUsageSubscription> liveUsageSessions = new HashMap<UUID, LiveUsageSubscription>();

    public EzCleanCommand(EzCleanPlugin plugin, EntityCleanupScheduler cleanupScheduler) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
        this.cleanupScheduler = Objects.requireNonNull(cleanupScheduler, "cleanupScheduler");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            this.sendUsage(sender, label);
            return true;
        }
        String subcommand = args[0].toLowerCase(Locale.ROOT);
        if (RUN_SUBCOMMAND.equals(subcommand)) {
            return this.handleRunSubcommand(sender, label, args);
        }
        if (CANCEL_SUBCOMMAND.equals(subcommand)) {
            return this.handleCancelSubcommand(sender, label, args);
        }
        if (RELOAD_SUBCOMMAND.equals(subcommand)) {
            return this.handleReloadSubcommand(sender);
        }
        if (TIME_SUBCOMMAND.equals(subcommand)) {
            return this.handleTimeSubcommand(sender, label, args);
        }
        if (USAGE_SUBCOMMAND.equals(subcommand)) {
            return this.handleUsageSubcommand(sender, label, args);
        }
        this.sendUsage(sender, label);
        return true;
    }

    private boolean handleReloadSubcommand(CommandSender sender) {
        if (!sender.hasPermission("ezclean.reload")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to reload EzClean.");
            return true;
        }
        this.plugin.reloadPluginConfiguration();
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Reloaded EzClean configuration.");
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean handleRunSubcommand(CommandSender sender, String label, String[] args) {
        if (!sender.hasPermission("ezclean.clean")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to run cleaners.");
            return true;
        }
        List<String> cleanerIds = this.cleanupScheduler.getCleanerIds();
        if (cleanerIds.isEmpty()) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "No cleanup profiles are currently configured.");
            return true;
        }
        if (args.length > 2) {
            this.sendUsage(sender, label);
            return true;
        }
        String cleanerId = null;
        if (args.length == 1) {
            if (cleanerIds.size() != 1) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Multiple cleanup profiles available. Specify one of: " + String.join((CharSequence)", ", cleanerIds));
                return true;
            }
            cleanerId = cleanerIds.get(0);
        } else {
            String requestedId = args[1];
            for (String candidate : cleanerIds) {
                if (!candidate.equalsIgnoreCase(requestedId)) continue;
                cleanerId = candidate;
                break;
            }
            if (cleanerId == null) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "No cleanup profile matches \"" + requestedId + "\".");
                return true;
            }
        }
        if (!this.cleanupScheduler.triggerCleanup(cleanerId)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "That cleanup profile is not currently scheduled.");
            return true;
        }
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Triggered cleanup for profile \"" + cleanerId + "\".");
        return true;
    }

    private boolean handleCancelSubcommand(CommandSender sender, String label, String[] args) {
        Duration delay;
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players may cancel cleanup cycles.");
            return true;
        }
        Player player = (Player)sender;
        if (!sender.hasPermission("ezclean.cancel")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to cancel cleanups.");
            return true;
        }
        List<String> cleanerIds = this.cleanupScheduler.getCleanerIds();
        if (cleanerIds.isEmpty()) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "No cleanup profiles are currently configured.");
            return true;
        }
        if (args.length > 2) {
            this.sendUsage(sender, label);
            return true;
        }
        String cleanerId = this.resolveCleanerId(args, cleanerIds);
        if (cleanerId == null) {
            if (args.length == 1 && cleanerIds.size() > 1) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Multiple cleanup profiles available. Specify one of: " + String.join((CharSequence)", ", cleanerIds));
            } else if (args.length > 1) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "No cleanup profile matches \"" + args[1] + "\".");
            }
            return true;
        }
        CleanupSettings settings = this.cleanupScheduler.getSettings(cleanerId);
        if (settings == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "No cleanup profile matches \"" + cleanerId + "\".");
            return true;
        }
        CleanupCancelSettings cancelSettings = settings.getCancelSettings();
        if (!cancelSettings.isEnabled()) {
            this.sendMiniMessage(player, cancelSettings.getDisabledMessage(), Placeholder.parsed("cleaner", settings.getCleanerId()));
            return true;
        }
        Duration remaining = this.cleanupScheduler.getTimeUntilCleanup(cleanerId);
        if (remaining == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "That cleanup profile is not currently scheduled.");
            return true;
        }
        Economy economy = this.plugin.getEconomy();
        if (economy == null) {
            this.sendMiniMessage(player, cancelSettings.getNoEconomyMessage(), Placeholder.parsed("cleaner", settings.getCleanerId()));
            return true;
        }
        double cost = cancelSettings.getCost();
        if (cost > 0.0) {
            double balance = economy.getBalance((OfflinePlayer)player);
            if (balance + 1.0E-9 < cost) {
                this.sendMiniMessage(player, cancelSettings.getInsufficientFundsMessage(), Placeholder.parsed("cleaner", settings.getCleanerId()), Placeholder.parsed("cost", cancelSettings.getFormattedCost()));
                return true;
            }
            EconomyResponse withdrawal = economy.withdrawPlayer((OfflinePlayer)player, cost);
            if (withdrawal == null || withdrawal.type != EconomyResponse.ResponseType.SUCCESS) {
                String error = withdrawal != null ? withdrawal.errorMessage : "Economy error.";
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Unable to withdraw funds: " + error);
                return true;
            }
        }
        if ((delay = this.cleanupScheduler.cancelNextCleanup(cleanerId)) == null) {
            if (cost > 0.0) {
                economy.depositPlayer((OfflinePlayer)player, cost);
            }
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Failed to cancel the upcoming cleanup.");
            return true;
        }
        long minutes = Math.max(1L, delay.toMinutes());
        TagResolver[] placeholders = new TagResolver[]{Placeholder.parsed("player", player.getName()), Placeholder.parsed("cleaner", settings.getCleanerId()), Placeholder.parsed("cost", cancelSettings.getFormattedCost()), Placeholder.parsed("minutes", Long.toString(minutes))};
        this.sendMiniMessage(player, cancelSettings.getSuccessMessage(), placeholders);
        String broadcastTemplate = cancelSettings.getBroadcastMessage();
        if (broadcastTemplate != null && !broadcastTemplate.isEmpty()) {
            Component component = MINI_MESSAGE.deserialize(broadcastTemplate, placeholders);
            Bukkit.getServer().sendMessage(component);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean handleTimeSubcommand(CommandSender sender, String label, String[] args) {
        if (!sender.hasPermission("ezclean.status")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to view cleaner status.");
            return true;
        }
        List<String> cleanerIds = this.cleanupScheduler.getCleanerIds();
        if (cleanerIds.isEmpty()) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "No cleanup profiles are currently configured.");
            return true;
        }
        if (args.length > 2) {
            this.sendUsage(sender, label);
            return true;
        }
        String cleanerId = null;
        if (args.length == 1) {
            if (cleanerIds.size() != 1) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Multiple cleanup profiles available. Specify one of: " + String.join((CharSequence)", ", cleanerIds));
                return true;
            }
            cleanerId = cleanerIds.get(0);
        } else {
            String requestedId = args[1];
            for (String candidate : cleanerIds) {
                if (!candidate.equalsIgnoreCase(requestedId)) continue;
                cleanerId = candidate;
                break;
            }
            if (cleanerId == null) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "No cleanup profile matches \"" + requestedId + "\".");
                return true;
            }
        }
        Duration timeRemaining = this.cleanupScheduler.getTimeUntilCleanup(cleanerId);
        if (timeRemaining == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "That cleanup profile is not currently scheduled.");
            return true;
        }
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Cleanup for profile \"" + cleanerId + "\" will run in " + this.formatDuration(timeRemaining) + ".");
        return true;
    }

    private boolean handleUsageSubcommand(CommandSender sender, String label, String[] args) {
        Player player;
        if (!sender.hasPermission("ezclean.usage")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to view scheduler usage.");
            return true;
        }
        if (args.length > 3) {
            this.sendUsage(sender, label);
            return true;
        }
        boolean stopRequested = false;
        boolean liveRequested = false;
        String requestedPlugin = null;
        if (args.length >= 2) {
            String argument = args[1];
            if ("stop".equalsIgnoreCase(argument)) {
                stopRequested = true;
                if (args.length > 2) {
                    this.sendUsage(sender, label);
                    return true;
                }
            } else if ("live".equalsIgnoreCase(argument)) {
                liveRequested = true;
                if (args.length == 3) {
                    requestedPlugin = args[2];
                } else if (args.length > 3) {
                    this.sendUsage(sender, label);
                    return true;
                }
            } else {
                if (args.length > 2) {
                    this.sendUsage(sender, label);
                    return true;
                }
                requestedPlugin = argument;
            }
        }
        if (stopRequested) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players may stop the live usage monitor.");
                return true;
            }
            player = (Player)sender;
            boolean cancelled = this.cancelLiveUsage(player.getUniqueId());
            if (cancelled) {
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Stopped the live async usage monitor.");
            } else {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not currently have a live usage monitor running.");
            }
            return true;
        }
        if (liveRequested) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players may view the live usage monitor.");
                return true;
            }
            player = (Player)sender;
            this.startLiveUsageMonitor(player, label, requestedPlugin);
            return true;
        }
        UsageSnapshot snapshot = this.createUsageSnapshot(requestedPlugin);
        if (snapshot.isEmpty()) {
            if (requestedPlugin == null) {
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "No scheduler activity detected.");
            } else {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "No scheduler activity found for plugin \"" + requestedPlugin + "\".");
            }
            if (sender instanceof Player) {
                sender.sendMessage(String.valueOf(ChatColor.DARK_GRAY) + "Tip: Use /" + label + " usage live" + (String)(requestedPlugin != null ? " " + requestedPlugin : "") + " for a live async graph. Use /" + label + " usage stop to cancel.");
            }
            return true;
        }
        this.sendUsageSnapshot(sender, snapshot, false, requestedPlugin, label, sender instanceof Player);
        return true;
    }

    private String formatDuration(Duration duration) {
        if (duration == null || duration.isZero() || duration.isNegative()) {
            return "less than a minute";
        }
        long totalSeconds = duration.getSeconds();
        if (totalSeconds <= 0L) {
            return "less than a minute";
        }
        long hours = totalSeconds / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        if (hours > 0L) {
            if (minutes > 0L) {
                return hours + " hour" + (hours == 1L ? "" : "s") + " and " + minutes + " minute" + (minutes == 1L ? "" : "s");
            }
            if (seconds > 0L) {
                return hours + " hour" + (hours == 1L ? "" : "s") + " and " + seconds + " second" + (seconds == 1L ? "" : "s");
            }
            return hours + " hour" + (hours == 1L ? "" : "s");
        }
        if (minutes > 0L) {
            if (seconds > 0L) {
                return minutes + " minute" + (minutes == 1L ? "" : "s") + " and " + seconds + " second" + (seconds == 1L ? "" : "s");
            }
            return minutes + " minute" + (minutes == 1L ? "" : "s");
        }
        return seconds + " second" + (seconds == 1L ? "" : "s");
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            String prefix = args[0].toLowerCase(Locale.ROOT);
            ArrayList<String> suggestions = new ArrayList<String>();
            if (sender.hasPermission("ezclean.clean") && RUN_SUBCOMMAND.startsWith(prefix)) {
                suggestions.add(RUN_SUBCOMMAND);
            }
            if (sender.hasPermission("ezclean.cancel") && CANCEL_SUBCOMMAND.startsWith(prefix)) {
                suggestions.add(CANCEL_SUBCOMMAND);
            }
            if (sender.hasPermission("ezclean.reload") && RELOAD_SUBCOMMAND.startsWith(prefix)) {
                suggestions.add(RELOAD_SUBCOMMAND);
            }
            if (sender.hasPermission("ezclean.status") && TIME_SUBCOMMAND.startsWith(prefix)) {
                suggestions.add(TIME_SUBCOMMAND);
            }
            if (sender.hasPermission("ezclean.usage") && USAGE_SUBCOMMAND.startsWith(prefix)) {
                suggestions.add(USAGE_SUBCOMMAND);
            }
            return suggestions;
        }
        if (args.length == 2 && RUN_SUBCOMMAND.equalsIgnoreCase(args[0]) && sender.hasPermission("ezclean.clean")) {
            String prefix = args[1].toLowerCase(Locale.ROOT);
            ArrayList<String> suggestions = new ArrayList<String>();
            for (String cleanerId : this.cleanupScheduler.getCleanerIds()) {
                if (!cleanerId.toLowerCase(Locale.ROOT).startsWith(prefix)) continue;
                suggestions.add(cleanerId);
            }
            return suggestions;
        }
        if (args.length == 2 && CANCEL_SUBCOMMAND.equalsIgnoreCase(args[0]) && sender.hasPermission("ezclean.cancel")) {
            String prefix = args[1].toLowerCase(Locale.ROOT);
            ArrayList<String> suggestions = new ArrayList<String>();
            for (String cleanerId : this.cleanupScheduler.getCleanerIds()) {
                if (!cleanerId.toLowerCase(Locale.ROOT).startsWith(prefix)) continue;
                suggestions.add(cleanerId);
            }
            return suggestions;
        }
        if (args.length == 2 && TIME_SUBCOMMAND.equalsIgnoreCase(args[0]) && sender.hasPermission("ezclean.status")) {
            String prefix = args[1].toLowerCase(Locale.ROOT);
            ArrayList<String> suggestions = new ArrayList<String>();
            for (String cleanerId : this.cleanupScheduler.getCleanerIds()) {
                if (!cleanerId.toLowerCase(Locale.ROOT).startsWith(prefix)) continue;
                suggestions.add(cleanerId);
            }
            return suggestions;
        }
        if (args.length == 2 && USAGE_SUBCOMMAND.equalsIgnoreCase(args[0]) && sender.hasPermission("ezclean.usage")) {
            String prefix = args[1].toLowerCase(Locale.ROOT);
            ArrayList<String> suggestions = new ArrayList<String>();
            for (String option : List.of("live", "stop")) {
                if (!option.startsWith(prefix)) continue;
                suggestions.add(option);
            }
            for (String pluginName : this.collectSchedulerUsage().keySet()) {
                if (!pluginName.toLowerCase(Locale.ROOT).startsWith(prefix)) continue;
                suggestions.add(pluginName);
            }
            return suggestions;
        }
        if (args.length == 3 && USAGE_SUBCOMMAND.equalsIgnoreCase(args[0]) && sender.hasPermission("ezclean.usage") && "live".equalsIgnoreCase(args[1])) {
            String prefix = args[2].toLowerCase(Locale.ROOT);
            ArrayList<String> suggestions = new ArrayList<String>();
            for (String pluginName : this.collectSchedulerUsage().keySet()) {
                if (!pluginName.toLowerCase(Locale.ROOT).startsWith(prefix)) continue;
                suggestions.add(pluginName);
            }
            return suggestions;
        }
        return Collections.emptyList();
    }

    private void sendUsage(CommandSender sender, String label) {
        sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /" + label + " run [cleaner_id]");
        sender.sendMessage(String.valueOf(ChatColor.RED) + "       /" + label + " cancel [cleaner_id]");
        sender.sendMessage(String.valueOf(ChatColor.RED) + "       /" + label + " reload");
        sender.sendMessage(String.valueOf(ChatColor.RED) + "       /" + label + " time [cleaner_id]");
        sender.sendMessage(String.valueOf(ChatColor.RED) + "       /" + label + " usage [plugin|live|stop] [plugin]");
    }

    @Nullable
    private String resolveCleanerId(String[] args, List<String> cleanerIds) {
        if (args.length == 1) {
            if (cleanerIds.size() == 1) {
                return cleanerIds.get(0);
            }
            return null;
        }
        String requestedId = args[1];
        for (String candidate : cleanerIds) {
            if (!candidate.equalsIgnoreCase(requestedId)) continue;
            return candidate;
        }
        return null;
    }

    private void sendMiniMessage(Player player, String template, TagResolver ... placeholders) {
        if (template == null || template.isEmpty()) {
            return;
        }
        Component component = MINI_MESSAGE.deserialize(template, placeholders);
        player.sendMessage(component);
    }

    private UsageSnapshot createUsageSnapshot(@Nullable String filter) {
        Map<String, UsageCounts> usageByPlugin = this.collectSchedulerUsage();
        return UsageSnapshot.from(usageByPlugin, filter);
    }

    private void sendUsageSnapshot(CommandSender target, UsageSnapshot snapshot, boolean live, @Nullable String filter, String label, boolean includeInstructions) {
        for (String line : this.formatUsageSnapshot(snapshot, live, filter, label, includeInstructions)) {
            target.sendMessage(line);
        }
    }

    private List<String> formatUsageSnapshot(UsageSnapshot snapshot, boolean live, @Nullable String filter, String label, boolean includeInstructions) {
        ArrayList<String> lines = new ArrayList<String>();
        String headerColor = live ? ChatColor.DARK_AQUA.toString() : ChatColor.GOLD.toString();
        String headerTitle = live ? "Live async scheduler usage" : "Scheduler usage overview";
        StringBuilder headerBuilder = new StringBuilder();
        headerBuilder.append(headerColor).append(ChatColor.BOLD).append(headerTitle).append(ChatColor.RESET).append(ChatColor.DARK_GRAY).append(" \u2022 plugins: ").append(ChatColor.AQUA).append(snapshot.pluginCount());
        if (filter != null && !filter.isEmpty()) {
            headerBuilder.append(ChatColor.DARK_GRAY).append(" \u2022 filter: ").append(ChatColor.AQUA).append(filter);
        }
        lines.add(headerBuilder.toString());
        if (snapshot.isEmpty()) {
            if (filter == null || filter.isEmpty()) {
                lines.add(String.valueOf(ChatColor.GRAY) + "No scheduler activity detected.");
            } else {
                lines.add(String.valueOf(ChatColor.GRAY) + "No scheduler activity currently matches the filter.");
            }
            if (includeInstructions) {
                lines.add(String.valueOf(ChatColor.DARK_GRAY) + "Use /" + label + " usage stop to cancel the live view.");
            }
            return lines;
        }
        lines.add(String.valueOf(ChatColor.GRAY) + "Pending sync: " + String.valueOf(ChatColor.AQUA) + snapshot.totalPendingSync() + String.valueOf(ChatColor.GRAY) + " | Pending async: " + String.valueOf(ChatColor.AQUA) + snapshot.totalPendingAsync() + String.valueOf(ChatColor.GRAY) + " | Active async workers: " + String.valueOf(ChatColor.AQUA) + snapshot.totalActiveAsyncWorkers());
        Map.Entry<String, UsageCounts> peakEntry = snapshot.entries().get(0);
        UsageCounts peakCounts = peakEntry.getValue();
        int peakAsync = peakCounts.getPendingAsync() + peakCounts.getActiveAsyncWorkers();
        lines.add(String.valueOf(ChatColor.GRAY) + "Top async load: " + String.valueOf(ChatColor.AQUA) + peakEntry.getKey() + String.valueOf(ChatColor.GRAY) + " with " + String.valueOf(ChatColor.AQUA) + peakAsync + String.valueOf(ChatColor.GRAY) + " async tasks (" + String.valueOf(ChatColor.AQUA) + peakCounts.getPendingAsync() + String.valueOf(ChatColor.GRAY) + " pending, " + String.valueOf(ChatColor.AQUA) + peakCounts.getActiveAsyncWorkers() + String.valueOf(ChatColor.GRAY) + " workers).");
        int limit = live ? 5 : 10;
        int displayed = 0;
        for (Map.Entry<String, UsageCounts> entry : snapshot.entries()) {
            if (displayed >= limit) break;
            lines.add(this.formatUsageLine(entry, snapshot.maxAsyncLoad()));
            ++displayed;
        }
        if (snapshot.pluginCount() > limit) {
            int remaining = snapshot.pluginCount() - limit;
            lines.add(String.valueOf(ChatColor.DARK_GRAY) + "\u2026 plus " + String.valueOf(ChatColor.AQUA) + remaining + String.valueOf(ChatColor.DARK_GRAY) + " more plugin" + (remaining == 1 ? "" : "s") + ".");
        }
        if (includeInstructions) {
            lines.add(String.valueOf(ChatColor.DARK_GRAY) + "Tip: Use /" + label + " usage live" + (String)(filter != null && !filter.isEmpty() ? " " + filter : "") + " for a live async graph. Use /" + label + " usage stop to cancel.");
        }
        return lines;
    }

    private String formatUsageLine(Map.Entry<String, UsageCounts> entry, int maxAsyncLoad) {
        UsageCounts counts = entry.getValue();
        int asyncLoad = counts.getPendingAsync() + counts.getActiveAsyncWorkers();
        String graph = this.buildAsyncGraph(asyncLoad, maxAsyncLoad);
        ChatColor severity = this.usageSeverityColor(counts.getTotal());
        return String.valueOf(severity) + entry.getKey() + String.valueOf(ChatColor.GRAY) + " " + graph + String.valueOf(ChatColor.DARK_GRAY) + " | " + String.valueOf(ChatColor.AQUA) + asyncLoad + String.valueOf(ChatColor.GRAY) + " async (" + String.valueOf(ChatColor.AQUA) + counts.getPendingAsync() + String.valueOf(ChatColor.GRAY) + " pending, " + String.valueOf(ChatColor.AQUA) + counts.getActiveAsyncWorkers() + String.valueOf(ChatColor.GRAY) + " workers)" + String.valueOf(ChatColor.DARK_GRAY) + " | " + String.valueOf(ChatColor.AQUA) + counts.getPendingSync() + String.valueOf(ChatColor.GRAY) + " sync pending";
    }

    private String buildAsyncGraph(int value, int maxValue) {
        int i;
        int clampedMax = Math.max(1, maxValue);
        int filledSegments = (int)Math.round((double)value / (double)clampedMax * 20.0);
        if (value > 0 && filledSegments == 0) {
            filledSegments = 1;
        }
        if (filledSegments > 20) {
            filledSegments = 20;
        }
        int emptySegments = 20 - filledSegments;
        StringBuilder builder = new StringBuilder();
        builder.append(ChatColor.DARK_GRAY).append('[');
        if (filledSegments > 0) {
            builder.append(ChatColor.AQUA);
            for (i = 0; i < filledSegments; ++i) {
                builder.append('\u2588');
            }
        }
        if (emptySegments > 0) {
            builder.append(ChatColor.DARK_GRAY);
            for (i = 0; i < emptySegments; ++i) {
                builder.append('\u2591');
            }
        }
        builder.append(ChatColor.DARK_GRAY).append(']');
        return builder.toString();
    }

    private void startLiveUsageMonitor(Player player, final String label, final @Nullable String filter) {
        final UUID playerId = player.getUniqueId();
        this.cancelLiveUsage(playerId);
        StringBuilder message = new StringBuilder();
        message.append(ChatColor.GREEN).append("Started live async usage monitor");
        if (filter != null && !filter.isEmpty()) {
            message.append(" for \"").append(filter).append("\"");
        }
        message.append(". Use /").append(label).append(" usage stop to cancel.");
        player.sendMessage(message.toString());
        player.sendMessage(String.valueOf(ChatColor.DARK_GRAY) + "Live summaries refresh in your action bar. Chat updates appear when the load meaningfully changes.");
        final LiveUsageSubscription subscription = new LiveUsageSubscription();
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                Player current = Bukkit.getPlayer((UUID)playerId);
                if (current == null || !current.isOnline()) {
                    EzCleanCommand.this.liveUsageSessions.remove(playerId, subscription);
                    this.cancel();
                    return;
                }
                UsageSnapshot snapshot = EzCleanCommand.this.createUsageSnapshot(filter);
                EzCleanCommand.this.deliverLiveUsageUpdate(current, snapshot, filter, label, subscription);
            }
        };
        BukkitTask task = runnable.runTaskTimer((Plugin)this.plugin, 0L, 10L);
        subscription.setTaskId(task.getTaskId());
        this.liveUsageSessions.put(playerId, subscription);
    }

    private boolean cancelLiveUsage(UUID playerId) {
        LiveUsageSubscription subscription = this.liveUsageSessions.remove(playerId);
        if (subscription != null) {
            Bukkit.getScheduler().cancelTask(subscription.taskId());
            return true;
        }
        return false;
    }

    private void deliverLiveUsageUpdate(Player player, UsageSnapshot snapshot, @Nullable String filter, String label, LiveUsageSubscription subscription) {
        List<String> linesToSend;
        String actionBarTemplate = this.buildLiveActionBarMessage(snapshot);
        Component actionBarComponent = subscription.actionBarFor(actionBarTemplate, () -> MINI_MESSAGE.deserialize(actionBarTemplate));
        String legacyActionBar = LegacyComponentSerializer.legacySection().serialize(actionBarComponent);
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)legacyActionBar));
        List<String> latestLines = this.formatUsageSnapshot(snapshot, true, filter, label, false);
        if (subscription.chatCooldown() > 0) {
            if (!latestLines.equals(subscription.lastChatLines())) {
                subscription.setPendingChatLines(latestLines);
            }
            subscription.decrementChatCooldown();
            return;
        }
        List<String> list = linesToSend = subscription.hasPendingChatLines() ? subscription.consumePendingChatLines() : latestLines;
        if (linesToSend != null && !linesToSend.equals(subscription.lastChatLines())) {
            for (String line : linesToSend) {
                player.sendMessage(line);
            }
            subscription.updateLastChatLines(linesToSend);
        }
        subscription.resetChatCooldown(8);
    }

    private String buildLiveActionBarMessage(UsageSnapshot snapshot) {
        if (snapshot.isEmpty()) {
            return "<gray>Async scheduler idle</gray>";
        }
        Map.Entry<String, UsageCounts> peakEntry = snapshot.entries().get(0);
        UsageCounts counts = peakEntry.getValue();
        int asyncLoad = counts.getPendingAsync() + counts.getActiveAsyncWorkers();
        return "<gray>Sync:</gray> <aqua>" + snapshot.totalPendingSync() + "</aqua> <gray>| Async:</gray> <aqua>" + snapshot.totalPendingAsync() + "</aqua> <gray>| Workers:</gray> <aqua>" + snapshot.totalActiveAsyncWorkers() + "</aqua> <gray>| Top:</gray> <aqua>" + this.escapeMiniMessage(peakEntry.getKey()) + "</aqua> <gray>(" + asyncLoad + ")</gray>";
    }

    private String escapeMiniMessage(String input) {
        if (input == null || input.isEmpty()) {
            return "";
        }
        return input.replace("\\", "\\\\").replace("<", "\\<").replace(">", "\\>");
    }

    private Map<String, UsageCounts> collectSchedulerUsage() {
        UsageCounts counts;
        Plugin owner;
        HashMap<String, UsageCounts> usageByPlugin = new HashMap<String, UsageCounts>();
        BukkitScheduler scheduler = Bukkit.getScheduler();
        for (BukkitTask task : scheduler.getPendingTasks()) {
            owner = task.getOwner();
            if (owner == null) continue;
            counts = usageByPlugin.computeIfAbsent(owner.getName(), key -> new UsageCounts());
            if (task.isSync()) {
                counts.incrementPendingSync();
                continue;
            }
            counts.incrementPendingAsync();
        }
        for (BukkitWorker worker : scheduler.getActiveWorkers()) {
            owner = worker.getOwner();
            if (owner == null) continue;
            counts = usageByPlugin.computeIfAbsent(owner.getName(), key -> new UsageCounts());
            counts.incrementActiveAsyncWorkers();
        }
        return usageByPlugin;
    }

    private ChatColor usageSeverityColor(int total) {
        if (total >= 25) {
            return ChatColor.RED;
        }
        if (total >= 10) {
            return ChatColor.GOLD;
        }
        return ChatColor.GREEN;
    }

    private static final class UsageSnapshot {
        private final List<Map.Entry<String, UsageCounts>> entries;
        private final int totalPendingSync;
        private final int totalPendingAsync;
        private final int totalActiveAsyncWorkers;
        private final int maxAsyncLoad;

        private UsageSnapshot(List<Map.Entry<String, UsageCounts>> entries, int totalPendingSync, int totalPendingAsync, int totalActiveAsyncWorkers, int maxAsyncLoad) {
            this.entries = Collections.unmodifiableList(entries);
            this.totalPendingSync = totalPendingSync;
            this.totalPendingAsync = totalPendingAsync;
            this.totalActiveAsyncWorkers = totalActiveAsyncWorkers;
            this.maxAsyncLoad = maxAsyncLoad;
        }

        static UsageSnapshot from(Map<String, UsageCounts> usageByPlugin, @Nullable String filter) {
            if (usageByPlugin.isEmpty()) {
                return new UsageSnapshot(Collections.emptyList(), 0, 0, 0, 0);
            }
            String normalizedFilter = filter != null ? filter.toLowerCase(Locale.ROOT) : null;
            ArrayList<Map.Entry<String, UsageCounts>> filtered = new ArrayList<Map.Entry<String, UsageCounts>>();
            int totalPendingSync = 0;
            int totalPendingAsync = 0;
            int totalActiveAsyncWorkers = 0;
            int maxAsyncLoad = 0;
            for (Map.Entry<String, UsageCounts> entry2 : usageByPlugin.entrySet()) {
                String pluginName = entry2.getKey();
                if (normalizedFilter != null && !pluginName.toLowerCase(Locale.ROOT).contains(normalizedFilter)) continue;
                UsageCounts counts = entry2.getValue();
                filtered.add(new AbstractMap.SimpleEntry<String, UsageCounts>(pluginName, counts));
                totalPendingSync += counts.getPendingSync();
                totalPendingAsync += counts.getPendingAsync();
                totalActiveAsyncWorkers += counts.getActiveAsyncWorkers();
                int asyncLoad = counts.getPendingAsync() + counts.getActiveAsyncWorkers();
                if (asyncLoad <= maxAsyncLoad) continue;
                maxAsyncLoad = asyncLoad;
            }
            filtered.sort(Comparator.comparingInt(entry -> ((UsageCounts)entry.getValue()).getTotal()).reversed().thenComparing(Map.Entry::getKey));
            if (filtered.isEmpty()) {
                return new UsageSnapshot(Collections.emptyList(), 0, 0, 0, 0);
            }
            return new UsageSnapshot(filtered, totalPendingSync, totalPendingAsync, totalActiveAsyncWorkers, maxAsyncLoad);
        }

        boolean isEmpty() {
            return this.entries.isEmpty();
        }

        List<Map.Entry<String, UsageCounts>> entries() {
            return this.entries;
        }

        int totalPendingSync() {
            return this.totalPendingSync;
        }

        int totalPendingAsync() {
            return this.totalPendingAsync;
        }

        int totalActiveAsyncWorkers() {
            return this.totalActiveAsyncWorkers;
        }

        int maxAsyncLoad() {
            return this.maxAsyncLoad;
        }

        int pluginCount() {
            return this.entries.size();
        }
    }

    private static final class UsageCounts {
        private int pendingSync;
        private int pendingAsync;
        private int activeAsyncWorkers;

        private UsageCounts() {
        }

        int getPendingSync() {
            return this.pendingSync;
        }

        int getPendingAsync() {
            return this.pendingAsync;
        }

        int getActiveAsyncWorkers() {
            return this.activeAsyncWorkers;
        }

        int getTotal() {
            return this.pendingSync + this.pendingAsync + this.activeAsyncWorkers;
        }

        void incrementPendingSync() {
            ++this.pendingSync;
        }

        void incrementPendingAsync() {
            ++this.pendingAsync;
        }

        void incrementActiveAsyncWorkers() {
            ++this.activeAsyncWorkers;
        }
    }

    private static final class LiveUsageSubscription {
        private int taskId;
        private List<String> lastChatLines = Collections.emptyList();
        private int chatCooldown;
        private String lastActionBarRaw;
        private Component lastActionBarComponent;
        private List<String> pendingChatLines;

        private LiveUsageSubscription() {
        }

        int taskId() {
            return this.taskId;
        }

        void setTaskId(int taskId) {
            this.taskId = taskId;
        }

        List<String> lastChatLines() {
            return this.lastChatLines;
        }

        void updateLastChatLines(List<String> lines) {
            this.lastChatLines = Collections.unmodifiableList(new ArrayList<String>(lines));
        }

        int chatCooldown() {
            return this.chatCooldown;
        }

        void resetChatCooldown(int cycles) {
            this.chatCooldown = Math.max(0, cycles);
        }

        void decrementChatCooldown() {
            if (this.chatCooldown > 0) {
                --this.chatCooldown;
            }
        }

        void setPendingChatLines(List<String> lines) {
            this.pendingChatLines = Collections.unmodifiableList(new ArrayList<String>(lines));
        }

        boolean hasPendingChatLines() {
            return this.pendingChatLines != null;
        }

        List<String> consumePendingChatLines() {
            List<String> lines = this.pendingChatLines;
            this.pendingChatLines = null;
            return lines;
        }

        Component actionBarFor(String rawMessage, Supplier<Component> factory) {
            if (rawMessage.equals(this.lastActionBarRaw) && this.lastActionBarComponent != null) {
                return this.lastActionBarComponent;
            }
            Component component = factory.get();
            this.lastActionBarRaw = rawMessage;
            this.lastActionBarComponent = component;
            return component;
        }
    }
}

