/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezclean;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;

public final class WorldGuardCleanupBypass {
    private static final String FLAG_NAME = "ezclean-bypass";
    private static volatile StateFlag registeredFlag;
    private final Logger logger;
    private final RegionContainer regionContainer;
    private final StateFlag bypassFlag;

    private WorldGuardCleanupBypass(Logger logger, RegionContainer regionContainer, StateFlag bypassFlag) {
        this.logger = Objects.requireNonNull(logger, "logger");
        this.regionContainer = Objects.requireNonNull(regionContainer, "regionContainer");
        this.bypassFlag = Objects.requireNonNull(bypassFlag, "bypassFlag");
    }

    public static WorldGuardCleanupBypass create(Logger logger) {
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        if (container == null) {
            throw new IllegalStateException("WorldGuard region container is unavailable.");
        }
        StateFlag bypassFlag = WorldGuardCleanupBypass.resolveRegisteredFlag();
        return new WorldGuardCleanupBypass(logger, container, bypassFlag);
    }

    public static void registerBypassFlag(Logger logger) {
        FlagRegistry registry = WorldGuard.getInstance().getFlagRegistry();
        Flag existing = registry.get(FLAG_NAME);
        if (existing == null) {
            StateFlag flag = new StateFlag(FLAG_NAME, false);
            try {
                registry.register((Flag)flag);
                registeredFlag = flag;
                logger.info(() -> String.format("Registered WorldGuard flag '%s' for EzClean bypass support.", FLAG_NAME));
                return;
            }
            catch (RuntimeException ex) {
                throw new IllegalStateException("Unable to register EzClean WorldGuard flag 'ezclean-bypass'.", ex);
            }
        }
        if (existing instanceof StateFlag) {
            StateFlag stateFlag;
            registeredFlag = stateFlag = (StateFlag)existing;
            logger.info(() -> String.format("Using pre-existing WorldGuard flag '%s' for EzClean bypass support.", FLAG_NAME));
            return;
        }
        throw new IllegalStateException("WorldGuard flag 'ezclean-bypass' is already registered but is not a state flag.");
    }

    private static StateFlag resolveRegisteredFlag() {
        StateFlag flag = registeredFlag;
        if (flag != null) {
            return flag;
        }
        FlagRegistry registry = WorldGuard.getInstance().getFlagRegistry();
        Flag existing = registry.get(FLAG_NAME);
        if (existing instanceof StateFlag) {
            StateFlag stateFlag;
            registeredFlag = stateFlag = (StateFlag)existing;
            return stateFlag;
        }
        throw new IllegalStateException("WorldGuard flag 'ezclean-bypass' has not been registered yet or is not a state flag.");
    }

    public boolean shouldBypass(Entity entity) {
        Location location = entity.getLocation();
        World world = location.getWorld();
        if (world == null) {
            return false;
        }
        RegionManager manager = this.getRegionManager(world);
        if (manager == null) {
            return false;
        }
        try {
            ApplicableRegionSet regions = manager.getApplicableRegions(BlockVector3.at((int)location.getBlockX(), (int)location.getBlockY(), (int)location.getBlockZ()));
            if (regions == null) {
                return false;
            }
            StateFlag.State state = regions.queryState(null, new StateFlag[]{this.bypassFlag});
            return state == StateFlag.State.ALLOW;
        }
        catch (RuntimeException ex) {
            this.logger.log(Level.WARNING, "Failed to query WorldGuard regions for EzClean bypass check.", ex);
            return false;
        }
    }

    private RegionManager getRegionManager(World world) {
        try {
            return this.regionContainer.get(BukkitAdapter.adapt((World)world));
        }
        catch (RuntimeException ex) {
            this.logger.log(Level.WARNING, "Unable to access WorldGuard region manager for world " + world.getName(), ex);
            return null;
        }
    }

    public String getFlagName() {
        return this.bypassFlag.getName();
    }
}

