/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezclean;

import com.skyblockexp.ezclean.CleanupSettings;
import com.skyblockexp.ezclean.DeathChestManager;
import com.skyblockexp.ezclean.DeathChestSettings;
import com.skyblockexp.ezclean.EntityCleanupScheduler;
import com.skyblockexp.ezclean.EzCleanConfigurationLoader;
import com.skyblockexp.ezclean.WorldGuardCleanupBypass;
import com.skyblockexp.ezclean.command.EzCleanCommand;
import com.skyblockexp.ezclean.libs.org.bstats.bukkit.Metrics;
import com.skyblockexp.ezclean.update.SpigotUpdateChecker;
import java.util.List;
import java.util.logging.Level;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;

public final class EzCleanPlugin
extends JavaPlugin {
    private static final int SPIGOT_RESOURCE_ID = 129782;
    private EntityCleanupScheduler cleanupScheduler;
    private WorldGuardCleanupBypass worldGuardBypass;
    @Nullable
    private Economy economy;
    private DeathChestManager deathChestManager;
    private EzCleanConfigurationLoader configurationLoader;
    private FileConfiguration configuration = new YamlConfiguration();

    public void onLoad() {
        Plugin worldGuardPlugin = this.getServer().getPluginManager().getPlugin("WorldGuard");
        if (worldGuardPlugin == null) {
            return;
        }
        try {
            WorldGuardCleanupBypass.registerBypassFlag(this.getLogger());
        }
        catch (Throwable throwable) {
            this.getLogger().log(Level.WARNING, "Failed to pre-register the EzClean WorldGuard bypass flag; region exclusions will be unavailable.", throwable);
        }
    }

    public void onEnable() {
        this.configurationLoader = new EzCleanConfigurationLoader(this);
        this.setupEconomy();
        this.worldGuardBypass = this.initializeWorldGuardBypass();
        List<CleanupSettings> cleanupSettings = this.applyConfiguration(this.configurationLoader.loadConfiguration());
        new Metrics(this, 27736);
        new SpigotUpdateChecker(this, 129782).checkForUpdates();
        this.getLogger().info(() -> String.format("EzClean enabled. Loaded %d cleanup profile(s).", cleanupSettings.size()));
        for (CleanupSettings settings : cleanupSettings) {
            String worlds = String.join((CharSequence)", ", settings.getEnabledWorlds());
            this.getLogger().info(() -> String.format(" - %s: every %d minutes (worlds: %s)", settings.getCleanerId(), settings.getCleanupIntervalMinutes(), worlds));
        }
    }

    public void onDisable() {
        if (this.cleanupScheduler != null) {
            this.cleanupScheduler.disable();
            this.cleanupScheduler = null;
        }
        if (this.deathChestManager != null) {
            this.deathChestManager.shutdown();
            this.deathChestManager = null;
        }
        this.economy = null;
        this.getLogger().info("EzClean plugin has been disabled.");
    }

    public void reloadPluginConfiguration() {
        List<CleanupSettings> cleanupSettings = this.applyConfiguration(this.configurationLoader.loadConfiguration());
        this.getLogger().info(() -> String.format("Reloaded EzClean configuration. Loaded %d cleanup profile(s).", cleanupSettings.size()));
    }

    @Nullable
    public Economy getEconomy() {
        return this.economy;
    }

    private void registerCommands() {
        if (this.cleanupScheduler == null) {
            return;
        }
        EzCleanCommand command = new EzCleanCommand(this, this.cleanupScheduler);
        PluginCommand pluginCommand = this.getCommand("ezclean");
        if (pluginCommand == null) {
            this.getLogger().warning("Failed to register /ezclean command; entry missing from plugin.yml.");
            return;
        }
        pluginCommand.setExecutor((CommandExecutor)command);
        pluginCommand.setTabCompleter((TabCompleter)command);
    }

    private WorldGuardCleanupBypass initializeWorldGuardBypass() {
        Plugin worldGuardPlugin = this.getServer().getPluginManager().getPlugin("WorldGuard");
        if (worldGuardPlugin == null || !worldGuardPlugin.isEnabled()) {
            return null;
        }
        try {
            WorldGuardCleanupBypass bypass = WorldGuardCleanupBypass.create(this.getLogger());
            this.getLogger().info(() -> String.format("WorldGuard detected; regions with the '%s' flag set to ALLOW will be skipped during cleanups.", bypass.getFlagName()));
            return bypass;
        }
        catch (Throwable throwable) {
            this.getLogger().log(Level.WARNING, "Failed to initialize WorldGuard cleanup bypass support; continuing without region exclusions.", throwable);
            return null;
        }
    }

    private void setupEconomy() {
        RegisteredServiceProvider registration = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (registration == null) {
            this.getLogger().info("No Vault economy provider detected. Pay-to-cancel will be disabled.");
            this.economy = null;
            return;
        }
        Economy provider = (Economy)registration.getProvider();
        if (provider == null) {
            this.getLogger().warning("Vault returned a null economy provider. Pay-to-cancel will be disabled.");
            this.economy = null;
            return;
        }
        this.economy = provider;
        this.getLogger().info("Vault economy detected. Players can pay to cancel upcoming cleanups when enabled.");
    }

    public FileConfiguration getConfig() {
        return this.configuration;
    }

    private List<CleanupSettings> applyConfiguration(FileConfiguration newConfiguration) {
        this.configuration = newConfiguration;
        List<CleanupSettings> cleanupSettings = CleanupSettings.fromConfiguration(this.configuration, this.getLogger());
        DeathChestSettings deathChestSettings = DeathChestSettings.fromConfiguration(this.configuration);
        if (this.cleanupScheduler != null) {
            this.cleanupScheduler.disable();
        }
        this.cleanupScheduler = new EntityCleanupScheduler(this, cleanupSettings, this.worldGuardBypass);
        this.cleanupScheduler.enable();
        if (this.deathChestManager == null) {
            this.deathChestManager = new DeathChestManager(this, deathChestSettings);
        } else {
            this.deathChestManager.applySettings(deathChestSettings);
        }
        this.registerCommands();
        return cleanupSettings;
    }
}

