/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezclean;

import com.skyblockexp.ezclean.EzCleanPlugin;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

final class EzCleanConfigurationLoader {
    private static final String DEATH_CHESTS_FILE_NAME = "death-chests.yml";
    private static final String MESSAGES_FILE_NAME = "messages.yml";
    private static final String CLEANERS_DIRECTORY_NAME = "cleaners";
    private static final String DEFAULT_CLEANER_RESOURCE = "cleaners/default.yml";
    private final EzCleanPlugin plugin;
    private final Logger logger;

    EzCleanConfigurationLoader(EzCleanPlugin plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
    }

    FileConfiguration loadConfiguration() {
        File dataFolder = this.plugin.getDataFolder();
        if (!dataFolder.exists() && !dataFolder.mkdirs()) {
            this.logger.warning("Unable to create the EzClean data folder; continuing with in-memory defaults.");
        }
        this.migrateLegacyConfigurationIfNecessary();
        this.ensureDefaultSplitConfiguration();
        File deathChestFile = new File(dataFolder, DEATH_CHESTS_FILE_NAME);
        File messagesFile = new File(dataFolder, MESSAGES_FILE_NAME);
        File cleanersDirectory = new File(dataFolder, CLEANERS_DIRECTORY_NAME);
        return this.assembleConfiguration(deathChestFile, cleanersDirectory, messagesFile);
    }

    private void migrateLegacyConfigurationIfNecessary() {
        File cleanerFile;
        File cleanersDirectory;
        ConfigurationSection deathChestSection;
        File dataFolder = this.plugin.getDataFolder();
        File legacyConfigFile = new File(dataFolder, "config.yml");
        if (!legacyConfigFile.exists()) {
            return;
        }
        YamlConfiguration legacyConfiguration = YamlConfiguration.loadConfiguration((File)legacyConfigFile);
        File deathChestFile = new File(dataFolder, DEATH_CHESTS_FILE_NAME);
        if (!deathChestFile.exists() && (deathChestSection = legacyConfiguration.getConfigurationSection("death-chests")) != null && !deathChestSection.getKeys(false).isEmpty()) {
            YamlConfiguration output = new YamlConfiguration();
            EzCleanConfigurationLoader.copySection(deathChestSection, (ConfigurationSection)output);
            this.saveYaml(output, deathChestFile, "death chest settings");
        }
        if (!(cleanersDirectory = new File(dataFolder, CLEANERS_DIRECTORY_NAME)).exists() && !cleanersDirectory.mkdirs()) {
            this.logger.warning("Unable to create the EzClean cleaners directory while migrating legacy configuration.");
            return;
        }
        if (EzCleanConfigurationLoader.hasYamlFiles(cleanersDirectory)) {
            return;
        }
        ConfigurationSection cleanersSection = legacyConfiguration.getConfigurationSection(CLEANERS_DIRECTORY_NAME);
        if (cleanersSection != null && !cleanersSection.getKeys(false).isEmpty()) {
            for (String cleanerId : cleanersSection.getKeys(false)) {
                File cleanerFile2;
                ConfigurationSection cleanerSection = cleanersSection.getConfigurationSection(cleanerId);
                if (cleanerSection == null || cleanerSection.getKeys(true).isEmpty() || (cleanerFile2 = new File(cleanersDirectory, EzCleanConfigurationLoader.toCleanerFileName(cleanerId))).exists()) continue;
                YamlConfiguration output = new YamlConfiguration();
                EzCleanConfigurationLoader.copySection(cleanerSection, (ConfigurationSection)output);
                this.saveYaml(output, cleanerFile2, String.format(Locale.ROOT, "cleanup profile '%s'", cleanerId));
            }
            return;
        }
        ConfigurationSection legacyCleanupSection = legacyConfiguration.getConfigurationSection("cleanup");
        if (legacyCleanupSection != null && !legacyCleanupSection.getKeys(false).isEmpty() && !(cleanerFile = new File(cleanersDirectory, "default.yml")).exists()) {
            YamlConfiguration output = new YamlConfiguration();
            EzCleanConfigurationLoader.copySection(legacyCleanupSection, (ConfigurationSection)output);
            this.saveYaml(output, cleanerFile, "legacy cleanup profile");
        }
    }

    private void ensureDefaultSplitConfiguration() {
        File messagesFile;
        File cleanersDirectory;
        File deathChestFile;
        File dataFolder = this.plugin.getDataFolder();
        File configNotice = new File(dataFolder, "config.yml");
        if (!configNotice.exists()) {
            this.plugin.saveResource("config.yml", false);
        }
        if (!(deathChestFile = new File(dataFolder, DEATH_CHESTS_FILE_NAME)).exists()) {
            this.plugin.saveResource(DEATH_CHESTS_FILE_NAME, false);
        }
        if (!(cleanersDirectory = new File(dataFolder, CLEANERS_DIRECTORY_NAME)).exists() && !cleanersDirectory.mkdirs()) {
            this.logger.warning("Unable to create the EzClean cleaners directory.");
            return;
        }
        if (!EzCleanConfigurationLoader.hasYamlFiles(cleanersDirectory)) {
            this.plugin.saveResource(DEFAULT_CLEANER_RESOURCE, false);
        }
        if (!(messagesFile = new File(dataFolder, MESSAGES_FILE_NAME)).exists()) {
            this.plugin.saveResource(MESSAGES_FILE_NAME, false);
        }
    }

    private FileConfiguration assembleConfiguration(File deathChestFile, File cleanersDirectory, File messagesFile) {
        YamlConfiguration combined = new YamlConfiguration();
        YamlConfiguration deathChestConfiguration = YamlConfiguration.loadConfiguration((File)deathChestFile);
        EzCleanConfigurationLoader.copySection((ConfigurationSection)deathChestConfiguration, combined.createSection("death-chests"));
        if (messagesFile.isFile()) {
            YamlConfiguration messagesConfiguration = YamlConfiguration.loadConfiguration((File)messagesFile);
            EzCleanConfigurationLoader.copySection((ConfigurationSection)messagesConfiguration, combined.createSection("messages"));
        } else {
            this.logger.warning("EzClean messages.yml was not found; using built-in message defaults.");
        }
        ConfigurationSection cleanersSection = combined.createSection(CLEANERS_DIRECTORY_NAME);
        File[] cleanerFiles = cleanersDirectory.listFiles(file -> file.isFile() && EzCleanConfigurationLoader.isYamlFile(file.getName()));
        if (cleanerFiles == null || cleanerFiles.length == 0) {
            this.logger.warning("No EzClean cleaner profiles were found; using built-in defaults.");
            return combined;
        }
        Arrays.sort(cleanerFiles, Comparator.comparing(File::getName, String.CASE_INSENSITIVE_ORDER));
        for (File cleanerFile : cleanerFiles) {
            YamlConfiguration cleanerConfiguration = YamlConfiguration.loadConfiguration((File)cleanerFile);
            String cleanerId = EzCleanConfigurationLoader.fileNameWithoutExtension(cleanerFile.getName());
            ConfigurationSection cleanerSection = cleanersSection.createSection(cleanerId);
            EzCleanConfigurationLoader.copySection((ConfigurationSection)cleanerConfiguration, cleanerSection);
        }
        return combined;
    }

    private static void copySection(ConfigurationSection source, ConfigurationSection target) {
        for (String key : source.getKeys(false)) {
            if (source.isConfigurationSection(key)) {
                ConfigurationSection childTarget = target.createSection(key);
                EzCleanConfigurationLoader.copySection(source.getConfigurationSection(key), childTarget);
                continue;
            }
            target.set(key, source.get(key));
        }
    }

    private void saveYaml(YamlConfiguration configuration, File destination, String description) {
        try {
            configuration.save(destination);
            this.logger.info(() -> String.format(Locale.ROOT, "Migrated %s to %s.", description, destination.getName()));
        }
        catch (IOException ex) {
            this.logger.log(Level.WARNING, String.format(Locale.ROOT, "Failed to save %s while migrating EzClean configuration.", description), ex);
        }
    }

    private static boolean hasYamlFiles(File directory) {
        File[] files = directory.listFiles(file -> file.isFile() && EzCleanConfigurationLoader.isYamlFile(file.getName()));
        return files != null && files.length > 0;
    }

    private static boolean isYamlFile(String name) {
        String lower = name.toLowerCase(Locale.ROOT);
        return lower.endsWith(".yml") || lower.endsWith(".yaml");
    }

    private static String toCleanerFileName(String cleanerId) {
        String sanitized = cleanerId.replaceAll("[^A-Za-z0-9-_]+", "-");
        if (sanitized.isBlank()) {
            sanitized = "cleaner";
        }
        return sanitized + ".yml";
    }

    private static String fileNameWithoutExtension(String name) {
        int index = name.lastIndexOf(46);
        return index > 0 ? name.substring(0, index) : name;
    }
}

