/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezclean;

import com.skyblockexp.ezclean.CleanupSettings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.Nullable;

final class EntityPileDetector {
    private final CleanupSettings.PileDetectionSettings settings;
    private final Map<PileKey, Integer> counts = new HashMap<PileKey, Integer>();

    private EntityPileDetector(CleanupSettings.PileDetectionSettings settings) {
        this.settings = settings;
    }

    @Nullable
    static EntityPileDetector create(@Nullable CleanupSettings.PileDetectionSettings settings) {
        if (settings == null) {
            return null;
        }
        return new EntityPileDetector(settings);
    }

    boolean shouldCull(Entity entity) {
        String customName;
        EntityType type = entity.getType();
        if (!this.settings.isTracking(type)) {
            return false;
        }
        if (this.settings.ignoreNamedEntities() && (customName = entity.getCustomName()) != null && !customName.isBlank()) {
            return false;
        }
        Location location = entity.getLocation();
        PileKey key = new PileKey(entity.getWorld().getUID(), location.getBlockX(), location.getBlockY(), location.getBlockZ(), type);
        int total = this.counts.merge(key, 1, Integer::sum);
        return total > this.settings.getMaxPerBlock();
    }

    private record PileKey(UUID worldId, int blockX, int blockY, int blockZ, EntityType type) {
        private PileKey {
            Objects.requireNonNull(worldId, "worldId");
            Objects.requireNonNull(type, "type");
        }
    }
}

