/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezclean;

import com.skyblockexp.ezclean.CleanupCancelSettings;
import com.skyblockexp.ezclean.CleanupSettings;
import com.skyblockexp.ezclean.EntityPileDetector;
import com.skyblockexp.ezclean.WorldGuardCleanupBypass;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.Allay;
import org.bukkit.entity.Ambient;
import org.bukkit.entity.Animals;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Display;
import org.bukkit.entity.Enemy;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Golem;
import org.bukkit.entity.Item;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.WaterMob;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.Nullable;

public final class EntityCleanupScheduler {
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private static final long TICKS_PER_MINUTE = 1200L;
    private static final long MILLIS_PER_MINUTE = 60000L;
    private static final String CANCEL_PERMISSION = "ezclean.cancel";
    private static final EnumSet<EntityType> BASIC_VEHICLE_TYPES = EntityCleanupScheduler.createBasicVehicleTypes();
    private final JavaPlugin plugin;
    private List<CleanupSettings> cleanupSettings;
    @Nullable
    private final WorldGuardCleanupBypass worldGuardBypass;
    private final List<ScheduledCleanup> scheduledCleanups = new ArrayList<ScheduledCleanup>();

    public EntityCleanupScheduler(JavaPlugin plugin, List<CleanupSettings> settings, @Nullable WorldGuardCleanupBypass worldGuardBypass) {
        this.plugin = plugin;
        this.cleanupSettings = new ArrayList<CleanupSettings>(settings);
        this.worldGuardBypass = worldGuardBypass;
    }

    public void enable() {
        for (CleanupSettings settings : this.cleanupSettings) {
            this.scheduleCleanupTasks(settings);
        }
    }

    public void disable() {
        for (ScheduledCleanup scheduled : this.scheduledCleanups) {
            scheduled.cancel();
        }
        this.scheduledCleanups.clear();
    }

    public void reload(List<CleanupSettings> newSettings) {
        this.cleanupSettings = new ArrayList<CleanupSettings>(newSettings);
        this.disable();
        this.enable();
    }

    public List<String> getCleanerIds() {
        ArrayList<String> cleanerIds = new ArrayList<String>();
        for (CleanupSettings settings : this.cleanupSettings) {
            cleanerIds.add(settings.getCleanerId());
        }
        return Collections.unmodifiableList(cleanerIds);
    }

    public boolean triggerCleanup(String cleanerId) {
        if (cleanerId == null) {
            return false;
        }
        String normalized = cleanerId.toLowerCase(Locale.ROOT);
        for (ScheduledCleanup scheduled : this.scheduledCleanups) {
            if (!scheduled.matchesCleaner(normalized)) continue;
            scheduled.triggerNow();
            return true;
        }
        return false;
    }

    public Duration getTimeUntilCleanup(String cleanerId) {
        ScheduledCleanup scheduled = this.findScheduled(cleanerId);
        return scheduled != null ? scheduled.getTimeUntilCleanup() : null;
    }

    @Nullable
    public CleanupSettings getSettings(String cleanerId) {
        ScheduledCleanup scheduled = this.findScheduled(cleanerId);
        if (scheduled != null) {
            return scheduled.getSettings();
        }
        if (cleanerId == null) {
            return null;
        }
        String normalized = cleanerId.toLowerCase(Locale.ROOT);
        for (CleanupSettings settings : this.cleanupSettings) {
            if (!settings.getCleanerId().toLowerCase(Locale.ROOT).equals(normalized)) continue;
            return settings;
        }
        return null;
    }

    @Nullable
    public Duration cancelNextCleanup(String cleanerId) {
        ScheduledCleanup scheduled = this.findScheduled(cleanerId);
        return scheduled != null ? scheduled.cancelNextRun() : null;
    }

    private void scheduleCleanupTasks(CleanupSettings settings) {
        ScheduledCleanup scheduled = new ScheduledCleanup(settings);
        scheduled.start();
        this.scheduledCleanups.add(scheduled);
    }

    private void performCleanup(CleanupSettings settings) {
        if (settings.isStartBroadcastEnabled()) {
            Component message = MINI_MESSAGE.deserialize(settings.getStartMessageTemplate(), (TagResolver)Placeholder.parsed("cleaner", settings.getCleanerId()));
            String legacyMessage = LegacyComponentSerializer.legacySection().serialize(message);
            for (Player player : Bukkit.getOnlinePlayers()) {
                player.sendMessage(legacyMessage);
            }
            Bukkit.getServer().getConsoleSender().sendMessage(legacyMessage);
        }
        EntityPileDetector pileDetector = EntityPileDetector.create(settings.getPileDetectionSettings());
        int removed = 0;
        for (World world : Bukkit.getWorlds()) {
            if (!settings.isWorldEnabled(world.getName())) continue;
            for (Entity entity : world.getEntities()) {
                if (!this.shouldRemove(entity, settings, pileDetector)) continue;
                entity.remove();
                ++removed;
            }
        }
        if (settings.isSummaryBroadcastEnabled()) {
            Component message = MINI_MESSAGE.deserialize(settings.getSummaryMessageTemplate(), Placeholder.parsed("count", Integer.toString(removed)), Placeholder.parsed("minutes", Long.toString(settings.getCleanupIntervalMinutes())), Placeholder.parsed("cleaner", settings.getCleanerId()));
            String legacyMessage = LegacyComponentSerializer.legacySection().serialize(message);
            for (Player player : Bukkit.getOnlinePlayers()) {
                player.sendMessage(legacyMessage);
            }
            Bukkit.getServer().getConsoleSender().sendMessage(legacyMessage);
        }
    }

    boolean shouldRemove(Entity entity, CleanupSettings settings, @Nullable EntityPileDetector pileDetector) {
        Tameable tameable;
        if (this.worldGuardBypass != null && this.worldGuardBypass.shouldBypass(entity)) {
            return false;
        }
        if (settings.isForcedKeep(entity.getType())) {
            return false;
        }
        if (settings.isForcedRemoval(entity.getType())) {
            return true;
        }
        if (entity instanceof Player && settings.protectPlayers()) {
            return false;
        }
        if (entity instanceof ArmorStand && settings.protectArmorStands()) {
            return false;
        }
        if (entity instanceof Display && settings.protectDisplayEntities()) {
            return false;
        }
        if (entity instanceof Tameable && (tameable = (Tameable)entity).isTamed() && settings.protectTamedMobs()) {
            return false;
        }
        if (entity instanceof Mob) {
            String customName;
            Mob mob = (Mob)entity;
            if (settings.protectNameTaggedMobs() && (customName = mob.getCustomName()) != null && !customName.isBlank()) {
                return false;
            }
        }
        if (entity instanceof Enemy && settings.removeHostileMobs()) {
            return true;
        }
        if (entity instanceof AbstractVillager && settings.removeVillagers()) {
            return true;
        }
        if (settings.removePassiveMobs() && (entity instanceof Animals || entity instanceof WaterMob || entity instanceof Ambient || entity instanceof Golem || entity instanceof Allay || entity instanceof Mob && !(entity instanceof Enemy))) {
            return true;
        }
        if (settings.removeVehicles() && EntityCleanupScheduler.isVehicleEntity(entity)) {
            return true;
        }
        if (entity instanceof Item && settings.removeDroppedItems()) {
            return true;
        }
        if (entity instanceof ExperienceOrb && settings.removeExperienceOrbs()) {
            return true;
        }
        if (entity instanceof Projectile && settings.removeProjectiles()) {
            return true;
        }
        if (entity instanceof AreaEffectCloud && settings.removeAreaEffectClouds()) {
            return true;
        }
        if (entity instanceof FallingBlock && settings.removeFallingBlocks()) {
            return true;
        }
        if (entity instanceof TNTPrimed && settings.removePrimedTnt()) {
            return true;
        }
        return pileDetector != null && pileDetector.shouldCull(entity);
    }

    private static boolean isVehicleEntity(Entity entity) {
        if (entity instanceof Vehicle) {
            return true;
        }
        EntityType type = entity.getType();
        if (type == null) {
            return false;
        }
        if (BASIC_VEHICLE_TYPES.contains(type)) {
            return true;
        }
        String typeName = type.name();
        return typeName.contains("MINECART");
    }

    private static EnumSet<EntityType> createBasicVehicleTypes() {
        EnumSet<EntityType> types = EnumSet.noneOf(EntityType.class);
        for (EntityType type : EntityType.values()) {
            String name = type.name();
            if (!name.equals("MINECART") && !name.equals("BOAT") && !name.equals("CHEST_BOAT") && !name.endsWith("_MINECART") && !name.endsWith("_BOAT") && !name.endsWith("_RAFT")) continue;
            types.add(type);
        }
        return types;
    }

    private void sendWarningBroadcast(CleanupSettings settings, long minutesRemaining) {
        Component message = MINI_MESSAGE.deserialize(settings.getWarningMessageTemplate(), this.createBroadcastPlaceholders(settings, minutesRemaining));
        this.broadcastCountdownMessage(settings, message);
    }

    private void sendIntervalBroadcast(CleanupSettings settings, long minutesRemaining) {
        Component message = MINI_MESSAGE.deserialize(settings.getIntervalBroadcastMessageTemplate(), this.createBroadcastPlaceholders(settings, minutesRemaining));
        this.broadcastCountdownMessage(settings, message);
    }

    private void sendDynamicBroadcast(CleanupSettings settings, long minutesRemaining) {
        Component message = MINI_MESSAGE.deserialize(settings.getDynamicBroadcastMessageTemplate(), this.createBroadcastPlaceholders(settings, minutesRemaining));
        this.broadcastCountdownMessage(settings, message);
    }

    private void handleCountdownBroadcasts(CleanupSettings settings, long minutesRemaining) {
        long intervalMinutes;
        Set<Long> dynamicMinutes;
        if (settings.isWarningEnabled() && minutesRemaining == settings.getWarningMinutesBefore()) {
            this.sendWarningBroadcast(settings, minutesRemaining);
        }
        if (settings.isDynamicBroadcastEnabled() && (dynamicMinutes = settings.getDynamicBroadcastMinutes()).contains(minutesRemaining)) {
            this.sendDynamicBroadcast(settings, minutesRemaining);
        }
        if (minutesRemaining <= 0L) {
            return;
        }
        if (settings.isIntervalBroadcastEnabled() && (intervalMinutes = settings.getIntervalBroadcastMinutes()) > 0L && minutesRemaining % intervalMinutes == 0L) {
            this.sendIntervalBroadcast(settings, minutesRemaining);
        }
    }

    private TagResolver[] createBroadcastPlaceholders(CleanupSettings settings, long minutesRemaining) {
        ArrayList<TagResolver.Single> placeholders = new ArrayList<TagResolver.Single>();
        placeholders.add(Placeholder.parsed("minutes", Long.toString(minutesRemaining)));
        placeholders.add(Placeholder.parsed("cleaner", settings.getCleanerId()));
        CleanupCancelSettings cancelSettings = settings.getCancelSettings();
        if (cancelSettings.isEnabled()) {
            placeholders.add(Placeholder.parsed("cost", cancelSettings.getFormattedCost()));
        }
        return (TagResolver[])placeholders.toArray(TagResolver[]::new);
    }

    private void broadcastCountdownMessage(CleanupSettings settings, Component baseMessage) {
        CleanupCancelSettings cancelSettings = settings.getCancelSettings();
        if (!cancelSettings.isEnabled()) {
            String legacyMessage = LegacyComponentSerializer.legacySection().serialize(baseMessage);
            for (Player player : Bukkit.getOnlinePlayers()) {
                player.sendMessage(legacyMessage);
            }
            Bukkit.getServer().getConsoleSender().sendMessage(legacyMessage);
            return;
        }
        Component interactiveMessage = this.applyCancelInteraction(settings, baseMessage);
        Bukkit.getServer().getConsoleSender().sendMessage(baseMessage);
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (player.hasPermission(CANCEL_PERMISSION)) {
                player.sendMessage(interactiveMessage);
                continue;
            }
            player.sendMessage(baseMessage);
        }
    }

    private Component applyCancelInteraction(CleanupSettings settings, Component message) {
        CleanupCancelSettings cancelSettings = settings.getCancelSettings();
        if (!cancelSettings.isEnabled()) {
            return message;
        }
        String command = "/ezclean cancel " + settings.getCleanerId();
        message = message.clickEvent(ClickEvent.runCommand(command));
        String hoverTemplate = cancelSettings.getHoverMessage();
        if (hoverTemplate != null && !hoverTemplate.isEmpty()) {
            Component hover = MINI_MESSAGE.deserialize(hoverTemplate, Placeholder.parsed("cleaner", settings.getCleanerId()), Placeholder.parsed("cost", cancelSettings.getFormattedCost()));
            message = message.hoverEvent(HoverEvent.showText(hover));
        }
        return message;
    }

    @Nullable
    private ScheduledCleanup findScheduled(String cleanerId) {
        if (cleanerId == null) {
            return null;
        }
        String normalized = cleanerId.toLowerCase(Locale.ROOT);
        for (ScheduledCleanup scheduled : this.scheduledCleanups) {
            if (!scheduled.matchesCleaner(normalized)) continue;
            return scheduled;
        }
        return null;
    }

    private final class ScheduledCleanup {
        private final CleanupSettings settings;
        private final String normalizedCleanerId;
        private long minutesUntilCleanup;
        private BukkitTask countdownTask;
        private long lastTickMillis;

        private ScheduledCleanup(CleanupSettings settings) {
            this.settings = settings;
            this.normalizedCleanerId = settings.getCleanerId().toLowerCase(Locale.ROOT);
        }

        private void start() {
            this.minutesUntilCleanup = Math.max(1L, this.settings.getCleanupIntervalMinutes());
            this.lastTickMillis = System.currentTimeMillis();
            this.countdownTask = Bukkit.getScheduler().runTaskTimer((Plugin)EntityCleanupScheduler.this.plugin, this::tick, 1200L, 1200L);
        }

        private void tick() {
            long now = System.currentTimeMillis();
            --this.minutesUntilCleanup;
            if (this.minutesUntilCleanup < 0L) {
                this.minutesUntilCleanup = 0L;
            }
            EntityCleanupScheduler.this.handleCountdownBroadcasts(this.settings, this.minutesUntilCleanup);
            if (this.minutesUntilCleanup <= 0L) {
                EntityCleanupScheduler.this.performCleanup(this.settings);
                this.minutesUntilCleanup = Math.max(1L, this.settings.getCleanupIntervalMinutes());
            }
            this.lastTickMillis = now;
        }

        private void cancel() {
            if (this.countdownTask != null) {
                this.countdownTask.cancel();
                this.countdownTask = null;
            }
        }

        private boolean matchesCleaner(String normalizedCleanerId) {
            return this.normalizedCleanerId.equals(normalizedCleanerId);
        }

        private void triggerNow() {
            EntityCleanupScheduler.this.performCleanup(this.settings);
            this.minutesUntilCleanup = Math.max(1L, this.settings.getCleanupIntervalMinutes());
            this.lastTickMillis = System.currentTimeMillis();
        }

        private Duration cancelNextRun() {
            this.minutesUntilCleanup = Math.max(1L, this.settings.getCleanupIntervalMinutes());
            this.lastTickMillis = System.currentTimeMillis();
            return Duration.ofMinutes(this.minutesUntilCleanup);
        }

        private Duration getTimeUntilCleanup() {
            long now = System.currentTimeMillis();
            long elapsedSinceLastTick = Math.max(0L, now - this.lastTickMillis);
            long remainingMillis = this.minutesUntilCleanup * 60000L - elapsedSinceLastTick;
            if (remainingMillis <= 0L) {
                return Duration.ZERO;
            }
            return Duration.ofMillis(remainingMillis);
        }

        private CleanupSettings getSettings() {
            return this.settings;
        }
    }
}

