/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezclean;

import com.skyblockexp.ezclean.DeathChest;
import com.skyblockexp.ezclean.DeathChestInventoryHolder;
import com.skyblockexp.ezclean.DeathChestSettings;
import com.skyblockexp.ezclean.EzCleanPlugin;
import com.skyblockexp.ezclean.RemovalReason;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public final class DeathChestManager
implements Listener {
    private static final int INVENTORY_SIZE = 54;
    private static final Method BUKKIT_CREATE_INVENTORY_COMPONENT;
    private static final Method BUKKIT_CREATE_INVENTORY_STRING;
    private final EzCleanPlugin plugin;
    private final Map<Location, DeathChest> chestsByLocation = new HashMap<Location, DeathChest>();
    private final Map<UUID, List<DeathChest>> chestsByPlayer = new HashMap<UUID, List<DeathChest>>();
    private DeathChestSettings settings;
    private boolean registered;

    public DeathChestSettings getSettings() {
        return this.settings;
    }

    public EzCleanPlugin getPlugin() {
        return this.plugin;
    }

    public DeathChestManager(EzCleanPlugin plugin, DeathChestSettings initialSettings) {
        this.plugin = plugin;
        this.settings = Objects.requireNonNull(initialSettings, "initialSettings");
        if (initialSettings.isEnabled()) {
            this.register();
        }
    }

    public void applySettings(DeathChestSettings newSettings) {
        Objects.requireNonNull(newSettings, "newSettings");
        boolean wasEnabled = this.settings != null && this.settings.isEnabled();
        this.settings = newSettings;
        if (!wasEnabled && newSettings.isEnabled()) {
            this.register();
        } else if (wasEnabled && !newSettings.isEnabled()) {
            this.unregister();
            this.removeAllChests(RemovalReason.DISABLED);
        }
    }

    public void shutdown() {
        this.unregister();
        this.removeAllChests(RemovalReason.PLUGIN_DISABLE);
    }

    private void register() {
        if (this.registered) {
            return;
        }
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        this.registered = true;
    }

    private void unregister() {
        if (!this.registered) {
            return;
        }
        HandlerList.unregisterAll((Listener)this);
        this.registered = false;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerDeath(PlayerDeathEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (event.getDrops().isEmpty()) {
            return;
        }
        Location placement = this.findChestLocation(event.getEntity().getLocation());
        if (placement == null) {
            return;
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>(event.getDrops());
        event.getDrops().clear();
        this.spawnDeathChest(event.getEntity(), placement, drops);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onChestInteract(PlayerInteractEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (!event.hasBlock()) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        DeathChest chest = this.chestsByLocation.get(block.getLocation().toBlockLocation());
        if (chest == null) {
            return;
        }
        event.setCancelled(true);
        chest.open(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onDeathChestBreak(BlockBreakEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        DeathChest chest = this.chestsByLocation.get(event.getBlock().getLocation().toBlockLocation());
        if (chest == null) {
            return;
        }
        event.setDropItems(false);
        event.setExpToDrop(0);
        this.removeChest(chest, RemovalReason.BROKEN);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onDeathChestInventoryClose(InventoryCloseEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        InventoryHolder holder = event.getInventory().getHolder();
        if (!(holder instanceof DeathChestInventoryHolder)) {
            return;
        }
        DeathChestInventoryHolder deathChestHolder = (DeathChestInventoryHolder)holder;
        DeathChest chest = deathChestHolder.getDeathChest();
        if (chest == null) {
            return;
        }
        if (event.getInventory().isEmpty()) {
            this.removeChest(chest, RemovalReason.EMPTY);
        }
    }

    private boolean isEnabled() {
        return this.settings != null && this.settings.isEnabled();
    }

    private void spawnDeathChest(Player player, Location location, List<ItemStack> drops) {
        int maxChests = this.settings.getMaxChestsPerPlayer();
        UUID uuid = player.getUniqueId();
        if (maxChests > 0 && !player.hasPermission("ezclean.deathchest.limit.bypass")) {
            List playerChests = this.chestsByPlayer.getOrDefault(uuid, new ArrayList());
            while (playerChests.size() >= maxChests) {
                DeathChest oldest = (DeathChest)playerChests.remove(0);
                this.removeChest(oldest, RemovalReason.DESPAWN);
            }
        }
        Block block = location.getBlock();
        block.setType(Material.CHEST);
        BlockState state = block.getState();
        if (state instanceof Chest) {
            Chest chest = (Chest)state;
            chest.update(true, false);
        }
        long protectionEndMillis = 0L;
        UUID owner = null;
        if (this.settings.isLootProtectionEnabled() && this.settings.getLootProtectionMinutes() > 0) {
            owner = player.getUniqueId();
            protectionEndMillis = System.currentTimeMillis() + (long)this.settings.getLootProtectionMinutes() * 60000L;
        }
        DeathChest deathChest = owner != null ? new DeathChest(this, location.toBlockLocation(), drops, this.settings.getDespawnAfter(), owner, protectionEndMillis) : new DeathChest(this, location.toBlockLocation(), drops, this.settings.getDespawnAfter());
        this.chestsByLocation.put(deathChest.getLocation(), deathChest);
        this.chestsByPlayer.computeIfAbsent(uuid, k -> new ArrayList()).add(deathChest);
        deathChest.place();
    }

    public void removeChest(DeathChest chest, RemovalReason reason) {
        this.chestsByLocation.remove(chest.getLocation());
        for (List<DeathChest> list : this.chestsByPlayer.values()) {
            list.remove(chest);
        }
        chest.destroy(reason);
    }

    private void removeAllChests(RemovalReason reason) {
        if (this.chestsByLocation.isEmpty()) {
            return;
        }
        ArrayList<DeathChest> active = new ArrayList<DeathChest>(this.chestsByLocation.values());
        this.chestsByLocation.clear();
        this.chestsByPlayer.clear();
        for (DeathChest chest : active) {
            chest.destroy(reason);
        }
    }

    @Nullable
    private Location findChestLocation(Location deathLocation) {
        Location base;
        Location location = base = deathLocation == null ? null : deathLocation.getBlock().getLocation();
        if (base == null || base.getWorld() == null) {
            return null;
        }
        Location candidate = this.searchAround(base);
        if (candidate != null) {
            return candidate;
        }
        Location above = base.clone().add(0.0, 1.0, 0.0);
        return this.searchAround(above);
    }

    @Nullable
    private Location searchAround(Location origin) {
        Location base = origin.toBlockLocation();
        if (this.isValidPlacement(base)) {
            return base;
        }
        for (int y = 0; y <= 2; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    Location test = origin.clone().add((double)x, (double)y, (double)z).toBlockLocation();
                    if (!this.isValidPlacement(test)) continue;
                    return test;
                }
            }
        }
        return null;
    }

    private boolean isValidPlacement(Location location) {
        Block block = location.getBlock();
        if (!block.getType().isAir() || this.chestsByLocation.containsKey(location)) {
            return false;
        }
        Block below = block.getRelative(BlockFace.DOWN);
        return below.getType().isSolid() && !below.isLiquid();
    }

    public Inventory createInventory(InventoryHolder holder) {
        if (BUKKIT_CREATE_INVENTORY_COMPONENT != null && this.settings.getInventoryTitle() != null) {
            try {
                return (Inventory)BUKKIT_CREATE_INVENTORY_COMPONENT.invoke(null, holder, 54, this.settings.getInventoryTitle());
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        if (BUKKIT_CREATE_INVENTORY_STRING != null && this.settings.getLegacyInventoryTitle() != null) {
            try {
                return (Inventory)BUKKIT_CREATE_INVENTORY_STRING.invoke(null, holder, 54, this.settings.getLegacyInventoryTitle());
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        return Bukkit.createInventory((InventoryHolder)holder, (int)54);
    }

    static {
        Method component = null;
        Method string = null;
        try {
            component = Bukkit.class.getMethod("createInventory", InventoryHolder.class, Integer.TYPE, Component.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            string = Bukkit.class.getMethod("createInventory", InventoryHolder.class, Integer.TYPE, String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        BUKKIT_CREATE_INVENTORY_COMPONENT = component;
        BUKKIT_CREATE_INVENTORY_STRING = string;
    }
}

