/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezclean;

import com.skyblockexp.ezclean.DeathChestInventoryHolder;
import com.skyblockexp.ezclean.DeathChestManager;
import com.skyblockexp.ezclean.RemovalReason;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

class DeathChest {
    private ArmorStand hologramStand;
    private BukkitTask particleTask;
    private final Location location;
    private final List<ItemStack> drops;
    private final Duration despawnAfter;
    private Inventory inventory;
    private DeathChestInventoryHolder holder;
    private BukkitTask despawnTask;
    private final UUID owner;
    private final long protectionEndMillis;
    private final DeathChestManager manager;

    DeathChest(DeathChestManager manager, Location location, List<ItemStack> drops, Duration despawnAfter) {
        this.manager = manager;
        this.location = location;
        this.drops = drops;
        this.despawnAfter = despawnAfter;
        this.owner = null;
        this.protectionEndMillis = 0L;
    }

    DeathChest(DeathChestManager manager, Location location, List<ItemStack> drops, Duration despawnAfter, UUID owner, long protectionEndMillis) {
        this.manager = manager;
        this.location = location;
        this.drops = drops;
        this.despawnAfter = despawnAfter;
        this.owner = owner;
        this.protectionEndMillis = protectionEndMillis;
    }

    Location getLocation() {
        return this.location;
    }

    void place() {
        this.holder = new DeathChestInventoryHolder(this);
        this.inventory = this.manager.createInventory(this.holder);
        this.holder.setInventory(this.inventory);
        for (ItemStack item : this.drops) {
            HashMap overflow;
            if (item == null || (overflow = this.inventory.addItem(new ItemStack[]{item})).isEmpty() || this.location.getWorld() == null) continue;
            Location dropLocation = this.location.clone().add(0.5, 0.5, 0.5);
            for (ItemStack leftover : overflow.values()) {
                if (leftover == null || leftover.getType().isAir()) continue;
                this.location.getWorld().dropItemNaturally(dropLocation, leftover);
            }
        }
        this.scheduleDespawn();
        if (this.manager.getSettings().isHologramEnabled() && this.location.getWorld() != null) {
            this.hologramStand = (ArmorStand)this.location.getWorld().spawn(this.location.clone().add(0.5, 1.2, 0.5), ArmorStand.class, stand -> {
                stand.setVisible(false);
                stand.setMarker(true);
                stand.setCustomNameVisible(true);
                try {
                    Class<?> bcsClass = Class.forName("net.kyori.adventure.platform.bukkit.BukkitComponentSerializer");
                    Object legacy = bcsClass.getMethod("legacy", new Class[0]).invoke(null, new Object[0]);
                    Object component = legacy.getClass().getMethod("deserialize", String.class).invoke(legacy, this.manager.getSettings().getHologramText());
                    String name = component != null ? component.toString() : this.manager.getSettings().getHologramText();
                    stand.setCustomName(name);
                }
                catch (Exception e) {
                    stand.setCustomName(this.manager.getSettings().getHologramText());
                }
                stand.setGravity(false);
                stand.setSmall(true);
                stand.setInvulnerable(true);
                stand.setPersistent(false);
            });
        }
        if (this.manager.getSettings().isParticlesEnabled() && this.location.getWorld() != null) {
            Particle particle = Particle.valueOf((String)this.manager.getSettings().getParticleType());
            this.particleTask = this.manager.getPlugin().getServer().getScheduler().runTaskTimer((Plugin)this.manager.getPlugin(), () -> this.location.getWorld().spawnParticle(particle, this.location.clone().add(0.5, 1.1, 0.5), 6, 0.2, 0.1, 0.2, 0.01), 0L, 20L);
        }
    }

    void open(Player player) {
        if (this.inventory == null) {
            return;
        }
        if (this.manager.getSettings().isLootProtectionEnabled() && this.owner != null && this.protectionEndMillis > 0L) {
            long now = System.currentTimeMillis();
            boolean isOwner = player.getUniqueId().equals(this.owner);
            boolean bypass = player.hasPermission("ezclean.deathchest.protection.bypass");
            if (!isOwner && !bypass && now < this.protectionEndMillis) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "This chest is protected. Only the owner can open it for " + this.manager.getSettings().getLootProtectionMinutes() + " minutes after death.");
                return;
            }
        }
        player.openInventory(this.inventory);
    }

    void scheduleDespawn() {
        if (this.despawnAfter == null || this.despawnAfter.isZero() || this.despawnAfter.isNegative()) {
            return;
        }
        long ticks = this.despawnAfter.toMillis() / 50L;
        if (ticks <= 0L) {
            return;
        }
        this.despawnTask = this.manager.getPlugin().getServer().getScheduler().runTaskLater((Plugin)this.manager.getPlugin(), () -> {
            if (this.inventory == null) {
                return;
            }
            this.manager.removeChest(this, RemovalReason.DESPAWN);
        }, ticks);
    }

    void destroy(RemovalReason reason) {
        Block block;
        if (this.despawnTask != null) {
            this.despawnTask.cancel();
            this.despawnTask = null;
        }
        if ((block = this.location.getBlock()).getType() == Material.CHEST) {
            block.setType(Material.AIR);
        }
        boolean isOffline = false;
        if (this.owner != null) {
            OfflinePlayer offline = this.manager.getPlugin().getServer().getOfflinePlayer(this.owner);
            boolean bl = isOffline = !offline.isOnline();
        }
        if (this.inventory != null) {
            ArrayList viewers = new ArrayList(this.inventory.getViewers());
            for (HumanEntity viewer : viewers) {
                viewer.closeInventory();
            }
            if (reason == RemovalReason.DESPAWN || reason == RemovalReason.BROKEN || reason == RemovalReason.DISABLED || reason == RemovalReason.PLUGIN_DISABLE) {
                if (isOffline) {
                    String mode = this.manager.getSettings().getOfflineOwnerHandling();
                    if ("drop".equalsIgnoreCase(mode)) {
                        this.dropContents();
                    } else if ("keep".equalsIgnoreCase(mode)) {
                        return;
                    }
                } else {
                    this.dropContents();
                }
            }
            this.inventory.clear();
        }
        this.inventory = null;
        this.holder = null;
        if (this.hologramStand != null && !this.hologramStand.isDead()) {
            this.hologramStand.remove();
            this.hologramStand = null;
        }
        if (this.particleTask != null) {
            this.particleTask.cancel();
            this.particleTask = null;
        }
    }

    void dropContents() {
        if (this.inventory == null || this.location.getWorld() == null) {
            return;
        }
        Location dropLocation = this.location.clone().add(0.5, 0.5, 0.5);
        for (ItemStack item : this.inventory.getContents()) {
            if (item == null || item.getType().isAir()) continue;
            this.location.getWorld().dropItemNaturally(dropLocation, item);
        }
    }

    DeathChestInventoryHolder getHolder() {
        return this.holder;
    }
}

