/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezclean;

import com.skyblockexp.ezclean.CleanupCancelSettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.Nullable;

public final class CleanupSettings {
    private static final long TICKS_PER_MINUTE = 1200L;
    private static final String DEFAULT_WARNING_MESSAGE = "<yellow>\u26a0 Entity cleanup in <gold>{minutes}</gold> minutes. Clear valuables!</yellow>";
    private static final String DEFAULT_START_MESSAGE = "<red><bold>\u2726 Entity cleanup commencing...</bold></red>";
    private static final String DEFAULT_SUMMARY_MESSAGE = "<gray>\u2713 Removed <gold>{count}</gold> entities. Next cleanup in <gold>{minutes}</gold> minutes.</gray>";
    private static final String DEFAULT_INTERVAL_MESSAGE = "<yellow>\u26a0 Entity cleanup in <gold>{minutes}</gold> minutes. Clear valuables!</yellow>";
    private static final String DEFAULT_DYNAMIC_MESSAGE = "<yellow>\u26a0 Entity cleanup in <gold>{minutes}</gold> minutes. Clear valuables!</yellow>";
    private static final String DEFAULT_CANCEL_HOVER_MESSAGE = "<yellow>Click to pay <gold>{cost}</gold> to cancel this cleanup.</yellow>";
    private static final String DEFAULT_CANCEL_SUCCESS_MESSAGE = "<green>You paid <gold>{cost}</gold> to cancel the <aqua>{cleaner}</aqua> cleanup.</green>";
    private static final String DEFAULT_CANCEL_BROADCAST_MESSAGE = "<gold>{player}</gold> canceled the <aqua>{cleaner}</aqua> cleanup. Next cleanup in <yellow>{minutes}</yellow> minutes.";
    private static final String DEFAULT_CANCEL_INSUFFICIENT_FUNDS_MESSAGE = "<red>You need <gold>{cost}</gold> to cancel the cleanup.</red>";
    private static final String DEFAULT_CANCEL_DISABLED_MESSAGE = "<red>This cleanup cannot be canceled.</red>";
    private static final String DEFAULT_CANCEL_NO_ECONOMY_MESSAGE = "<red>Economy is unavailable. Cleanup cannot be canceled.</red>";
    private final String cleanerId;
    private final long cleanupIntervalTicks;
    private final long warningOffsetTicks;
    private final boolean warningEnabled;
    private final boolean startBroadcastEnabled;
    private final boolean summaryBroadcastEnabled;
    private final boolean intervalBroadcastEnabled;
    private final long intervalBroadcastMinutes;
    private final String intervalBroadcastMessageTemplate;
    private final boolean dynamicBroadcastEnabled;
    private final Set<Long> dynamicBroadcastMinutes;
    private final String dynamicBroadcastMessageTemplate;
    private final String warningMessageTemplate;
    private final String startMessageTemplate;
    private final String summaryMessageTemplate;
    private final long warningMinutesBefore;
    private final long cleanupIntervalMinutes;
    private final boolean removeHostileMobs;
    private final boolean removePassiveMobs;
    private final boolean removeVillagers;
    private final boolean removeVehicles;
    private final boolean removeDroppedItems;
    private final boolean removeProjectiles;
    private final boolean removeExperienceOrbs;
    private final boolean removeAreaEffectClouds;
    private final boolean removeFallingBlocks;
    private final boolean removePrimedTnt;
    private final boolean protectPlayers;
    private final boolean protectArmorStands;
    private final boolean protectDisplayEntities;
    private final boolean protectTamedMobs;
    private final boolean protectNameTaggedMobs;
    private final Set<String> enabledWorlds;
    private final Set<EntityType> forcedKeeps;
    private final Set<EntityType> forcedRemovals;
    @Nullable
    private final PileDetectionSettings pileDetectionSettings;
    private final CleanupCancelSettings cancelSettings;
    private static final Pattern MINIMESSAGE_PLACEHOLDER_PATTERN = Pattern.compile("\\{([a-zA-Z0-9_-]+)\\}");

    private CleanupSettings(String cleanerId, long cleanupIntervalTicks, long warningOffsetTicks, boolean warningEnabled, boolean startBroadcastEnabled, boolean summaryBroadcastEnabled, boolean intervalBroadcastEnabled, long intervalBroadcastMinutes, String intervalBroadcastMessageTemplate, boolean dynamicBroadcastEnabled, Set<Long> dynamicBroadcastMinutes, String dynamicBroadcastMessageTemplate, String warningMessageTemplate, String startMessageTemplate, String summaryMessageTemplate, long warningMinutesBefore, long cleanupIntervalMinutes, boolean removeHostileMobs, boolean removePassiveMobs, boolean removeVillagers, boolean removeVehicles, boolean removeDroppedItems, boolean removeProjectiles, boolean removeExperienceOrbs, boolean removeAreaEffectClouds, boolean removeFallingBlocks, boolean removePrimedTnt, boolean protectPlayers, boolean protectArmorStands, boolean protectDisplayEntities, boolean protectTamedMobs, boolean protectNameTaggedMobs, Set<String> enabledWorlds, Set<EntityType> forcedKeeps, Set<EntityType> forcedRemovals, @Nullable PileDetectionSettings pileDetectionSettings, CleanupCancelSettings cancelSettings) {
        this.cleanerId = cleanerId;
        this.cleanupIntervalTicks = cleanupIntervalTicks;
        this.warningOffsetTicks = warningOffsetTicks;
        this.warningEnabled = warningEnabled;
        this.startBroadcastEnabled = startBroadcastEnabled;
        this.summaryBroadcastEnabled = summaryBroadcastEnabled;
        this.intervalBroadcastEnabled = intervalBroadcastEnabled;
        this.intervalBroadcastMinutes = intervalBroadcastMinutes;
        this.intervalBroadcastMessageTemplate = intervalBroadcastMessageTemplate;
        this.dynamicBroadcastEnabled = dynamicBroadcastEnabled;
        this.dynamicBroadcastMinutes = Collections.unmodifiableSet(new LinkedHashSet<Long>(dynamicBroadcastMinutes));
        this.dynamicBroadcastMessageTemplate = dynamicBroadcastMessageTemplate;
        this.warningMessageTemplate = warningMessageTemplate;
        this.startMessageTemplate = startMessageTemplate;
        this.summaryMessageTemplate = summaryMessageTemplate;
        this.warningMinutesBefore = warningMinutesBefore;
        this.cleanupIntervalMinutes = cleanupIntervalMinutes;
        this.removeHostileMobs = removeHostileMobs;
        this.removePassiveMobs = removePassiveMobs;
        this.removeVillagers = removeVillagers;
        this.removeVehicles = removeVehicles;
        this.removeDroppedItems = removeDroppedItems;
        this.removeProjectiles = removeProjectiles;
        this.removeExperienceOrbs = removeExperienceOrbs;
        this.removeAreaEffectClouds = removeAreaEffectClouds;
        this.removeFallingBlocks = removeFallingBlocks;
        this.removePrimedTnt = removePrimedTnt;
        this.protectPlayers = protectPlayers;
        this.protectArmorStands = protectArmorStands;
        this.protectDisplayEntities = protectDisplayEntities;
        this.protectTamedMobs = protectTamedMobs;
        this.protectNameTaggedMobs = protectNameTaggedMobs;
        this.enabledWorlds = Collections.unmodifiableSet(new HashSet<String>(enabledWorlds));
        this.forcedKeeps = Collections.unmodifiableSet(new HashSet<EntityType>(forcedKeeps));
        this.forcedRemovals = Collections.unmodifiableSet(new HashSet<EntityType>(forcedRemovals));
        this.pileDetectionSettings = pileDetectionSettings;
        this.cancelSettings = cancelSettings;
    }

    public static List<CleanupSettings> fromConfiguration(FileConfiguration config, Logger logger) {
        ConfigurationSection cleanersSection = config.getConfigurationSection("cleaners");
        if (cleanersSection == null || cleanersSection.getKeys(false).isEmpty()) {
            MessageConfiguration messages = MessageConfiguration.from(config.getConfigurationSection("messages"));
            return Collections.singletonList(CleanupSettings.loadLegacySettings(config, logger, messages));
        }
        MessageConfiguration messages = MessageConfiguration.from(config.getConfigurationSection("messages"));
        ArrayList<CleanupSettings> results = new ArrayList<CleanupSettings>();
        for (String cleanerId : cleanersSection.getKeys(false)) {
            ConfigurationSection cleanerSection = cleanersSection.getConfigurationSection(cleanerId);
            if (cleanerSection == null) continue;
            results.add(CleanupSettings.loadFromSection(cleanerId, cleanerSection, logger, messages));
        }
        if (results.isEmpty()) {
            results.add(CleanupSettings.loadLegacySettings(config, logger, messages));
        }
        return Collections.unmodifiableList(results);
    }

    private static CleanupSettings loadLegacySettings(FileConfiguration config, Logger logger, MessageConfiguration messages) {
        ConfigurationSection cleanupSection = config.getConfigurationSection("cleanup");
        if (cleanupSection == null) {
            cleanupSection = new MemoryConfiguration();
        }
        return CleanupSettings.loadFromSection("default", cleanupSection, logger, messages);
    }

    private static CleanupSettings loadFromSection(String cleanerId, ConfigurationSection section, Logger logger, MessageConfiguration messages) {
        long intervalMinutes = Math.max(1L, section.getLong("interval-minutes", 60L));
        long warningMinutes = Math.max(0L, section.getLong("warning.minutes-before", 5L));
        boolean warningEnabled = section.getBoolean("warning.enabled", warningMinutes > 0L);
        boolean startEnabled = section.getBoolean("broadcast.start.enabled", true);
        boolean summaryEnabled = section.getBoolean("broadcast.summary.enabled", true);
        ConfigurationSection intervalSection = section.getConfigurationSection("broadcast.interval");
        boolean intervalEnabled = false;
        long intervalMinutesBetweenBroadcasts = 0L;
        if (intervalSection != null) {
            intervalEnabled = intervalSection.getBoolean("enabled", false);
            intervalMinutesBetweenBroadcasts = Math.max(1L, intervalSection.getLong("every-minutes", 15L));
            if (intervalMinutesBetweenBroadcasts <= 0L) {
                intervalEnabled = false;
            }
        }
        String intervalMessage = CleanupSettings.resolveMessage(cleanerId, section, messages, "broadcast.interval.message", "<yellow>\u26a0 Entity cleanup in <gold>{minutes}</gold> minutes. Clear valuables!</yellow>");
        ConfigurationSection dynamicSection = section.getConfigurationSection("broadcast.dynamic");
        boolean dynamicEnabled = false;
        Set<Long> dynamicMinutes = Collections.emptySet();
        if (dynamicSection != null) {
            dynamicEnabled = dynamicSection.getBoolean("enabled", false);
            List configuredMinutes = dynamicSection.getIntegerList("minutes");
            LinkedHashSet<Long> parsedMinutes = new LinkedHashSet<Long>();
            for (Integer value : configuredMinutes) {
                long minute;
                if (value == null || (minute = value.longValue()) < 0L) continue;
                parsedMinutes.add(minute);
            }
            if (!parsedMinutes.isEmpty()) {
                dynamicMinutes = Collections.unmodifiableSet(parsedMinutes);
            } else {
                dynamicEnabled = false;
            }
        }
        String dynamicMessage = CleanupSettings.resolveMessage(cleanerId, section, messages, "broadcast.dynamic.message", "<yellow>\u26a0 Entity cleanup in <gold>{minutes}</gold> minutes. Clear valuables!</yellow>");
        String warningMessage = CleanupSettings.resolveMessage(cleanerId, section, messages, "warning.message", "<yellow>\u26a0 Entity cleanup in <gold>{minutes}</gold> minutes. Clear valuables!</yellow>");
        String startMessage = CleanupSettings.resolveMessage(cleanerId, section, messages, "broadcast.start.message", DEFAULT_START_MESSAGE);
        String summaryMessage = CleanupSettings.resolveMessage(cleanerId, section, messages, "broadcast.summary.message", DEFAULT_SUMMARY_MESSAGE);
        boolean removeHostileMobs = section.getBoolean("remove.hostile-mobs", true);
        boolean removePassiveMobs = section.getBoolean("remove.passive-mobs", false);
        boolean removeVillagers = section.getBoolean("remove.villagers", false);
        boolean removeVehicles = section.getBoolean("remove.vehicles", false);
        boolean removeDroppedItems = section.getBoolean("remove.dropped-items", true);
        boolean removeProjectiles = section.getBoolean("remove.projectiles", true);
        boolean removeExperienceOrbs = section.getBoolean("remove.experience-orbs", true);
        boolean removeAreaEffectClouds = section.getBoolean("remove.area-effect-clouds", true);
        boolean removeFallingBlocks = section.getBoolean("remove.falling-blocks", true);
        boolean removePrimedTnt = section.getBoolean("remove.primed-tnt", true);
        boolean protectPlayers = section.getBoolean("protect.players", true);
        boolean protectArmorStands = section.getBoolean("protect.armor-stands", true);
        boolean protectDisplayEntities = section.getBoolean("protect.display-entities", true);
        boolean protectTamedMobs = section.getBoolean("protect.tamed-mobs", true);
        boolean protectNameTaggedMobs = section.getBoolean("protect.name-tagged-mobs", true);
        Set<String> worlds = CleanupSettings.parseWorlds(section.getStringList("worlds"));
        String sectionPath = section.getCurrentPath();
        if (sectionPath == null || sectionPath.isBlank()) {
            sectionPath = "cleanup";
        }
        Set<EntityType> keep = CleanupSettings.parseEntityTypes(section.getStringList("entity-types.keep"), logger, sectionPath + ".entity-types.keep");
        Set<EntityType> remove = CleanupSettings.parseEntityTypes(section.getStringList("entity-types.remove"), logger, sectionPath + ".entity-types.remove");
        PileDetectionSettings pileDetectionSettings = CleanupSettings.loadPileDetectionSettings(section, logger, sectionPath);
        CleanupCancelSettings cancelSettings = CleanupCancelSettings.disabled();
        ConfigurationSection cancelSection = section.getConfigurationSection("cancel");
        if (cancelSection != null) {
            boolean cancelEnabled = cancelSection.getBoolean("enabled", true);
            double cancelCost = cancelSection.getDouble("cost", 0.0);
            String hoverMessage = CleanupSettings.resolveMessage(cleanerId, section, messages, "cancel.hover-message", DEFAULT_CANCEL_HOVER_MESSAGE);
            String successMessage = CleanupSettings.resolveMessage(cleanerId, section, messages, "cancel.success-message", DEFAULT_CANCEL_SUCCESS_MESSAGE);
            String broadcastMessage = CleanupSettings.resolveMessage(cleanerId, section, messages, "cancel.broadcast-message", DEFAULT_CANCEL_BROADCAST_MESSAGE);
            String insufficientFundsMessage = CleanupSettings.resolveMessage(cleanerId, section, messages, "cancel.insufficient-funds-message", DEFAULT_CANCEL_INSUFFICIENT_FUNDS_MESSAGE);
            String disabledMessage = CleanupSettings.resolveMessage(cleanerId, section, messages, "cancel.disabled-message", DEFAULT_CANCEL_DISABLED_MESSAGE);
            String noEconomyMessage = CleanupSettings.resolveMessage(cleanerId, section, messages, "cancel.no-economy-message", DEFAULT_CANCEL_NO_ECONOMY_MESSAGE);
            cancelSettings = CleanupCancelSettings.create(cancelEnabled, cancelCost, hoverMessage, successMessage, broadcastMessage, insufficientFundsMessage, disabledMessage, noEconomyMessage);
        }
        long cleanupIntervalTicks = intervalMinutes * 1200L;
        long warningOffsetTicks = warningMinutes * 1200L;
        return new CleanupSettings(cleanerId, cleanupIntervalTicks, warningOffsetTicks, warningEnabled, startEnabled, summaryEnabled, intervalEnabled, intervalMinutesBetweenBroadcasts, intervalMessage, dynamicEnabled, dynamicMinutes, dynamicMessage, warningMessage, startMessage, summaryMessage, warningMinutes, intervalMinutes, removeHostileMobs, removePassiveMobs, removeVillagers, removeVehicles, removeDroppedItems, removeProjectiles, removeExperienceOrbs, removeAreaEffectClouds, removeFallingBlocks, removePrimedTnt, protectPlayers, protectArmorStands, protectDisplayEntities, protectTamedMobs, protectNameTaggedMobs, worlds, keep, remove, pileDetectionSettings, cancelSettings);
    }

    private static String resolveMessage(String cleanerId, ConfigurationSection section, MessageConfiguration messages, String path, String defaultValue) {
        String value = section.getString(path);
        if (value == null || value.isEmpty()) {
            value = messages.getMessage(cleanerId, path);
        }
        if (value == null || value.isEmpty()) {
            value = defaultValue;
        }
        return CleanupSettings.normalizeMiniMessagePlaceholders(value);
    }

    @Nullable
    private static PileDetectionSettings loadPileDetectionSettings(ConfigurationSection section, Logger logger, String sectionPath) {
        ConfigurationSection pileSection = section.getConfigurationSection("pile-detection");
        if (pileSection == null) {
            return null;
        }
        boolean enabled = pileSection.getBoolean("enabled", false);
        if (!enabled) {
            return null;
        }
        int threshold = pileSection.getInt("max-per-block", 200);
        if (threshold <= 0) {
            if (logger != null) {
                logger.warning(() -> String.format("Ignoring pile-detection for '%s': max-per-block must be greater than zero.", sectionPath));
            }
            return null;
        }
        boolean ignoreNamed = pileSection.getBoolean("ignore-named-entities", true);
        HashSet<EntityType> trackedTypes = new HashSet<EntityType>(CleanupSettings.parseEntityTypes(pileSection.getStringList("entity-types"), logger, sectionPath + ".pile-detection.entity-types"));
        if (trackedTypes.isEmpty()) {
            trackedTypes.add(EntityType.DROPPED_ITEM);
            trackedTypes.add(EntityType.EXPERIENCE_ORB);
        }
        return new PileDetectionSettings(threshold, Collections.unmodifiableSet(trackedTypes), ignoreNamed);
    }

    private static String normalizeMiniMessagePlaceholders(String template) {
        if (template == null || template.isEmpty()) {
            return template;
        }
        Matcher matcher = MINIMESSAGE_PLACEHOLDER_PATTERN.matcher(template);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String replacement = "<" + matcher.group(1) + ">";
            matcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private static Set<String> parseWorlds(List<String> rawWorlds) {
        if (rawWorlds == null || rawWorlds.isEmpty()) {
            return Collections.singleton("*");
        }
        HashSet<String> results = new HashSet<String>();
        for (String world : rawWorlds) {
            if (world == null || world.isBlank()) continue;
            results.add(world.toLowerCase(Locale.ROOT));
        }
        if (results.isEmpty()) {
            return Collections.singleton("*");
        }
        return Collections.unmodifiableSet(results);
    }

    private static Set<EntityType> parseEntityTypes(List<String> entries, Logger logger, String path) {
        if (entries == null || entries.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<EntityType> result = new HashSet<EntityType>();
        for (String raw : entries) {
            if (raw == null || raw.isBlank()) continue;
            try {
                EntityType type = EntityType.valueOf((String)raw.trim().toUpperCase(Locale.ROOT));
                result.add(type);
            }
            catch (IllegalArgumentException ex) {
                if (logger == null) continue;
                logger.warning("Unknown entity type configured at '" + path + "': " + raw);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    public String getCleanerId() {
        return this.cleanerId;
    }

    public long getCleanupIntervalTicks() {
        return this.cleanupIntervalTicks;
    }

    public long getWarningOffsetTicks() {
        return this.warningOffsetTicks;
    }

    public boolean isWarningEnabled() {
        return this.warningEnabled;
    }

    public boolean isStartBroadcastEnabled() {
        return this.startBroadcastEnabled;
    }

    public boolean isSummaryBroadcastEnabled() {
        return this.summaryBroadcastEnabled;
    }

    public boolean isIntervalBroadcastEnabled() {
        return this.intervalBroadcastEnabled;
    }

    public long getIntervalBroadcastMinutes() {
        return this.intervalBroadcastMinutes;
    }

    public String getIntervalBroadcastMessageTemplate() {
        return this.intervalBroadcastMessageTemplate;
    }

    public boolean isDynamicBroadcastEnabled() {
        return this.dynamicBroadcastEnabled;
    }

    public Set<Long> getDynamicBroadcastMinutes() {
        return this.dynamicBroadcastMinutes;
    }

    public String getDynamicBroadcastMessageTemplate() {
        return this.dynamicBroadcastMessageTemplate;
    }

    public String getWarningMessageTemplate() {
        return this.warningMessageTemplate;
    }

    public String getStartMessageTemplate() {
        return this.startMessageTemplate;
    }

    public String getSummaryMessageTemplate() {
        return this.summaryMessageTemplate;
    }

    public long getWarningMinutesBefore() {
        return this.warningMinutesBefore;
    }

    public long getCleanupIntervalMinutes() {
        return this.cleanupIntervalMinutes;
    }

    public boolean removeHostileMobs() {
        return this.removeHostileMobs;
    }

    public boolean removePassiveMobs() {
        return this.removePassiveMobs;
    }

    public boolean removeVillagers() {
        return this.removeVillagers;
    }

    public boolean removeVehicles() {
        return this.removeVehicles;
    }

    public boolean removeDroppedItems() {
        return this.removeDroppedItems;
    }

    public boolean removeProjectiles() {
        return this.removeProjectiles;
    }

    public boolean removeExperienceOrbs() {
        return this.removeExperienceOrbs;
    }

    public boolean removeAreaEffectClouds() {
        return this.removeAreaEffectClouds;
    }

    public boolean removeFallingBlocks() {
        return this.removeFallingBlocks;
    }

    public boolean removePrimedTnt() {
        return this.removePrimedTnt;
    }

    public boolean protectPlayers() {
        return this.protectPlayers;
    }

    public boolean protectArmorStands() {
        return this.protectArmorStands;
    }

    public boolean protectDisplayEntities() {
        return this.protectDisplayEntities;
    }

    public boolean protectTamedMobs() {
        return this.protectTamedMobs;
    }

    public boolean protectNameTaggedMobs() {
        return this.protectNameTaggedMobs;
    }

    public boolean isWorldEnabled(String worldName) {
        if (this.enabledWorlds.contains("*")) {
            return true;
        }
        return this.enabledWorlds.contains(worldName.toLowerCase(Locale.ROOT));
    }

    public Set<String> getEnabledWorlds() {
        return this.enabledWorlds;
    }

    public boolean isForcedKeep(EntityType type) {
        return this.forcedKeeps.contains(type);
    }

    public boolean isForcedRemoval(EntityType type) {
        return this.forcedRemovals.contains(type);
    }

    public boolean isPileDetectionEnabled() {
        return this.pileDetectionSettings != null;
    }

    @Nullable
    public PileDetectionSettings getPileDetectionSettings() {
        return this.pileDetectionSettings;
    }

    public CleanupCancelSettings getCancelSettings() {
        return this.cancelSettings;
    }

    public static final class PileDetectionSettings {
        private final int maxPerBlock;
        private final Set<EntityType> trackedTypes;
        private final boolean ignoreNamedEntities;

        private PileDetectionSettings(int maxPerBlock, Set<EntityType> trackedTypes, boolean ignoreNamedEntities) {
            this.maxPerBlock = maxPerBlock;
            this.trackedTypes = trackedTypes;
            this.ignoreNamedEntities = ignoreNamedEntities;
        }

        public int getMaxPerBlock() {
            return this.maxPerBlock;
        }

        public Set<EntityType> getTrackedTypes() {
            return this.trackedTypes;
        }

        public boolean ignoreNamedEntities() {
            return this.ignoreNamedEntities;
        }

        public boolean isTracking(EntityType type) {
            return this.trackedTypes.contains(type);
        }
    }

    private static final class MessageConfiguration {
        private final ConfigurationSection defaultsSection;
        private final ConfigurationSection cleanersSection;

        private MessageConfiguration(ConfigurationSection defaultsSection, ConfigurationSection cleanersSection) {
            this.defaultsSection = defaultsSection;
            this.cleanersSection = cleanersSection;
        }

        static MessageConfiguration from(@Nullable ConfigurationSection messagesSection) {
            if (messagesSection == null) {
                return new MessageConfiguration(null, null);
            }
            ConfigurationSection defaults = messagesSection.getConfigurationSection("defaults");
            ConfigurationSection cleaners = messagesSection.getConfigurationSection("cleaners");
            return new MessageConfiguration(defaults, cleaners);
        }

        String getMessage(String cleanerId, String path) {
            ConfigurationSection cleaner;
            String value = null;
            if (this.cleanersSection != null && (cleaner = this.cleanersSection.getConfigurationSection(cleanerId)) != null) {
                value = cleaner.getString(path);
            }
            if ((value == null || value.isEmpty()) && this.defaultsSection != null) {
                value = this.defaultsSection.getString(path);
            }
            return value;
        }
    }
}

