/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezclean;

import java.util.Locale;

public final class CleanupCancelSettings {
    private final boolean enabled;
    private final double cost;
    private final String hoverMessage;
    private final String successMessage;
    private final String broadcastMessage;
    private final String insufficientFundsMessage;
    private final String disabledMessage;
    private final String noEconomyMessage;

    private CleanupCancelSettings(boolean enabled, double cost, String hoverMessage, String successMessage, String broadcastMessage, String insufficientFundsMessage, String disabledMessage, String noEconomyMessage) {
        this.enabled = enabled;
        this.cost = cost;
        this.hoverMessage = hoverMessage;
        this.successMessage = successMessage;
        this.broadcastMessage = broadcastMessage;
        this.insufficientFundsMessage = insufficientFundsMessage;
        this.disabledMessage = disabledMessage;
        this.noEconomyMessage = noEconomyMessage;
    }

    public static CleanupCancelSettings disabled() {
        return new CleanupCancelSettings(false, 0.0, "", "", "", "", "", "");
    }

    public static CleanupCancelSettings create(boolean enabled, double cost, String hoverMessage, String successMessage, String broadcastMessage, String insufficientFundsMessage, String disabledMessage, String noEconomyMessage) {
        if (!enabled) {
            return CleanupCancelSettings.disabled();
        }
        return new CleanupCancelSettings(true, Math.max(0.0, cost), hoverMessage, successMessage, broadcastMessage, insufficientFundsMessage, disabledMessage, noEconomyMessage);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public double getCost() {
        return this.cost;
    }

    public String getHoverMessage() {
        return this.hoverMessage;
    }

    public String getSuccessMessage() {
        return this.successMessage;
    }

    public String getBroadcastMessage() {
        return this.broadcastMessage;
    }

    public String getInsufficientFundsMessage() {
        return this.insufficientFundsMessage;
    }

    public String getDisabledMessage() {
        return this.disabledMessage;
    }

    public String getNoEconomyMessage() {
        return this.noEconomyMessage;
    }

    public String getFormattedCost() {
        if (Math.abs(this.cost - Math.rint(this.cost)) < 0.005) {
            return String.format(Locale.US, "%,.0f", this.cost);
        }
        return String.format(Locale.US, "%,.2f", this.cost);
    }
}

