/*
 * Decompiled with CFR 0.152.
 */
package net.statusmc.utils;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.SecureRandom;
import net.statusmc.events.SocketOnGetMSPTEvent;
import net.statusmc.events.SocketOnGetTPSEvent;
import net.statusmc.main.StatusMC;
import net.statusmc.utils.ServerConfig;
import net.statusmc.utils.Utils;

public class SocketServer
extends Thread {
    StatusMC plugin;
    private boolean connect_status;
    public static int port = ServerConfig.port;
    public static ServerSocket listenSock = null;
    public static DataInputStream in = null;
    public static DataOutputStream out = null;
    public static Socket sock = null;

    public SocketServer(StatusMC plugin) {
        this.plugin = plugin;
    }

    public SocketServer() {
        this.connect_status = false;
    }

    @Override
    public void run() {
        try {
            listenSock = new ServerSocket(port);
            block4: while (true) {
                sock = listenSock.accept();
                in = new DataInputStream(sock.getInputStream());
                out = new DataOutputStream(sock.getOutputStream());
                this.connect_status = true;
                InetAddress addr = sock.getInetAddress();
                try {
                    if (in.readByte() == 1) {
                        int random_code = new SecureRandom().nextInt();
                        int random_code_processed = Math.abs(random_code);
                        if (ServerConfig.developer_mode.equals(true)) {
                            Utils.log(System.Logger.Level.INFO, "Random code: " + random_code_processed);
                        }
                        out.writeInt(random_code_processed);
                        boolean success = Utils.readString(in, false).equals(Utils.hash(String.valueOf(random_code_processed) + ServerConfig.secretKey));
                        if (success) {
                            out.writeInt(1);
                            out.flush();
                            if (ServerConfig.disable_successful_connection_message.equals(false)) {
                                Utils.log(System.Logger.Level.INFO, Utils.format(ServerConfig.successfulLogin));
                            }
                        } else {
                            out.writeInt(0);
                            out.flush();
                            Utils.log(System.Logger.Level.ERROR, Utils.format(ServerConfig.wrongSecretKey));
                            this.connect_status = false;
                        }
                    } else {
                        out.writeInt(0);
                        out.flush();
                        Utils.log(System.Logger.Level.ERROR, Utils.format(ServerConfig.unexpectederror));
                        this.connect_status = false;
                    }
                    while (true) {
                        if (!this.connect_status) continue block4;
                        byte packetNumber = in.readByte();
                        if (packetNumber == 2) {
                            double tps = (double)Math.round(SocketOnGetTPSEvent.getTPS() * 100.0) / 100.0;
                            out.writeDouble(tps);
                            if (ServerConfig.log_performance_metrics.equals(true) && ServerConfig.log_only_low_tps.equals(true) && tps <= ServerConfig.low_tps_threshold) {
                                Utils.log(System.Logger.Level.INFO, "The current TPS is " + tps + ".");
                                continue;
                            }
                            if (!ServerConfig.log_performance_metrics.equals(true) || !ServerConfig.log_only_low_tps.equals(false)) continue;
                            Utils.log(System.Logger.Level.INFO, "The current TPS is " + tps + ".");
                            continue;
                        }
                        if (packetNumber == 4) {
                            double minMSPTValue = SocketOnGetMSPTEvent.getMinMSPT();
                            out.writeDouble(minMSPTValue);
                            if (ServerConfig.log_performance_metrics.equals(true) && ServerConfig.log_only_high_min_mspt.equals(true) && minMSPTValue >= ServerConfig.high_min_mspt_threshold) {
                                Utils.log(System.Logger.Level.INFO, "Min MSPT for the last 1 minute: " + minMSPTValue);
                                continue;
                            }
                            if (!ServerConfig.log_performance_metrics.equals(true) || !ServerConfig.log_only_high_min_mspt.equals(false)) continue;
                            Utils.log(System.Logger.Level.INFO, "Min MSPT for the last 1 minute: " + minMSPTValue);
                            continue;
                        }
                        if (packetNumber == 5) {
                            double avgMSPTValue = SocketOnGetMSPTEvent.getAvgMSPT();
                            out.writeDouble(avgMSPTValue);
                            if (ServerConfig.log_performance_metrics.equals(true) && ServerConfig.log_only_high_avg_mspt.equals(true) && avgMSPTValue >= ServerConfig.high_avg_mspt_threshold) {
                                Utils.log(System.Logger.Level.INFO, "Average MSPT for the last 1 minute: " + avgMSPTValue);
                                continue;
                            }
                            if (!ServerConfig.log_performance_metrics.equals(true) || !ServerConfig.log_only_high_avg_mspt.equals(false)) continue;
                            Utils.log(System.Logger.Level.INFO, "Average MSPT for the last 1 minute: " + avgMSPTValue);
                            continue;
                        }
                        if (packetNumber == 6) {
                            double maxMSPTValue = SocketOnGetMSPTEvent.getMaxMSPT();
                            out.writeDouble(maxMSPTValue);
                            if (ServerConfig.log_performance_metrics.equals(true) && ServerConfig.log_only_high_max_mspt.equals(true) && maxMSPTValue >= ServerConfig.high_max_mspt_threshold) {
                                Utils.log(System.Logger.Level.INFO, "Max MSPT for the last 1 minute: " + maxMSPTValue);
                                continue;
                            }
                            if (!ServerConfig.log_performance_metrics.equals(true) || !ServerConfig.log_only_high_max_mspt.equals(false)) continue;
                            Utils.log(System.Logger.Level.INFO, "Max MSPT for the last 1 minute: " + maxMSPTValue);
                            continue;
                        }
                        if (packetNumber == 3) {
                            if (ServerConfig.developer_mode.equals(true)) {
                                Utils.log(System.Logger.Level.INFO, "Socket packet 3 close");
                            }
                            out.flush();
                            this.closeConnectionGracefully();
                            continue;
                        }
                        Utils.log(System.Logger.Level.INFO, "Packet not found! Packet: " + packetNumber + " Please contact StatusMC Support staff.");
                    }
                }
                catch (IOException ex) {
                    out.writeInt(0);
                    out.flush();
                    this.closeConnectionGracefully();
                    Utils.log(System.Logger.Level.INFO, "IO exception 1: " + ex.getMessage());
                    ex.printStackTrace();
                }
            }
        }
        catch (IOException ex) {
            if (ServerConfig.developer_mode.equals(true)) {
                Utils.log(System.Logger.Level.INFO, "IO exception 2: " + ex.getMessage());
                ex.printStackTrace();
            }
            return;
        }
    }

    private void closeConnectionGracefully() {
        try {
            in.close();
            out.close();
            sock.close();
            this.connect_status = false;
        }
        catch (IOException e) {
            Utils.log(System.Logger.Level.WARNING, "Error while closing socket connection: " + e.getMessage());
        }
    }
}

