/*
 * Decompiled with CFR 0.152.
 */
package net.statusmc.main;

import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.util.List;
import net.statusmc.commands.ReloadCommand;
import net.statusmc.events.ServerTickEndEvent;
import net.statusmc.events.ServerTickStartEvent;
import net.statusmc.events.SocketOnGetMSPTEvent;
import net.statusmc.events.SocketOnGetTPSEvent;
import net.statusmc.utils.APIRequest;
import net.statusmc.utils.ServerConfig;
import net.statusmc.utils.SocketServer;
import net.statusmc.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public class StatusMC
extends JavaPlugin {
    private static final long TICK_LENGTH_NS = 50000000L;
    private int tickNumber;
    private long lastTickStartNs;
    private BukkitTask tickTask;
    FileConfiguration config;
    PluginDescriptionFile pdf = this.getDescription();
    static StatusMC plugin;
    private static SocketOnGetMSPTEvent msptCalculator;

    public StatusMC() {
        this.config = this.getConfig();
    }

    public void onEnable() {
        String pluginVersion;
        this.getCommand("statusmc").setExecutor((CommandExecutor)new ReloadCommand(this));
        this.config.addDefault("port", (Object)ServerConfig.port);
        this.config.addDefault("secret_key", (Object)ServerConfig.secretKey);
        this.config.addDefault("prefix", (Object)ServerConfig.prefix);
        this.config.addDefault("wrongSecretKey", (Object)ServerConfig.wrongSecretKey);
        this.config.addDefault("unexpectederror", (Object)ServerConfig.unexpectederror);
        this.config.addDefault("successfulLogin", (Object)ServerConfig.successfulLogin);
        this.config.addDefault("consoleInfo", (Object)ServerConfig.consoleInfo);
        this.config.addDefault("developer_mode", (Object)ServerConfig.developer_mode);
        this.config.addDefault("disable_successful_connection_message", (Object)ServerConfig.disable_successful_connection_message);
        this.config.addDefault("log_performance_metrics", (Object)ServerConfig.log_performance_metrics);
        this.config.addDefault("log_only_low_tps", (Object)ServerConfig.log_only_low_tps);
        this.config.addDefault("low_tps_threshold", (Object)ServerConfig.low_tps_threshold);
        this.config.addDefault("log_only_high_min_mspt", (Object)ServerConfig.log_only_high_min_mspt);
        this.config.addDefault("high_min_mspt_threshold", (Object)ServerConfig.high_min_mspt_threshold);
        this.config.addDefault("log_only_high_avg_mspt", (Object)ServerConfig.log_only_high_avg_mspt);
        this.config.addDefault("high_avg_mspt_threshold", (Object)ServerConfig.high_avg_mspt_threshold);
        this.config.addDefault("log_only_high_max_mspt", (Object)ServerConfig.log_only_high_max_mspt);
        this.config.addDefault("high_max_mspt_threshold", (Object)ServerConfig.high_max_mspt_threshold);
        this.config.addDefault("successfullyReloaded", (Object)ServerConfig.successfullyReloaded);
        this.config.addDefault("nopermissions", (Object)ServerConfig.nopermissions);
        this.config.addDefault("incorrectUsage", (Object)ServerConfig.incorrectUsage);
        this.config.addDefault("unableMinMSPT", (Object)ServerConfig.unableMinMSPT);
        this.config.addDefault("unableAvgMSPT", (Object)ServerConfig.unableAvgMSPT);
        this.config.addDefault("unableMaxMSPT", (Object)ServerConfig.unableMaxMSPT);
        this.config.options().copyDefaults(true);
        this.saveConfig();
        this.configLoad();
        Utils.log(System.Logger.Level.INFO, "\u00a79StatusMC Monitoring plugin \u00a77has been \u00a7aturned on\u00a77!");
        Utils.log(System.Logger.Level.INFO, "Starting...");
        SocketServer socket = new SocketServer();
        socket.start();
        Utils.log(System.Logger.Level.INFO, "Started!");
        Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)new SocketOnGetTPSEvent(), 100L, 1L);
        this.tickNumber = 0;
        this.lastTickStartNs = System.nanoTime();
        this.tickTask = Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> {
            ++this.tickNumber;
            this.lastTickStartNs = System.nanoTime();
            Bukkit.getPluginManager().callEvent((Event)new ServerTickStartEvent(this.tickNumber));
        }, 0L, 1L);
        try {
            Class<?> mcServerClass = Class.forName("net.minecraft.server.MinecraftServer");
            Field endTickListField = null;
            Field[] fieldArray = mcServerClass.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (List.class.isAssignableFrom(field.getType())) {
                    endTickListField = field;
                    break;
                }
                ++n2;
            }
            if (endTickListField != null) {
                endTickListField.setAccessible(true);
                Object nmsServer = this.getServer().getClass().getMethod("getServer", new Class[0]).invoke((Object)this.getServer(), new Object[0]);
                List endList = (List)endTickListField.get(nmsServer);
                Object proxy = Proxy.newProxyInstance(Runnable.class.getClassLoader(), new Class[]{Runnable.class}, (proxyObj, method, args) -> {
                    long endNs = System.nanoTime();
                    double durationMs = (double)(endNs - this.lastTickStartNs) / 1000000.0;
                    long remainNs = 50000000L - (endNs - this.lastTickStartNs);
                    Bukkit.getPluginManager().callEvent((Event)new ServerTickEndEvent(this.tickNumber, durationMs, remainNs));
                    return null;
                });
                endList.add(proxy);
            } else {
                Utils.log(System.Logger.Level.WARNING, "Could not find end-of-tick list field on MinecraftServer");
            }
        }
        catch (Exception e) {
            Utils.log(System.Logger.Level.WARNING, "Failed to register end-of-tick proxy: " + e);
        }
        msptCalculator = new SocketOnGetMSPTEvent();
        Bukkit.getPluginManager().registerEvents((Listener)msptCalculator, (Plugin)this);
        if (ServerConfig.secretKey.equals("CHANGETHISSECRETKEY")) {
            Utils.log(System.Logger.Level.INFO, "\u00a7e-------------------");
            Utils.log(System.Logger.Level.INFO, "\u00a77To start using StatusMC's TPS and MSPT monitoring services, register for an");
            Utils.log(System.Logger.Level.INFO, "account at \u00a79https://statusmc.net/");
            Utils.log(System.Logger.Level.INFO, "\u00a77Detailed instructions on how to setup TPS/MSPT monitoring can be found here:");
            Utils.log(System.Logger.Level.INFO, "\u00a79https://support.statusmc.net/en/blog/setting-up-minecraft-tps-mspt-monitoring");
            Utils.log(System.Logger.Level.INFO, "\u00a7e-------------------");
        }
        if (!APIRequest.checkVersion(pluginVersion = this.pdf.getVersion())) {
            Utils.log(System.Logger.Level.INFO, "\u00a7e-------------------");
            Utils.log(System.Logger.Level.INFO, "\u00a77A \u00a7anew \u00a77version of the \u00a79StatusMC \u00a77plugin is \u00a7aavailable!");
            Utils.log(System.Logger.Level.INFO, "Download it here: \u00a79https://statusmc.net/downloads");
            Utils.log(System.Logger.Level.INFO, "\u00a7e-------------------");
        }
    }

    public void onDisable() {
        block7: {
            try {
                if (SocketServer.listenSock != null && !SocketServer.listenSock.isClosed()) {
                    SocketServer.listenSock.close();
                }
                if (SocketServer.in != null) {
                    SocketServer.in.close();
                }
                if (SocketServer.out != null) {
                    SocketServer.out.close();
                }
                if (SocketServer.sock != null && !SocketServer.sock.isClosed()) {
                    SocketServer.sock.close();
                }
            }
            catch (Exception ex) {
                if (!ServerConfig.developer_mode.equals(true)) break block7;
                ex.printStackTrace();
            }
        }
        if (this.tickTask != null) {
            this.tickTask.cancel();
            this.tickTask = null;
        }
        Utils.log(System.Logger.Level.INFO, "\u00a79StatusMC Monitoring plugin \u00a77has been \u00a74turned off\u00a77!");
    }

    public void configLoad() {
        this.reloadConfig();
        FileConfiguration config = this.getConfig();
        ServerConfig.prefix = String.valueOf(String.valueOf(String.valueOf(config.get("prefix")).replaceAll("&", "\u00a7"))) + " ";
        ServerConfig.port = config.getInt("port");
        ServerConfig.secretKey = config.getString("secret_key");
        ServerConfig.wrongSecretKey = config.getString("wrongSecretKey").replaceAll("&", "\u00a7");
        ServerConfig.unexpectederror = config.getString("unexpectederror").replaceAll("&", "\u00a7");
        ServerConfig.successfulLogin = config.getString("successfulLogin").replaceAll("&", "\u00a7");
        ServerConfig.consoleInfo = config.getBoolean("consoleInfo");
        ServerConfig.developer_mode = config.getBoolean("developer_mode");
        ServerConfig.disable_successful_connection_message = config.getBoolean("disable_successful_connection_message");
        ServerConfig.log_performance_metrics = config.getBoolean("log_performance_metrics");
        ServerConfig.log_only_low_tps = config.getBoolean("log_only_low_tps");
        ServerConfig.low_tps_threshold = config.getDouble("low_tps_threshold");
        ServerConfig.log_only_high_min_mspt = config.getBoolean("log_only_high_min_mspt");
        ServerConfig.high_min_mspt_threshold = config.getDouble("high_min_mspt_threshold");
        ServerConfig.log_only_high_avg_mspt = config.getBoolean("log_only_high_avg_mspt");
        ServerConfig.high_avg_mspt_threshold = config.getDouble("high_avg_mspt_threshold");
        ServerConfig.log_only_high_max_mspt = config.getBoolean("log_only_high_max_mspt");
        ServerConfig.high_max_mspt_threshold = config.getDouble("high_max_mspt_threshold");
        ServerConfig.successfullyReloaded = config.getString("successfullyReloaded").replaceAll("&", "\u00a7");
        ServerConfig.nopermissions = config.getString("nopermissions").replaceAll("&", "\u00a7");
        ServerConfig.incorrectUsage = config.getString("incorrectUsage").replaceAll("&", "\u00a7");
        ServerConfig.unableMinMSPT = config.getString("unableMinMSPT").replaceAll("&", "\u00a7");
        ServerConfig.unableAvgMSPT = config.getString("unableAvgMSPT").replaceAll("&", "\u00a7");
        ServerConfig.unableMaxMSPT = config.getString("unableMaxMSPT").replaceAll("&", "\u00a7");
    }

    public SocketOnGetMSPTEvent getMsptCalculator() {
        return msptCalculator;
    }
}

