/*
 * Decompiled with CFR 0.152.
 */
package net.statusmc.events;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.statusmc.events.ServerTickEndEvent;
import net.statusmc.events.ServerTickStartEvent;
import net.statusmc.utils.ServerConfig;
import net.statusmc.utils.Utils;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class SocketOnGetMSPTEvent
implements Listener {
    private long tickStartTime;
    private double mspt = 0.0;
    private static final List<Double> tickTimes = new ArrayList<Double>();
    private static final ReadWriteLock lock = new ReentrantReadWriteLock();

    @EventHandler
    public void onServerTickStart(ServerTickStartEvent event) {
        this.tickStartTime = System.nanoTime();
    }

    @EventHandler
    public void onServerTickEnd(ServerTickEndEvent event) {
        double mspt = event.getTickDuration();
        lock.writeLock().lock();
        try {
            tickTimes.add(mspt);
            if (tickTimes.size() > 1200) {
                tickTimes.remove(0);
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public static double getMinMSPT() {
        lock.readLock().lock();
        try {
            if (tickTimes.size() == 1200) {
                double minMspt2;
                double min = Collections.min(tickTimes);
                double d = minMspt2 = (double)Math.round(min * 10.0) / 10.0;
                return d;
            }
            Utils.log(System.Logger.Level.WARNING, Utils.format(ServerConfig.unableMinMSPT));
            return 0.0;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public static double getAvgMSPT() {
        lock.readLock().lock();
        try {
            if (tickTimes.size() == 1200) {
                double averageMspt2;
                double average2 = tickTimes.stream().mapToDouble(Double::doubleValue).average().orElse(0.0);
                double d = averageMspt2 = (double)Math.round(average2 * 10.0) / 10.0;
                return d;
            }
            Utils.log(System.Logger.Level.WARNING, Utils.format(ServerConfig.unableAvgMSPT));
            return 0.0;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public static double getMaxMSPT() {
        lock.readLock().lock();
        try {
            if (tickTimes.size() == 1200) {
                double maxMspt2;
                double max2 = Collections.max(tickTimes);
                double d = maxMspt2 = (double)Math.round(max2 * 10.0) / 10.0;
                return d;
            }
            Utils.log(System.Logger.Level.WARNING, Utils.format(ServerConfig.unableMaxMSPT));
            return 0.0;
        }
        finally {
            lock.readLock().unlock();
        }
    }
}

