/*
 * Decompiled with CFR 0.152.
 */
package tr.s42.core.strategy;

import net.cutecraft.libs.kotlin.Metadata;
import net.cutecraft.libs.kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.MerchantInventory;
import org.jetbrains.annotations.NotNull;
import tr.s42.core.event.VillagerCycleTradeEvent;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Ltr/s42/core/strategy/KeyboardStrategy;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "onInventoryClickEvent", "", "event", "Lorg/bukkit/event/inventory/InventoryClickEvent;", "core"})
public final class KeyboardStrategy
implements Listener {
    @EventHandler
    public final void onInventoryClickEvent(@NotNull InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.isCancelled()) {
            return;
        }
        if (event.getClick() != ClickType.SWAP_OFFHAND) {
            return;
        }
        HumanEntity humanEntity = event.getWhoClicked();
        Intrinsics.checkNotNull(humanEntity, "null cannot be cast to non-null type org.bukkit.entity.Player");
        Player player = (Player)humanEntity;
        Inventory inventory = player.getOpenInventory().getTopInventory();
        Intrinsics.checkNotNullExpressionValue(inventory, "getTopInventory(...)");
        Inventory topInventory = inventory;
        if (!(topInventory instanceof MerchantInventory)) {
            return;
        }
        InventoryHolder holder = ((MerchantInventory)topInventory).getHolder();
        if (!(holder instanceof Villager)) {
            return;
        }
        event.setCancelled(true);
        Bukkit.getPluginManager().callEvent((Event)new VillagerCycleTradeEvent(player, (Villager)holder));
    }
}

