/*
 * Decompiled with CFR 0.152.
 */
package tr.s42.core.service;

import java.util.Map;
import net.cutecraft.libs.kotlin.Metadata;
import net.cutecraft.libs.kotlin.Pair;
import net.cutecraft.libs.kotlin.TuplesKt;
import net.cutecraft.libs.kotlin.collections.MapsKt;
import net.cutecraft.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import net.cutecraft.libs.kotlin.jvm.internal.Intrinsics;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;
import tr.s42.core.service.IMessageService;
import tr.s42.core.strategy.KeyboardStrategy;
import tr.s42.core.strategy.ShiftInteractStrategy;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ltr/s42/core/service/TradeCycleService;", "", "messageService", "Ltr/s42/core/service/IMessageService;", "config", "Lorg/bukkit/configuration/file/FileConfiguration;", "<init>", "(Ltr/s42/core/service/IMessageService;Lorg/bukkit/configuration/file/FileConfiguration;)V", "sendActionBar", "", "player", "Lorg/bukkit/entity/Player;", "messageKey", "", "cycleTrade", "villager", "Lorg/bukkit/entity/Villager;", "isLocked", "", "hasProfession", "Companion", "core"})
public final class TradeCycleService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IMessageService messageService;
    @NotNull
    private final FileConfiguration config;
    @NotNull
    private static final Map<String, Listener> strategies;

    public TradeCycleService(@NotNull IMessageService messageService, @NotNull FileConfiguration config) {
        Intrinsics.checkNotNullParameter(messageService, "messageService");
        Intrinsics.checkNotNullParameter(config, "config");
        this.messageService = messageService;
        this.config = config;
    }

    public final void sendActionBar(@NotNull Player player, @NotNull String messageKey) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(messageKey, "messageKey");
        String string = this.config.getString("messages." + messageKey);
        if (string == null) {
            throw new IllegalArgumentException("Message key '" + messageKey + "' not found in config");
        }
        String message = string;
        this.messageService.sendActionBar(player, message);
    }

    public final void cycleTrade(@NotNull Villager villager) {
        Intrinsics.checkNotNullParameter(villager, "villager");
        Villager.Profession profession = villager.getProfession();
        Intrinsics.checkNotNullExpressionValue(profession, "getProfession(...)");
        Villager.Profession profession2 = profession;
        villager.setProfession(Villager.Profession.NONE);
        villager.setProfession(profession2);
    }

    public final boolean isLocked(@NotNull Villager villager) {
        Intrinsics.checkNotNullParameter(villager, "villager");
        return villager.getVillagerExperience() > 0;
    }

    public final boolean hasProfession(@NotNull Villager villager) {
        Intrinsics.checkNotNullParameter(villager, "villager");
        return !Intrinsics.areEqual(villager.getProfession(), Villager.Profession.NONE);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to("KEYBOARD", new KeyboardStrategy()), TuplesKt.to("SHIFT_INTERACT", new ShiftInteractStrategy())};
        strategies = MapsKt.mapOf(pairArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Ltr/s42/core/service/TradeCycleService$Companion;", "", "<init>", "()V", "strategies", "", "", "Lorg/bukkit/event/Listener;", "getStrategies", "()Ljava/util/Map;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, Listener> getStrategies() {
            return strategies;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

