/*
 * Decompiled with CFR 0.152.
 */
package tr.s42.core.listener;

import net.cutecraft.libs.kotlin.Metadata;
import net.cutecraft.libs.kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import tr.s42.core.event.VillagerCycleTradeEvent;
import tr.s42.core.service.TradeCycleService;
import tr.s42.core.util.SoundUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ltr/s42/core/listener/VillagerCycleListener;", "Lorg/bukkit/event/Listener;", "tradeCycleService", "Ltr/s42/core/service/TradeCycleService;", "plugin", "Lorg/bukkit/plugin/Plugin;", "<init>", "(Ltr/s42/core/service/TradeCycleService;Lorg/bukkit/plugin/Plugin;)V", "onVillagerCycleTradeEvent", "", "event", "Ltr/s42/core/event/VillagerCycleTradeEvent;", "sendFailureMessage", "player", "Lorg/bukkit/entity/Player;", "messageKey", "", "core"})
public final class VillagerCycleListener
implements Listener {
    @NotNull
    private final TradeCycleService tradeCycleService;
    @NotNull
    private final Plugin plugin;

    public VillagerCycleListener(@NotNull TradeCycleService tradeCycleService, @NotNull Plugin plugin) {
        Intrinsics.checkNotNullParameter(tradeCycleService, "tradeCycleService");
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.tradeCycleService = tradeCycleService;
        this.plugin = plugin;
    }

    @EventHandler
    public final void onVillagerCycleTradeEvent(@NotNull VillagerCycleTradeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        Villager villager = event.getVillager();
        Player player = event.getPlayer();
        if (!this.tradeCycleService.hasProfession(villager)) {
            this.sendFailureMessage(player, "NO_PROFESSION");
            return;
        }
        if (this.tradeCycleService.isLocked(villager)) {
            this.sendFailureMessage(player, "VILLAGER_LOCKED");
            return;
        }
        this.tradeCycleService.cycleTrade(villager);
        Bukkit.getScheduler().runTask(this.plugin, () -> VillagerCycleListener.onVillagerCycleTradeEvent$lambda$0(player, villager));
        SoundUtil.INSTANCE.play(Sound.UI_BUTTON_CLICK, player);
        this.tradeCycleService.sendActionBar(player, "CYCLE_SUCCESS");
    }

    private final void sendFailureMessage(Player player, String messageKey) {
        SoundUtil.INSTANCE.play(Sound.ENTITY_VILLAGER_NO, player);
        this.tradeCycleService.sendActionBar(player, messageKey);
    }

    private static final void onVillagerCycleTradeEvent$lambda$0(Player $player, Villager $villager) {
        $player.closeInventory();
        $player.openMerchant($villager, true);
    }
}

