/*
 * Decompiled with CFR 0.152.
 */
package tr.s42.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import net.cutecraft.libs.kotlin.Metadata;
import net.cutecraft.libs.kotlin.Unit;
import net.cutecraft.libs.kotlin.collections.CollectionsKt;
import net.cutecraft.libs.kotlin.jvm.internal.Intrinsics;
import net.cutecraft.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.NotNull;
import tr.s42.core.PlatformProvider;
import tr.s42.core.common.ComparableVersion;
import tr.s42.core.common.VersionCheckTask;
import tr.s42.core.listener.VillagerCycleListener;
import tr.s42.core.service.TradeCycleService;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\u000bH\u0002J\u0018\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ltr/s42/core/Platform;", "", "provider", "Ltr/s42/core/PlatformProvider;", "<init>", "(Ltr/s42/core/PlatformProvider;)V", "plugin", "Lorg/bukkit/plugin/Plugin;", "logger", "Ljava/util/logging/Logger;", "onEnable", "", "checkForUpdates", "registerStrategies", "service", "Ltr/s42/core/service/TradeCycleService;", "config", "Lorg/bukkit/configuration/file/FileConfiguration;", "core"})
@SourceDebugExtension(value={"SMAP\nPlatform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Platform.kt\ntr/s42/core/Platform\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,50:1\n1557#2:51\n1628#2,3:52\n1863#2,2:55\n*S KotlinDebug\n*F\n+ 1 Platform.kt\ntr/s42/core/Platform\n*L\n41#1:51\n41#1:52,3\n47#1:55,2\n*E\n"})
public final class Platform {
    @NotNull
    private final PlatformProvider provider;
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final Logger logger;

    public Platform(@NotNull PlatformProvider provider) {
        Intrinsics.checkNotNullParameter(provider, "provider");
        this.provider = provider;
        this.plugin = this.provider.getPlugin();
        Logger logger = this.plugin.getLogger();
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        this.logger = logger;
    }

    public final void onEnable() {
        this.checkForUpdates();
        this.plugin.saveDefaultConfig();
        FileConfiguration fileConfiguration = this.plugin.getConfig();
        Intrinsics.checkNotNullExpressionValue(fileConfiguration, "getConfig(...)");
        FileConfiguration config = fileConfiguration;
        TradeCycleService service = new TradeCycleService(this.provider.getMessageService(), config);
        this.registerStrategies(service, config);
    }

    private final void checkForUpdates() {
        new VersionCheckTask(arg_0 -> Platform.checkForUpdates$lambda$0(this, arg_0)).runTaskAsynchronously(this.plugin);
    }

    /*
     * WARNING - void declaration
     */
    private final void registerStrategies(TradeCycleService service, FileConfiguration config) {
        void $this$mapTo$iv$iv;
        List list = config.getStringList("strategy");
        Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Listener listener = TradeCycleService.Companion.getStrategies().get(it);
            if (listener == null) {
                throw new IllegalArgumentException("Invalid strategy: " + (String)it);
            }
            collection.add(listener);
        }
        List strategies = (List)destination$iv$iv;
        PluginManager pluginManager = this.plugin.getServer().getPluginManager();
        Intrinsics.checkNotNullExpressionValue(pluginManager, "getPluginManager(...)");
        PluginManager pluginManager2 = pluginManager;
        pluginManager2.registerEvents((Listener)new VillagerCycleListener(service, this.plugin), this.plugin);
        Iterable $this$forEach$iv = strategies;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Listener it = (Listener)element$iv;
            boolean bl = false;
            pluginManager2.registerEvents(it, this.plugin);
        }
    }

    private static final Unit checkForUpdates$lambda$0(Platform this$0, ComparableVersion latestVersion) {
        Intrinsics.checkNotNullParameter(latestVersion, "latestVersion");
        String string = this$0.plugin.getDescription().getVersion();
        Intrinsics.checkNotNullExpressionValue(string, "getVersion(...)");
        ComparableVersion currentVersion = new ComparableVersion(string);
        if (currentVersion.compareTo(latestVersion) < 0) {
            this$0.logger.warning("A new version of TradeCycle is available: " + latestVersion.getRawVersion() + ". You are using version: " + currentVersion.getRawVersion());
            this$0.logger.warning("Download the latest version at: https://api.spigotmc.org/legacy/update.php?resource=122805");
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }
}

