/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.blocklocker.location;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import nl.rutgerkok.blocklocker.location.IllegalLocationException;
import nl.rutgerkok.blocklocker.location.LocationChecker;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public final class CombinedLocationChecker
implements LocationChecker {
    private final List<LocationChecker> checkers = new ArrayList<LocationChecker>();

    public void addChecker(LocationChecker checker) {
        this.checkers.add(Objects.requireNonNull(checker, "checker"));
    }

    @Override
    public void checkLocation(Player player, Block block) throws IllegalLocationException {
        for (LocationChecker checker : this.checkers) {
            checker.checkLocation(player, block);
        }
    }

    public Collection<LocationChecker> getReloadSurvivors() {
        ArrayList<LocationChecker> reloadSurvivors = new ArrayList<LocationChecker>();
        for (LocationChecker checker : this.checkers) {
            if (!checker.keepOnReload()) continue;
            reloadSurvivors.add(checker);
        }
        return reloadSurvivors;
    }
}

