/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.blocklocker.impl.updater;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.rutgerkok.blocklocker.Translator;
import nl.rutgerkok.blocklocker.impl.BlockLockerPluginImpl;
import nl.rutgerkok.blocklocker.impl.updater.UpdateCheckResult;
import nl.rutgerkok.blocklocker.impl.updater.UpdateChecker;
import nl.rutgerkok.blocklocker.impl.updater.UpdateNotifier;
import nl.rutgerkok.blocklocker.impl.updater.UpdatePreference;
import nl.rutgerkok.blocklocker.impl.updater.UpdateResult;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public final class Updater {
    private static final long CHECK_INTERVAL = 864000L;
    private final BlockLockerPluginImpl plugin;
    private volatile UpdatePreference preference;
    private final Translator translator;

    public Updater(UpdatePreference preference, Translator translator, BlockLockerPluginImpl plugin) {
        this.preference = (UpdatePreference)((Object)Preconditions.checkNotNull((Object)((Object)preference)));
        this.translator = (Translator)Preconditions.checkNotNull((Object)translator);
        this.plugin = (BlockLockerPluginImpl)Preconditions.checkNotNull((Object)plugin);
    }

    private Optional<String> getMinecraftVersion() {
        String serverVersion = this.plugin.getServer().getVersion();
        String regex = "MC\\: *([A-Za-z0-9\\._\\-]+)";
        Matcher matcher = Pattern.compile(regex).matcher(serverVersion);
        if (matcher.find() && matcher.groupCount() == 1) {
            return Optional.of(matcher.group(1));
        }
        return Optional.empty();
    }

    private void notifyServer(final UpdateResult result) {
        if (!result.hasNotification()) {
            return;
        }
        this.preference = UpdatePreference.DISABLED;
        if (this.plugin.getServer().isPrimaryThread()) {
            this.notifyServerFromServerThread(result);
        } else {
            this.plugin.runLaterGlobally(new Runnable(){

                @Override
                public void run() {
                    Updater.this.notifyServerFromServerThread(result);
                }
            }, 1);
        }
    }

    private void notifyServerFromServerThread(UpdateResult result) {
        UpdateNotifier notifier = new UpdateNotifier(this.translator, result);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)notifier, (Plugin)this.plugin);
        notifier.sendNotification((CommandSender)this.plugin.getServer().getConsoleSender());
    }

    public void startUpdater() {
        if (!this.preference.checkForUpdates()) {
            return;
        }
        this.plugin.runTimerAsync(task -> {
            if (this.preference.checkForUpdates()) {
                this.updateSync();
            } else {
                task.cancel();
            }
        }, 864000L);
    }

    private void notifyUpdateAvailable(UpdateCheckResult result) throws IOException {
        Optional<String> minecraftVersion = this.getMinecraftVersion();
        if (minecraftVersion.isEmpty() || result.getMinecraftVersions().containsAll((Collection<?>)ImmutableSet.of((Object)minecraftVersion.get()))) {
            this.notifyServer(new UpdateResult(UpdateResult.Status.MANUAL_UPDATE, result));
        } else {
            this.notifyServer(new UpdateResult(UpdateResult.Status.UNSUPPORTED_SERVER, result));
        }
    }

    private void updateSync() {
        try {
            UpdateChecker checker = new UpdateChecker();
            UpdateCheckResult result = checker.checkForUpdatesSync((Plugin)this.plugin);
            if (result.needsUpdate()) {
                this.notifyUpdateAvailable(result);
            } else {
                this.notifyServer(new UpdateResult(UpdateResult.Status.NO_UPDATE, result));
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.WARNING, "Error during update check (you can disable automatic updates in the config file)", e);
            this.notifyServer(UpdateResult.failed());
        }
    }
}

