/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.blocklocker.impl.updater;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.net.URL;
import java.util.Optional;
import java.util.Set;
import nl.rutgerkok.blocklocker.Translator;
import nl.rutgerkok.blocklocker.impl.updater.UpdateCheckResult;
import nl.rutgerkok.blocklocker.impl.updater.UpdateResult;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

final class UpdateNotifier
implements Listener {
    private final UpdateResult result;
    private final Translator translator;

    public UpdateNotifier(Translator translator, UpdateResult result) {
        this.result = (UpdateResult)Preconditions.checkNotNull((Object)result);
        this.translator = (Translator)Preconditions.checkNotNull((Object)translator);
        Preconditions.checkArgument((boolean)result.hasNotification(), (Object)"result must have a notification");
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (player.hasPermission("blocklocker.bypass")) {
            this.sendNotification((CommandSender)player);
        }
    }

    void sendNotification(CommandSender sender) {
        UpdateCheckResult checkResult = this.result.getUpdateCheckResult();
        String newVersion = checkResult.getLatestVersion().orElse("?");
        switch (this.result.getStatus()) {
            case MANUAL_UPDATE: {
                this.translator.sendMessage(sender, Translator.Translation.UPDATER_UPDATE_AVAILABLE, newVersion);
                break;
            }
            case UNSUPPORTED_SERVER: {
                Set<String> mcVersions = this.result.getUpdateCheckResult().getMinecraftVersions();
                String mcVersionsString = Joiner.on((String)", ").join(mcVersions);
                this.translator.sendMessage(sender, Translator.Translation.UPDATER_UNSUPPORTED_SERVER, newVersion, mcVersionsString);
                break;
            }
            default: {
                throw new AssertionError((Object)("Umhandled case: " + String.valueOf((Object)this.result.getStatus())));
            }
        }
        Optional<URL> infoUrl = checkResult.getInfoUrl();
        if (infoUrl.isPresent()) {
            this.translator.sendMessage(sender, Translator.Translation.UPDATER_MORE_INFORMATION, infoUrl.get().toString());
        }
    }
}

