/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.blocklocker.impl.updater;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;

final class UpdateCheckResult {
    private static final String ERROR_KEY = "error";
    private static final String INFO_URL_KEY = "infoUrl";
    private static final String NEEDS_UPDATE_KEY = "needsUpdate";
    private static final String REQUIREMENTS_KEY = "requirements";
    private static final String VERSION_KEY = "version";
    private final Optional<URL> infoUrl;
    private final Optional<String> latestVersion;
    private final Set<String> minecraftVersions;
    private final boolean needsUpdate;

    UpdateCheckResult(JsonObject object) throws IOException, ClassCastException {
        JsonElement error = object.get(ERROR_KEY);
        if (error instanceof String) {
            throw new IOException((String)error);
        }
        this.needsUpdate = this.getBoolean(object, NEEDS_UPDATE_KEY);
        this.latestVersion = Optional.ofNullable(object.get(VERSION_KEY)).map(JsonElement::getAsString);
        this.infoUrl = this.getUrl(object, INFO_URL_KEY);
        this.minecraftVersions = this.getStringSet(object, REQUIREMENTS_KEY);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCheckResult)) {
            return false;
        }
        UpdateCheckResult other = (UpdateCheckResult)obj;
        if (!this.infoUrl.equals(other.infoUrl)) {
            return false;
        }
        if (!this.latestVersion.equals(other.latestVersion)) {
            return false;
        }
        if (!this.minecraftVersions.equals(other.minecraftVersions)) {
            return false;
        }
        return this.needsUpdate == other.needsUpdate;
    }

    private boolean getBoolean(JsonObject object, String key) {
        JsonElement element = object.get(key);
        if (element == null) {
            return false;
        }
        Boolean bool = element.getAsBoolean();
        return bool;
    }

    public Optional<URL> getInfoUrl() {
        return this.infoUrl;
    }

    public Optional<String> getLatestVersion() {
        return this.latestVersion;
    }

    public Set<String> getMinecraftVersions() {
        return this.minecraftVersions;
    }

    private Set<String> getStringSet(JsonObject object, String key) {
        if (!object.has(key)) {
            return Collections.emptySet();
        }
        JsonArray array = object.get(key).getAsJsonArray();
        if (array.size() > 0 && array.get(0).isJsonPrimitive() && array.get(0).getAsJsonPrimitive().isString()) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            array.forEach(el -> builder.add((Object)el.getAsString()));
            return builder.build();
        }
        return Collections.emptySet();
    }

    private Optional<URL> getUrl(JsonObject object, String key) throws ClassCastException {
        JsonElement element = object.get(key);
        if (element == null || element.getAsString().isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of(new URL(element.getAsString()));
        }
        catch (MalformedURLException e) {
            return Optional.empty();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.infoUrl.hashCode();
        result = 31 * result + this.latestVersion.hashCode();
        result = 31 * result + this.minecraftVersions.hashCode();
        result = 31 * result + (this.needsUpdate ? 1231 : 1237);
        return result;
    }

    public boolean needsUpdate() {
        return this.needsUpdate;
    }

    public String toString() {
        if (this.needsUpdate) {
            return "UpdateResult{needsUpdate=" + this.needsUpdate + "}";
        }
        return "UpdateResult{needsUpdate=" + this.needsUpdate + ", latestVersion=" + (String)this.latestVersion.orElse(null) + ", infoUrl=" + String.valueOf(this.infoUrl.orElse(null)) + ", minecraftVersions=" + String.valueOf(this.minecraftVersions) + "}";
    }
}

