/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.blocklocker.impl.protection;

import java.util.Arrays;
import java.util.Collection;
import nl.rutgerkok.blocklocker.OpenBlockSound;
import nl.rutgerkok.blocklocker.ProtectionSign;
import nl.rutgerkok.blocklocker.impl.blockfinder.BlockFinder;
import nl.rutgerkok.blocklocker.impl.protection.AbstractProtection;
import nl.rutgerkok.blocklocker.protection.AttachedProtection;
import nl.rutgerkok.blocklocker.protection.Protection;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Openable;

public final class AttachedProtectionImpl
extends AbstractProtection
implements AttachedProtection {
    private final BlockFinder blockFinder;
    private final Block protectionBlock;

    public static Protection fromBlockWithSign(ProtectionSign sign, BlockFinder blockFinder, Block protectionBlock) {
        return new AttachedProtectionImpl(sign, blockFinder, protectionBlock);
    }

    public static Protection fromBlockWithSigns(Collection<ProtectionSign> signs, BlockFinder blockFinder, Block trapDoor) {
        return new AttachedProtectionImpl(signs, blockFinder, trapDoor);
    }

    private static void setBlockOpen(Block block, boolean open) {
        BlockData blockData = block.getBlockData();
        if (!AttachedProtectionImpl.isFunctionalOpenable(blockData)) {
            return;
        }
        Openable openable = (Openable)blockData;
        if (openable.isOpen() == open) {
            return;
        }
        openable.setOpen(open);
        block.setBlockData(blockData);
    }

    private AttachedProtectionImpl(Collection<ProtectionSign> signs, BlockFinder blockFinder, Block trapDoor) {
        super(signs);
        this.protectionBlock = trapDoor;
        this.blockFinder = blockFinder;
    }

    private AttachedProtectionImpl(ProtectionSign sign, BlockFinder blockFinder, Block trapDoor) {
        super(sign);
        this.protectionBlock = trapDoor;
        this.blockFinder = blockFinder;
    }

    @Override
    public boolean canBeOpened() {
        return AttachedProtectionImpl.isFunctionalOpenable(this.protectionBlock.getBlockData());
    }

    @Override
    protected Collection<ProtectionSign> fetchSigns() {
        Block supportingBlock = this.blockFinder.findSupportingBlock(this.protectionBlock);
        return this.blockFinder.findAttachedSigns(Arrays.asList(this.protectionBlock, supportingBlock));
    }

    @Override
    public Block getSomeProtectedBlock() {
        return this.protectionBlock;
    }

    @Override
    public boolean isOpen() {
        BlockData materialData = this.protectionBlock.getBlockData();
        if (AttachedProtectionImpl.isFunctionalOpenable(materialData)) {
            return ((Openable)materialData).isOpen();
        }
        return false;
    }

    @Override
    public void setOpen(boolean open, Protection.SoundCondition playSound) {
        AttachedProtectionImpl.setBlockOpen(this.protectionBlock, open);
        Block supportingBlock = this.blockFinder.findSupportingBlock(this.protectionBlock);
        AttachedProtectionImpl.setBlockOpen(supportingBlock, open);
        if (playSound == Protection.SoundCondition.ALWAYS && this.isOpen() != open) {
            Sound sound = OpenBlockSound.get(this.protectionBlock.getType(), open);
            this.protectionBlock.getWorld().playSound(this.protectionBlock.getLocation(), sound, 1.0f, 0.7f);
        }
    }
}

