/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.blocklocker.impl.protection;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import nl.rutgerkok.blocklocker.ProtectionSign;
import nl.rutgerkok.blocklocker.profile.Profile;
import nl.rutgerkok.blocklocker.profile.TimerProfile;
import nl.rutgerkok.blocklocker.protection.Protection;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Openable;

abstract class AbstractProtection
implements Protection {
    private Optional<Collection<Profile>> allAllowed = Optional.empty();
    private Optional<Profile> owner = Optional.empty();
    private Optional<Collection<ProtectionSign>> allSigns = Optional.empty();

    AbstractProtection(Collection<ProtectionSign> signs) {
        Validate.notEmpty(signs);
        this.allSigns = Optional.of(signs);
    }

    AbstractProtection(ProtectionSign sign) {
        List<Profile> profiles;
        if (sign.getType().isMainSign() && !(profiles = sign.getProfiles()).isEmpty()) {
            this.owner = Optional.of(profiles.get(0));
        }
    }

    protected static boolean isFunctionalOpenable(BlockData blockData) {
        if (!(blockData instanceof Openable)) {
            return false;
        }
        return blockData.getMaterial() != Material.BARREL;
    }

    private Collection<Profile> fetchAllowed(Collection<ProtectionSign> signs) {
        ArrayList allAllowed = Lists.newArrayList();
        for (ProtectionSign sign : signs) {
            allAllowed.addAll(sign.getProfiles());
        }
        return allAllowed;
    }

    private Optional<Profile> fetchOwner() {
        for (ProtectionSign sign : this.getSigns()) {
            if (!sign.getType().isMainSign()) continue;
            List<Profile> profiles = sign.getProfiles();
            if (profiles.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(profiles.get(0));
        }
        return Optional.empty();
    }

    protected abstract Collection<ProtectionSign> fetchSigns();

    @Override
    public final Collection<Profile> getAllowed() {
        if (!this.allAllowed.isPresent()) {
            this.allAllowed = Optional.of(this.fetchAllowed(this.getSigns()));
        }
        return this.allAllowed.get();
    }

    @Override
    public final int getOpenSeconds() {
        for (Profile profile : this.getAllowed()) {
            if (!(profile instanceof TimerProfile)) continue;
            return ((TimerProfile)profile).getOpenSeconds();
        }
        return -1;
    }

    @Override
    public final Optional<Profile> getOwner() {
        if (!this.owner.isPresent()) {
            this.owner = this.fetchOwner();
        }
        return this.owner;
    }

    @Override
    public final String getOwnerDisplayName() {
        Optional<Profile> owner = this.getOwner();
        if (owner.isPresent()) {
            return owner.get().getDisplayName();
        }
        return "?";
    }

    @Override
    public final Collection<ProtectionSign> getSigns() {
        if (!this.allSigns.isPresent()) {
            this.allSigns = Optional.of(this.fetchSigns());
        }
        return this.allSigns.get();
    }

    @Override
    public final boolean isAllowed(Profile profile) {
        for (Profile allowed : this.getAllowed()) {
            if (!allowed.includes(profile)) continue;
            return true;
        }
        return !this.getOwner().isPresent();
    }

    @Override
    public boolean isExpired(Date cutoffDate) {
        Optional<Profile> owner = this.getOwner();
        if (owner.isPresent()) {
            return owner.get().isExpired(cutoffDate);
        }
        return false;
    }

    @Override
    public final boolean isOwner(Profile profile) {
        Validate.notNull((Object)profile);
        Optional<Profile> owner = this.getOwner();
        if (!owner.isPresent()) {
            return true;
        }
        return owner.get().includes(profile);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AbstractProtection)) {
            return false;
        }
        AbstractProtection that = (AbstractProtection)other;
        Collection<ProtectionSign> otherSigns = that.getSigns();
        Collection<ProtectionSign> ourSigns = this.getSigns();
        return otherSigns.containsAll(ourSigns) && ourSigns.containsAll(otherSigns);
    }

    public int hashCode() {
        int hashCode = 0;
        for (ProtectionSign sign : this.getSigns()) {
            hashCode += sign.hashCode();
        }
        return hashCode;
    }
}

