/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.blocklocker.impl.profile;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import nl.rutgerkok.blocklocker.ProfileFactory;
import nl.rutgerkok.blocklocker.SecretSignEntry;
import nl.rutgerkok.blocklocker.Translator;
import nl.rutgerkok.blocklocker.group.GroupSystem;
import nl.rutgerkok.blocklocker.impl.profile.EveryoneProfileImpl;
import nl.rutgerkok.blocklocker.impl.profile.GolemProfileImpl;
import nl.rutgerkok.blocklocker.impl.profile.GroupLeaderProfileImpl;
import nl.rutgerkok.blocklocker.impl.profile.GroupProfileImpl;
import nl.rutgerkok.blocklocker.impl.profile.PlayerProfileImpl;
import nl.rutgerkok.blocklocker.impl.profile.RedstoneProfileImpl;
import nl.rutgerkok.blocklocker.impl.profile.TimerProfileImpl;
import nl.rutgerkok.blocklocker.profile.PlayerProfile;
import nl.rutgerkok.blocklocker.profile.Profile;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public final class ProfileFactoryImpl
implements ProfileFactory {
    private static final Profile EMPTY_PROFILE = new PlayerProfileImpl("", Optional.empty());
    private final Profile everyoneProfile;
    private final List<String> everyoneTagList;
    private final GroupSystem groupSystem;
    private final Profile redstoneProfile;
    private final Profile golemProfile;
    private final List<String> redstoneTagList;
    private final List<String> golemTagList;
    private final List<String> timerTagStart;
    private final Translator translator;

    public ProfileFactoryImpl(GroupSystem groupSystem, Translator translator) {
        this.groupSystem = (GroupSystem)Preconditions.checkNotNull((Object)groupSystem);
        this.translator = (Translator)Preconditions.checkNotNull((Object)translator);
        this.everyoneTagList = new ArrayList<String>();
        this.redstoneTagList = new ArrayList<String>();
        this.golemTagList = new ArrayList<String>();
        this.timerTagStart = new ArrayList<String>();
        translator.getAllWithoutColor(Translator.Translation.TAG_EVERYONE).forEach(value -> this.everyoneTagList.add("[" + value + "]"));
        translator.getAllWithoutColor(Translator.Translation.TAG_REDSTONE).forEach(value -> this.redstoneTagList.add("[" + value + "]"));
        translator.getAllWithoutColor(Translator.Translation.TAG_GOLEM).forEach(value -> this.golemTagList.add("[" + value + "]"));
        translator.getAllWithoutColor(Translator.Translation.TAG_TIMER).forEach(value -> this.timerTagStart.add("[" + value + ":"));
        this.everyoneProfile = new EveryoneProfileImpl(translator.get(Translator.Translation.TAG_EVERYONE));
        this.redstoneProfile = new RedstoneProfileImpl(translator.get(Translator.Translation.TAG_REDSTONE));
        this.golemProfile = new GolemProfileImpl(translator.get(Translator.Translation.TAG_GOLEM));
    }

    public Profile emptyProfile() {
        return EMPTY_PROFILE;
    }

    public Profile fromDisplayText(String text) {
        String stripped = ChatColor.stripColor((String)text.trim());
        if (stripped.length() > 2) {
            if (this.everyoneTagList.stream().anyMatch(s -> s.equalsIgnoreCase(stripped))) {
                return new EveryoneProfileImpl(stripped.substring(1, stripped.length() - 1));
            }
            if (this.redstoneTagList.stream().anyMatch(s -> s.equalsIgnoreCase(stripped))) {
                return new RedstoneProfileImpl(stripped.substring(1, stripped.length() - 1));
            }
            if (this.golemTagList.stream().anyMatch(s -> s.equalsIgnoreCase(stripped))) {
                return new GolemProfileImpl(stripped.substring(1, stripped.length() - 1));
            }
            if (this.timerTagStart.stream().anyMatch(s -> StringUtil.startsWithIgnoreCase((String)stripped, (String)s) && stripped.endsWith("]"))) {
                return this.readTimerProfile(stripped);
            }
            if (stripped.startsWith("[") && stripped.endsWith("]")) {
                return new GroupProfileImpl(this.groupSystem, stripped.substring(1, stripped.length() - 1));
            }
            if (stripped.startsWith("+") && stripped.endsWith("+")) {
                return new GroupLeaderProfileImpl(this.groupSystem, stripped.substring(1, stripped.length() - 1));
            }
            int hashCharIndex = stripped.indexOf(35);
            if (hashCharIndex > 0) {
                String name = stripped.substring(0, hashCharIndex);
                try {
                    UUID uuid = UUID.fromString(stripped.substring(hashCharIndex + 1));
                    return new PlayerProfileImpl(name, Optional.of(uuid));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return new PlayerProfileImpl(stripped, Optional.empty());
    }

    @Override
    public Profile fromEveryone() {
        return this.everyoneProfile;
    }

    @Override
    public PlayerProfile fromNameAndUniqueId(String name, Optional<UUID> uuid) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        Preconditions.checkNotNull(uuid, (Object)"uuid");
        return new PlayerProfileImpl(name, uuid);
    }

    @Override
    public PlayerProfile fromPlayer(Player player) {
        Preconditions.checkNotNull((Object)player);
        Optional<UUID> uuid = Optional.of(player.getUniqueId());
        return new PlayerProfileImpl(player.getName(), uuid);
    }

    @Override
    public Profile fromRedstone() {
        return this.redstoneProfile;
    }

    @Override
    public Profile fromGolem() {
        return this.golemProfile;
    }

    public Optional<Profile> fromSavedObject(SecretSignEntry object) {
        Optional<String> name = object.getString("n");
        if (name.isPresent()) {
            Optional<UUID> uuid = object.getUniqueId("u");
            PlayerProfileImpl profile = new PlayerProfileImpl(name.get(), uuid);
            return Optional.of(profile);
        }
        Optional<Boolean> isEveryone = object.getBoolean("e");
        if (isEveryone.isPresent()) {
            return Optional.of(this.everyoneProfile);
        }
        Optional<Boolean> isRedstone = object.getBoolean("r");
        if (isRedstone.isPresent()) {
            return Optional.of(this.redstoneProfile);
        }
        Optional<Boolean> isGolem = object.getBoolean("go");
        if (isGolem.isPresent()) {
            return Optional.of(this.golemProfile);
        }
        OptionalInt secondsOpen = object.getInteger("t");
        if (secondsOpen.isPresent()) {
            TimerProfileImpl profile = new TimerProfileImpl(this.translator.getWithoutColor(Translator.Translation.TAG_TIMER), secondsOpen.getAsInt());
            return Optional.of(profile);
        }
        Optional<String> groupName = object.getString("g");
        if (groupName.isPresent()) {
            GroupProfileImpl profile = new GroupProfileImpl(this.groupSystem, groupName.get());
            return Optional.of(profile);
        }
        groupName = object.getString("l");
        if (groupName.isPresent()) {
            GroupLeaderProfileImpl profile = new GroupLeaderProfileImpl(this.groupSystem, groupName.get());
            return Optional.of(profile);
        }
        return Optional.empty();
    }

    private int readDigit(char digit) {
        try {
            return Integer.parseInt(String.valueOf(digit));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private Profile readTimerProfile(String text) {
        String tagStart = this.timerTagStart.stream().filter(tag -> StringUtil.startsWithIgnoreCase((String)text, (String)tag) && text.endsWith("]")).findFirst().orElse(null);
        char digit = text.charAt(tagStart.length());
        if (digit == ' ') {
            digit = text.charAt(tagStart.length() + 1);
        }
        int seconds = this.readDigit(digit);
        return new TimerProfileImpl(tagStart.substring(1, tagStart.length() - 1), seconds);
    }
}

