/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.blocklocker.impl.profile;

import java.util.Date;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import nl.rutgerkok.blocklocker.SecretSignEntry;
import nl.rutgerkok.blocklocker.profile.PlayerProfile;
import nl.rutgerkok.blocklocker.profile.Profile;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

class PlayerProfileImpl
implements PlayerProfile {
    static final String NAME_KEY = "n";
    static final String UUID_KEY = "u";
    private String displayName;
    private final Optional<UUID> uuid;

    PlayerProfileImpl(String displayName, Optional<UUID> uuid) {
        this.displayName = displayName;
        this.uuid = uuid;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        PlayerProfileImpl otherProfile = (PlayerProfileImpl)other;
        if (this.uuid.isPresent() != otherProfile.uuid.isPresent()) {
            return false;
        }
        if (this.uuid.isPresent()) {
            return this.uuid.equals(otherProfile.uuid);
        }
        return this.displayName.equals(otherProfile.displayName);
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void getSaveObject(SecretSignEntry entry) {
        entry.setString(NAME_KEY, this.displayName);
        if (this.uuid.isPresent()) {
            entry.setUniqueId(UUID_KEY, this.uuid.get());
        }
    }

    @Override
    public Optional<UUID> getUniqueId() {
        return this.uuid;
    }

    public int hashCode() {
        if (this.uuid.isPresent()) {
            return this.uuid.hashCode();
        }
        return this.displayName.toLowerCase(Locale.ROOT).hashCode();
    }

    @Override
    public boolean includes(Profile other) {
        if (!(other instanceof PlayerProfile)) {
            return false;
        }
        PlayerProfile otherProfile = (PlayerProfile)other;
        if (this.uuid.isPresent()) {
            return this.uuid.equals(otherProfile.getUniqueId());
        }
        return this.displayName.equalsIgnoreCase(otherProfile.getDisplayName());
    }

    @Override
    public boolean isExpired(Date cutoffDate) {
        if (this.uuid.isPresent()) {
            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)this.uuid.get());
            if (player.isOnline()) {
                return false;
            }
            return player.getLastPlayed() <= cutoffDate.getTime();
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[uuid=" + String.valueOf(this.uuid.orElse(null)) + ",name=" + this.displayName + "]";
    }
}

