/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.blocklocker.impl.profile;

import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import nl.rutgerkok.blocklocker.SecretSignEntry;
import nl.rutgerkok.blocklocker.group.GroupSystem;
import nl.rutgerkok.blocklocker.profile.PlayerProfile;
import nl.rutgerkok.blocklocker.profile.Profile;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

class GroupLeaderProfileImpl
implements Profile {
    static final String GROUP_LEADER_KEY = "l";
    private String groupName;
    private final GroupSystem groupSystem;

    GroupLeaderProfileImpl(GroupSystem groupSystem, String groupName) {
        this.groupSystem = (GroupSystem)Preconditions.checkNotNull((Object)groupSystem);
        this.groupName = (String)Preconditions.checkNotNull((Object)groupName);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        GroupLeaderProfileImpl otherProfile = (GroupLeaderProfileImpl)other;
        return this.groupName.equalsIgnoreCase(otherProfile.groupName);
    }

    @Override
    public String getDisplayName() {
        return "+" + this.groupName + "+";
    }

    @Override
    public void getSaveObject(SecretSignEntry entry) {
        entry.setString(GROUP_LEADER_KEY, this.groupName);
    }

    public int hashCode() {
        return ~this.groupName.toLowerCase(Locale.ROOT).hashCode();
    }

    @Override
    public boolean includes(Profile other) {
        if (!(other instanceof PlayerProfile)) {
            return false;
        }
        PlayerProfile playerProfile = (PlayerProfile)other;
        Optional<UUID> uuid = playerProfile.getUniqueId();
        if (!uuid.isPresent()) {
            return false;
        }
        Player player = Bukkit.getPlayer((UUID)uuid.get());
        if (player == null) {
            return false;
        }
        return this.groupSystem.isGroupLeader(player, this.groupName);
    }

    @Override
    public boolean isExpired(Date cutoffDate) {
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.groupName + "]";
    }
}

