/*
 * Decompiled with CFR 0.152.
 */
package nl.rutgerkok.blocklocker.impl.group;

import me.glaremasters.guilds.Guilds;
import me.glaremasters.guilds.api.GuildsAPI;
import me.glaremasters.guilds.guild.Guild;
import me.glaremasters.guilds.guild.GuildMember;
import nl.rutgerkok.blocklocker.group.GroupSystem;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public final class GuildsGroupSystem
extends GroupSystem {
    public static boolean isAvailable() {
        try {
            JavaPlugin.getProvidingPlugin(GuildsAPI.class);
            return true;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    @Override
    public boolean isGroupLeader(Player player, String groupName) {
        Guild guild = Guilds.getApi().getGuild((OfflinePlayer)player);
        if (guild == null) {
            return false;
        }
        GuildMember master = guild.getGuildMaster();
        if (master == null) {
            return false;
        }
        if (!master.getUuid().equals(player.getUniqueId())) {
            return false;
        }
        return guild.getName().equalsIgnoreCase(groupName);
    }

    @Override
    public boolean isInGroup(Player player, String groupName) {
        Guild guild = Guilds.getApi().getGuild((OfflinePlayer)player);
        if (guild == null) {
            return false;
        }
        return guild.getName().equalsIgnoreCase(groupName);
    }

    @Override
    public boolean keepOnReload() {
        return false;
    }
}

